/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.block.FluidBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gtolib.api.machine.feature.multiblock.IFluidRendererMachine;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;

public class FluidRenderer
extends WorkableCasingMachineRenderer {
    protected final FluidBlockRenderer fluidBlockRenderer = FluidBlockRenderer.Builder.create().setForcedLight(0xF000F0).getRenderer();

    public static Supplier<IRenderer> create(ResourceLocation baseCasing, ResourceLocation workableModel) {
        return () -> new FluidRenderer(baseCasing, workableModel);
    }

    protected FluidRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        super(baseCasing, workableModel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 96;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
        if (!ConfigHolder.INSTANCE.client.renderer.renderFluids) {
            return;
        }
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity mm = (MetaMachineBlockEntity)blockEntity;
            this.renderFluid(mm.getMetaMachine(), stack, buffer, combinedLight, combinedOverlay);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderFluid(MetaMachine metaMachine, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (metaMachine instanceof IFluidRendererMachine) {
            IFluidRendererMachine machine = (IFluidRendererMachine)metaMachine;
            Fluid cachedFluid = machine.getCachedFluid();
            if (cachedFluid == null) {
                return;
            }
            stack.m_85836_();
            this.fluidBlockRenderer.drawBlocks(machine.getFluidBlockOffsets(), stack.m_85850_().m_252922_(), buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)ItemBlockRenderTypes.m_109287_((FluidState)cachedFluid.m_76145_()), (boolean)false)), cachedFluid, RenderUtil.FluidTextureType.STILL, combinedOverlay, combinedLight);
            stack.m_85849_();
        }
    }
}

