/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gtolib.GTOCore;
import com.gtolib.api.machine.feature.ITemperatureMachine;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public interface IHeaterRenderer {
    @Contract(value="_, _, _, _, _, _, _, _ -> new")
    @NotNull
    public static BakedQuad bakeQuad(AABB layer, float renderHeight, Direction face, ResourceLocation texture, ModelState modelState, boolean isEmissive, int tint, boolean mirror) {
        return StaticFaceBakery.bakeQuad((Vector3f)new Vector3f((float)layer.f_82288_ * 16.0f, (float)layer.f_82289_ * 16.0f, (float)layer.f_82290_ * 16.0f), (Vector3f)new Vector3f((float)layer.f_82291_ * 16.0f, (float)layer.f_82292_ * 16.0f * renderHeight, (float)layer.f_82293_ * 16.0f), (BlockElementFace)new BlockElementFace(null, tint, "", new BlockFaceUV(IHeaterRenderer.getTempUV(renderHeight, mirror), 0)), (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)texture), (Direction)face, (ModelState)modelState, null, (boolean)true, (int)(isEmissive ? 15 : 0));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static float @NotNull [] getTempUV(float tempRatio, boolean mirror) {
        if (mirror) {
            return new float[]{16.0f, 15.0f - tempRatio * 14.0f, 0.0f, 16.0f};
        }
        return new float[]{0.0f, 15.0f - tempRatio * 14.0f, 16.0f, 16.0f};
    }

    default public void renderHeater(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        ITemperatureMachine heater;
        block4: {
            block3: {
                if (!(machine instanceof ITemperatureMachine)) break block3;
                heater = (ITemperatureMachine)machine;
                if (side != null) break block4;
            }
            return;
        }
        int heatLevel = heater.getSignal(side);
        int temp = heater.getTemperature();
        int maxTemp = heater.getMaxTemperature();
        float tempRatio = Math.min(1.0f, (float)temp / (float)maxTemp);
        Direction leftFacing = RelativeDirection.LEFT.getRelative(machine.getFrontFacing(), machine.getUpwardsFacing(), false);
        Direction rightFacing = RelativeDirection.RIGHT.getRelative(machine.getFrontFacing(), machine.getUpwardsFacing(), false);
        leftFacing = ModelFactory.modelFacing((Direction)frontFacing, (Direction)leftFacing);
        rightFacing = ModelFactory.modelFacing((Direction)frontFacing, (Direction)rightFacing);
        for (Direction direction : new Direction[]{leftFacing, rightFacing}) {
            boolean mirror = direction == rightFacing;
            quads.add(IHeaterRenderer.bakeQuad(Wrapper.layer0, 1.0f, direction, Wrapper.BG_OVERLAY, modelState, false, TemperatureLevel.getTintByTemperature(heatLevel), mirror));
            quads.add(IHeaterRenderer.bakeQuad(Wrapper.layer1, tempRatio, direction, Wrapper.TEMP_OVERLAY, modelState, true, -1, mirror));
            quads.add(IHeaterRenderer.bakeQuad(Wrapper.layer2, 1.0f, direction, Wrapper.METER_OVERLAY, modelState, false, -1, mirror));
        }
    }

    public static final class Wrapper {
        private static final float DEFLATE_Y = 0.0625f;
        static final ResourceLocation TEMP_OVERLAY = GTOCore.id((String)"block/machines/heater/temp");
        static final ResourceLocation METER_OVERLAY = GTOCore.id((String)"block/machines/heater/meter");
        static final ResourceLocation BG_OVERLAY = GTOCore.id((String)"block/machines/heater/bg");
        static final AABB layer0 = StaticFaceBakery.SLIGHTLY_OVER_BLOCK.m_165897_(0.0, 0.0625, 0.0).m_82400_((double)1.0E-5f);
        static final AABB layer1 = layer0.m_82400_((double)5.0E-4f);
        static final AABB layer2 = layer0.m_82400_((double)0.001f);
    }

    public static enum TemperatureLevel {
        COLD(0, 5, 0xFFFFFF),
        WARM(6, 9, 15785883),
        HOT(10, 12, 16756569),
        VERY_HOT(13, 15, 16749401);

        private final int minLevel;
        private final int maxLevel;
        private final int tint;

        private TemperatureLevel(int minLevel, int maxLevel, int tint) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.tint = tint;
        }

        static int getTintByTemperature(int temperature) {
            for (TemperatureLevel level : TemperatureLevel.values()) {
                if (temperature < level.minLevel || temperature > level.maxLevel) continue;
                return level.tint;
            }
            return TemperatureLevel.COLD.tint;
        }
    }
}

