/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gtocore.api.machine.IMultiFluidRendererMachine;
import com.gtocore.client.renderer.machine.FluidRenderer;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.RenderTypeHelper;

public class MultiFluidRenderer
extends FluidRenderer {
    public static Supplier<IRenderer> create(ResourceLocation baseCasing, ResourceLocation workableModel) {
        return () -> new MultiFluidRenderer(baseCasing, workableModel);
    }

    protected MultiFluidRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        super(baseCasing, workableModel);
    }

    @Override
    protected void renderFluid(MetaMachine metaMachine, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.renderFluid(metaMachine, stack, buffer, combinedLight, combinedOverlay);
        if (metaMachine instanceof IMultiFluidRendererMachine) {
            IMultiFluidRendererMachine machine = (IMultiFluidRendererMachine)metaMachine;
            for (Map.Entry entry : machine.getFluidBlockOffsets().asMap().entrySet()) {
                Fluid fluid = (Fluid)entry.getKey();
                if (fluid == null) continue;
                Collection positions = (Collection)entry.getValue();
                stack.m_85836_();
                this.fluidBlockRenderer.drawBlocks(positions.stream().filter(Objects::nonNull).map(p -> p.m_121955_(Vec3i.f_123288_.m_121996_((Vec3i)metaMachine.getPos()))).collect(Collectors.toSet()), stack.m_85850_().m_252922_(), buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)ItemBlockRenderTypes.m_109287_((FluidState)fluid.m_76145_()), (boolean)false)), fluid, RenderUtil.FluidTextureType.STILL, combinedOverlay, combinedLight);
                stack.m_85849_();
            }
        }
    }
}

