/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gtocore.client.renderer.GTORenderTypes;
import com.gtocore.client.renderer.RenderHelper;
import com.gtocore.common.machine.multiblock.electric.space.SuperSpaceElevatorMachine;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.SpaceElevatorConnectorModule;
import com.gtolib.GTOCore;
import com.gtolib.utils.ClientUtil;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

public final class SpaceElevatorConnectorModuleRenderer
extends WorkableCasingMachineRenderer {
    private static final ResourceLocation CLIMBER_MODEL = GTOCore.id((String)"obj/climber");
    private static final ResourceLocation CABLE_TEXTURE = GTOCore.id((String)"block/obj/climber_cable");

    public SpaceElevatorConnectorModuleRenderer() {
        super(GTOCore.id((String)"block/casings/spacecraft_dynamic_protective_mechanical_casing"), GTCEu.id((String)"block/multiblock/fusion_reactor"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        SpaceElevatorConnectorModule machine;
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof SpaceElevatorConnectorModule && (machine = (SpaceElevatorConnectorModule)metaMachine).isFormed() && (machine.getMaxTier() > 0 || blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
            double x = 0.5;
            double y = -15.0;
            double z = 0.5;
            switch (machine.getFrontFacing().m_122424_()) {
                case NORTH: {
                    z = 2.5;
                    break;
                }
                case SOUTH: {
                    z = -1.5;
                    break;
                }
                case WEST: {
                    x = 2.5;
                    break;
                }
                case EAST: {
                    x = -1.5;
                }
            }
            poseStack.m_85836_();
            poseStack.m_272245_(Axis.f_252393_.m_252977_(180.0f), (float)x, (float)y, (float)z);
            poseStack.m_272245_(Axis.f_252436_.m_252977_((float)machine.getOffsetTimer() / 16.0f), (float)x, (float)y, (float)z);
            for (float i = (-partialTicks - (float)machine.getOffsetTimer()) % 32.0f / 16.0f - 1.0f; i < 360.0f; i += 2.0f) {
                RenderHelper.renderTexturedCylinder(poseStack, buffer.m_6299_(GTORenderTypes.LIGHT_CYLINDER_TEXTURED), (float)x, (float)y + i, (float)z, 2.2f, 2.0f, 16, CABLE_TEXTURE, 0.0f, 0.0f, 1.0f, 1.0f);
            }
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(x, y - machine.getHigh(), z);
            SpaceElevatorConnectorModuleRenderer.RendererModel(poseStack, buffer, 12.0f, CLIMBER_MODEL);
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static void RendererModel(PoseStack poseStack, MultiBufferSource buffer, float scale, ResourceLocation climberModel) {
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        ClientUtil.modelRenderer().renderModel(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110451_()), null, ClientUtil.getBakedModel((ResourceLocation)climberModel), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110451_());
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        super.onAdditionalModel(registry);
        registry.accept(CLIMBER_MODEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRender(BlockEntity blockEntity, Vec3 cameraPos) {
        if (blockEntity instanceof MetaMachineBlockEntity) {
            SuperSpaceElevatorMachine machine;
            MetaMachineBlockEntity machineBlockEntity = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = machineBlockEntity.getMetaMachine();
            return metaMachine instanceof SuperSpaceElevatorMachine && (machine = (SuperSpaceElevatorMachine)metaMachine).isFormed() && (machine.getSpoolCount() >= machine.getMaxSpoolCount() || blockEntity.m_58904_() instanceof TrackedDummyWorld) || super.shouldRender(blockEntity, cameraPos);
        }
        return super.shouldRender(blockEntity, cameraPos);
    }
}

