/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gtocore.common.machine.multiblock.part.InfiniteIntakeHatchPartMachine;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class AirVentCover
extends CoverBehavior {
    private TickableSubscription subscription;
    private MetaMachine machine;

    public AirVentCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    public boolean canAttach() {
        return super.canAttach() && (this.machine = MetaMachine.getMachine((BlockEntity)this.coverHolder.holder())) != null && this.machine.getFluidHandlerCap(this.attachedSide, false) != null;
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.coverHolder.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
                this.machine = MetaMachine.getMachine((BlockEntity)this.coverHolder.holder());
                this.subscription = this.coverHolder.subscribeServerTick(this.subscription, this::update, 20);
            }));
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    private void update() {
        if (this.machine != null && this.machine.getNeighborBlockState(this.attachedSide).m_60795_()) {
            Fluid fluid = InfiniteIntakeHatchPartMachine.AIR_MAP.get(this.coverHolder.getLevel().m_46472_().m_135782_());
            if (fluid == null) {
                this.subscription.unsubscribe();
                return;
            }
            IFluidHandlerModifiable handler = this.machine.getFluidHandlerCap(this.attachedSide, false);
            if (handler == null) {
                return;
            }
            handler.fill(new FluidStack(fluid, 200), IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

