/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.data;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.client.renderer.cover.ConveyorCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.FluidRegulatorCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.PumpCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.RobotArmCoverRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.SimpleCoverRenderer;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.FluidRegulatorCover;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.RobotArmCover;
import com.gregtechceu.gtceu.common.data.GTCovers;
import com.gtocore.common.cover.AirVentCover;
import com.gtocore.common.cover.PowerAmplifierCover;
import com.gtocore.common.cover.SteamPumpCover;
import com.gtocore.common.cover.WirelessChargerCover;
import com.gtolib.GTOCore;
import com.hepdd.gtmthings.GTMThings;
import com.hepdd.gtmthings.common.cover.WirelessEnergyReceiveCover;
import java.util.Locale;

public final class GTOCovers {
    static final CoverDefinition WIRELESS_CHARGER_COVER = GTCovers.register((String)"wireless_charger_cover", WirelessChargerCover::new, (ICoverRenderer)new SimpleCoverRenderer(GTOCore.id((String)"item/wireless_charger_cover")));
    private static final ICoverRenderer POWER_AMPLIFIER = new SimpleCoverRenderer(GTOCore.id((String)"block/overlay/machine/overclock_config"));
    static final CoverDefinition[] POWER_AMPLIFIERS = GTCovers.registerTiered((String)"power_amplifier", PowerAmplifierCover::new, tier -> POWER_AMPLIFIER, (int[])GTValues.tiersBetween((int)1, (int)6));
    static final CoverDefinition AIR_VENT = GTCovers.register((String)"air_vent", AirVentCover::new, (ICoverRenderer)new SimpleCoverRenderer(GTOCore.id((String)"block/machines/vacuum_pump/overlay_top")));
    static final CoverDefinition STEAM_PUMP = GTCovers.register((String)"steam_pump", SteamPumpCover::new, (ICoverRenderer)PumpCoverRenderer.INSTANCE);
    static final CoverDefinition ELECTRIC_PUMP_ULV = GTCovers.register((String)"pump.ulv", (def, coverable, side) -> new PumpCover(def, coverable, side, 0), (ICoverRenderer)PumpCoverRenderer.INSTANCE);
    static final CoverDefinition FLUID_REGULATOR_ULV = GTCovers.register((String)"fluid_regulator.ulv", (def, coverable, side) -> new FluidRegulatorCover(def, coverable, side, 0), (ICoverRenderer)FluidRegulatorCoverRenderer.INSTANCE);
    static final CoverDefinition CONVEYOR_MODULE_ULV = GTCovers.register((String)"conveyor.ulv", (def, coverable, side) -> new ConveyorCover(def, coverable, side, 0), (ICoverRenderer)ConveyorCoverRenderer.INSTANCE);
    static final CoverDefinition ROBOT_ARM_ULV = GTCovers.register((String)"robot_arm.ulv", (def, coverable, side) -> new RobotArmCover(def, coverable, side, 0), (ICoverRenderer)RobotArmCoverRenderer.INSTANCE);
    static final CoverDefinition ELECTRIC_PUMP_MAX = GTCovers.register((String)"pump.max", (def, coverable, side) -> new PumpCover(def, coverable, side, 14), (ICoverRenderer)PumpCoverRenderer.INSTANCE);
    static final CoverDefinition CONVEYOR_MODULE_MAX = GTCovers.register((String)"conveyor.max", (def, coverable, side) -> new ConveyorCover(def, coverable, side, 14), (ICoverRenderer)ConveyorCoverRenderer.INSTANCE);
    static final CoverDefinition ROBOT_ARM_MAX = GTCovers.register((String)"robot_arm.max", (def, coverable, side) -> new RobotArmCover(def, coverable, side, 14), (ICoverRenderer)RobotArmCoverRenderer.INSTANCE);
    public static final CoverDefinition MAX_WIRELESS_ENERGY_RECEIVE = GTOCovers.registerTieredWirelessCover("wireless_energy_receive", 1);
    public static final CoverDefinition MAX_WIRELESS_ENERGY_RECEIVE_4A = GTOCovers.registerTieredWirelessCover("4a_wireless_energy_receive", 4);

    private static CoverDefinition registerTieredWirelessCover(String id, int amperage) {
        String name = id + "." + GTValues.VN[14].toLowerCase(Locale.ROOT);
        return GTCovers.register((String)name, (holder, coverable, side) -> new WirelessEnergyReceiveCover(holder, coverable, side, 14, amperage), (ICoverRenderer)new SimpleCoverRenderer(GTMThings.id((String)("block/cover/overlay_" + (amperage == 1 ? "" : "4a_") + "wireless_energy_receive"))));
    }

    public static void init() {
    }
}

