/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.data;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gtocore.data.lang.LangHandler;
import com.gtolib.GTOCore;
import com.gtolib.api.lang.CNEN;
import java.util.Map;

public class GTOFluidStorageKey {
    public static final Map<String, CNEN> LANG = GTCEu.isDataGen() ? new O2OOpenCacheHashMap() : null;
    public static final FluidStorageKey ENERGY_STORAGE_ANODE = GTOFluidStorageKey.key("energy_storage_anode", "%s\u50a8\u80fd\u9633\u6781\u6db2", "%s Energy Storage Anode");
    public static final FluidStorageKey ENERGY_STORAGE_CATHODE = GTOFluidStorageKey.key("energy_storage_cathode", "%s\u50a8\u80fd\u9634\u6781\u6db2", "%s Energy Storage Cathode");
    public static final FluidStorageKey ENERGY_RELEASE_ANODE = GTOFluidStorageKey.key("energy_release_anode", "%s\u91ca\u80fd\u9633\u6781\u6db2", "%s Energy Release Anode");
    public static final FluidStorageKey ENERGY_RELEASE_CATHODE = GTOFluidStorageKey.key("energy_release_cathode", "%s\u91ca\u80fd\u9634\u6781\u6db2", "%s Energy Release Cathode");
    public static final FluidStorageKey HIGH_PRESSURE_GAS = GTOFluidStorageKey.key("high_pressure_gas", "\u9ad8\u538b%s", "High Pressure %s");

    public static void initLang() {
        LANG.forEach((k, v) -> LangHandler.addCNEN("gtocore.fluid." + k, v.cn(), v.en()));
    }

    private static FluidStorageKey key(String id, String cn, String en) {
        if (LANG != null) {
            LANG.put(id, new CNEN(cn, en));
        }
        return new FluidStorageKey(GTOCore.id((String)id), MaterialIconType.liquid, m -> m.getName() + "_" + id, m -> "gtocore.fluid." + id, FluidState.LIQUID, 0);
    }
}

