/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.data;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gtocore.common.data.GTOCreativeModeTabs;
import com.gtocore.common.fluid.GelidCryotheumFluid;
import com.gtocore.common.fluid.types.GelidCryotheumFluidType;
import com.gtolib.GTOCore;
import com.gtolib.api.registries.GTORegistration;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class GTOFluids {
    public static final Map<String, String> LANG = GTCEu.isDataGen() ? new O2OOpenCacheHashMap() : null;
    public static final DeferredRegister<FluidType> FLUID_TYPE = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"gtocore");
    public static final RegistryObject<FluidType> GELID_CRYOTHEUM_TYPE = FLUID_TYPE.register("gelid_cryotheum", GelidCryotheumFluidType::new);
    public static final DeferredRegister<Fluid> FLUID = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"gtocore");
    public static final RegistryObject<FlowingFluid> GELID_CRYOTHEUM = FLUID.register("gelid_cryotheum", GelidCryotheumFluid.Source::new);
    public static final RegistryObject<FlowingFluid> FLOWING_GELID_CRYOTHEUM = FLUID.register("flowing_gelid_cryotheum", GelidCryotheumFluid.Flowing::new);
    public static final FluidEntry<? extends ForgeFlowingFluid> NUTRIENT_DISTILLATION = GTOFluids.fluid("nutrient_distillation", "\u8425\u517b\u7cbe\u534e\u6db2").properties(p -> p.density(1500).viscosity(3000)).register();
    public static final FluidEntry<? extends ForgeFlowingFluid> DEW_OF_THE_VOID = GTOFluids.fluid("dew_of_the_void", "\u865a\u7a7a\u9732\u6c34").properties(p -> p.density(200).viscosity(1000).temperature(175)).lang("Fluid of the Void").register();
    public static final FluidEntry<? extends ForgeFlowingFluid> VAPOR_OF_LEVITY = GTOFluids.gasFluid("vapor_of_levity", "\u8f7b\u76c8\u4e4b\u6c14").properties(p -> p.density(-10).viscosity(100).temperature(5)).register();
    public static final FluidEntry<? extends ForgeFlowingFluid> HOOTCH = GTOFluids.fluid("hootch", "\u70c8\u9152").properties(p -> p.density(900).viscosity(1000)).register();
    public static final FluidEntry<? extends ForgeFlowingFluid> FIRE_WATER = GTOFluids.fluid("fire_water", "\u706b\u7130\u6c34").properties(p -> p.density(900).viscosity(1000).temperature(2000)).register();
    public static final FluidEntry<? extends ForgeFlowingFluid> XP_JUICE = GTOFluids.fluid("xp_juice", "\u7ecf\u9a8c\u6c41").properties(p -> p.lightLevel(10).density(800).viscosity(1500)).lang("XP Juice").register();
    public static final FluidEntry<? extends ForgeFlowingFluid> LIQUID_SUNSHINE = GTOFluids.fluid("liquid_sunshine", "\u6db2\u6001\u9633\u5149").properties(p -> p.density(200).viscosity(400)).register();
    public static final FluidEntry<? extends ForgeFlowingFluid> CLOUD_SEED = GTOFluids.fluid("cloud_seed", "\u4e91\u4e4b\u7cbe\u534e").properties(p -> p.density(500).viscosity(800)).register();
    public static final FluidEntry<? extends ForgeFlowingFluid> CLOUD_SEED_CONCENTRATED = GTOFluids.fluid("cloud_seed_concentrated", "\u6d53\u7f29\u4e91\u4e4b\u7cbe\u534e").properties(p -> p.density(1000).viscosity(1200)).register();

    private static FluidBuilder<? extends ForgeFlowingFluid, Registrate> fluid(String name, String cn) {
        return (FluidBuilder)GTOFluids.baseFluid(name, cn).bucket().model(GTOFluids::bucketModel).tab(GTOCreativeModeTabs.GTO_MATERIAL_FLUID.getKey()).build();
    }

    private static FluidBuilder<? extends ForgeFlowingFluid, Registrate> gasFluid(String name, String cn) {
        return (FluidBuilder)GTOFluids.baseFluid(name, cn).bucket().model((ctx, prov) -> GTOFluids.bucketModel((DataGenContext<Item, BucketItem>)ctx, prov).flipGas(true)).tab(GTOCreativeModeTabs.GTO_MATERIAL_FLUID.getKey()).build();
    }

    private static FluidBuilder<? extends ForgeFlowingFluid, Registrate> baseFluid(String name, String cn) {
        FluidBuilder thing = GTORegistration.GTO.fluid(name, GTOCore.id((String)("block/fluid/fluid_" + name + "_still")), GTOCore.id((String)("block/fluid/fluid_" + name + "_flowing")));
        if (FMLEnvironment.dist.isClient()) {
            thing.renderType(RenderType::m_110466_);
        }
        if (LANG != null) {
            LANG.put(name, cn);
        }
        return (FluidBuilder)thing.source(ForgeFlowingFluid.Source::new).block().build();
    }

    private static DynamicFluidContainerModelBuilder<ItemModelBuilder> bucketModel(DataGenContext<Item, BucketItem> ctx, RegistrateItemModelProvider prov) {
        return ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("forge", "item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(((BucketItem)ctx.get()).getFluid());
    }
}

