/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gtocore.api.lang.ComponentListSupplier;
import com.gtocore.api.placeholder.IPlaceholder;
import com.gtocore.data.recipe.research.AnalyzeData;
import com.gtolib.api.item.tool.IExDataItem;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.RegistriesUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DataCrystalItem
extends Item
implements IExDataItem,
IPlaceholder<Object, ItemStack, Void> {
    public DataCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public boolean requireDataBank() {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int serial;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("empty_crystal")) {
            tooltip.add((Component)Component.m_237115_((String)"gtocore.tooltip.item.empty_data").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.empty_serial", (Object[])new Object[]{Component.m_237113_((String)String.format("%08X", 0)).m_130940_(ChatFormatting.YELLOW)}));
        }
        if (tag.m_128441_("scanning_research")) {
            CompoundTag scanningTag = tag.m_128469_("scanning_research");
            serial = scanningTag.m_128451_("scanning_serial");
            String scanningId = scanningTag.m_128461_("scanning_id");
            tooltip.add((Component)Component.m_237115_((String)"gtocore.tooltip.item.scanning_data").m_130940_(ChatFormatting.AQUA));
            Object scanned = DataCrystalItem.parseTargetFromScanningId(scanningId);
            if (scanned instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)scanned;
                tooltip.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.scanned_things", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(itemStack.m_41613_())).m_130940_(ChatFormatting.GREEN), itemStack.m_41611_().m_6881_().m_130940_(ChatFormatting.GOLD)}));
            } else if (scanned instanceof FluidStack) {
                FluidStack fluidStack = (FluidStack)scanned;
                tooltip.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.scanned_things", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(fluidStack.getAmount())).m_130940_(ChatFormatting.GREEN), fluidStack.getDisplayName().m_6881_().m_130940_(ChatFormatting.LIGHT_PURPLE)}));
            }
            tooltip.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.scanning_serial", (Object[])new Object[]{Component.m_237113_((String)String.format("%08X", serial)).m_130940_(ChatFormatting.YELLOW)}));
        }
        if (tag.m_128441_("analyze_research")) {
            CompoundTag analyzeTag = tag.m_128469_("analyze_research");
            serial = analyzeTag.m_128451_("analyze_serial");
            String analyzeId = analyzeTag.m_128461_("analyze_id");
            tooltip.add((Component)Component.m_237115_((String)"gtocore.tooltip.item.analyze_data").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.analyze_things", (Object[])new Object[]{Component.m_237113_((String)I18n.m_118938_((String)("gtocore.data." + analyzeId), (Object[])new Object[0])).m_130940_(ChatFormatting.GOLD)}));
            tooltip.add((Component)Component.m_237110_((String)"gtocore.tooltip.item.analyze_serial", (Object[])new Object[]{Component.m_237113_((String)String.format("%08X", serial)).m_130940_(ChatFormatting.YELLOW)}));
            ComponentListSupplier tooltipSupplier = AnalyzeData.INSTANCE.getTooltip(serial);
            if (tooltipSupplier != null) {
                tooltip.addAll((Collection<Component>)tooltipSupplier.get());
            }
        }
    }

    @Override
    public List<List<Object>> getTargetLists(ItemStack source) {
        Object target = this.getCurrentTarget(source, null);
        if (target == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Collections.singletonList(target));
    }

    @Override
    public Object getCurrentTarget(ItemStack source, Void context) {
        CompoundTag tag = source.m_41783_();
        if (tag == null || !tag.m_128441_("scanning_research")) {
            return null;
        }
        CompoundTag scanningTag = tag.m_128469_("scanning_research");
        String scanningId = scanningTag.m_128461_("scanning_id");
        return DataCrystalItem.parseTargetFromScanningId(scanningId);
    }

    @Nullable
    private static Object parseTargetFromScanningId(String idString) {
        Fluid fluid;
        Item item;
        String[] parts = idString.split("-", 3);
        if (parts.length != 3) {
            return null;
        }
        String countPart = parts[0];
        int count = Integer.parseInt(countPart.substring(0, countPart.length() - 1));
        String type = countPart.substring(countPart.length() - 1);
        String namespace = parts[1];
        String path = parts[2];
        if (type.equals("i") && (item = RegistriesUtils.getItem((String)namespace, (String)path)) != null && item != Items.f_41852_) {
            return new ItemStack((ItemLike)item, count);
        }
        if (type.equals("f") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(RLUtils.fromNamespaceAndPath((String)namespace, (String)path))) != null && fluid != Fluids.f_76191_) {
            return new FluidStack(fluid, count);
        }
        return null;
    }
}

