/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.fast.fastcollection.O2LOpenCacheHashMap;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.item.GregMembershipCardItem;
import com.gtolib.utils.WalletUtils;
import com.hepdd.gtmthings.api.gui.widget.SimpleNumberInputWidget;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PalmSizedBankBehavior
implements IItemUIFactory,
IFancyUIProvider {
    public static final PalmSizedBankBehavior INSTANCE = new PalmSizedBankBehavior();
    private static final String TEXT_HEADER = "gtocore.palm_sized_bank.textList.";

    @NotNull
    private static String text(int id) {
        return TEXT_HEADER + id;
    }

    @NotNull
    private static MutableComponent trans(int id, Object ... args) {
        if (args.length == 1 && args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        return Component.m_237110_((String)(TEXT_HEADER + id), (Object[])args);
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        this.openUI(itemStack.m_41720_(), context.m_43725_(), player, context.m_43724_());
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack heldItem = player.m_21120_(usedHand);
        this.openUI(item, level, player, usedHand);
        return InteractionResultHolder.m_19090_((Object)heldItem);
    }

    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, Player player) {
        return new ModularUI(176, 166, (IUIHolder)holder, player).widget((Widget)new FancyMachineUIWidget((IFancyUIProvider)this, 176, 166));
    }

    public Widget createMainPage(FancyMachineUIWidget widget2) {
        boolean hasWallet;
        int width = 192;
        int height = 144;
        WidgetGroup group = new WidgetGroup(0, 0, 200, 152);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 192, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
        group.addWidget((Widget)mainGroup);
        Player player = PalmSizedBankBehavior.getPlayerFromWidget(widget2);
        if (player == null) {
            return group;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = serverPlayer.m_284548_();
            hasWallet = WalletUtils.hasWallet((UUID)player.m_20148_(), (Level)serverLevel);
        } else {
            hasWallet = false;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(PalmSizedBankBehavior.trans(1, new Object[0]));
        list.add(PalmSizedBankBehavior.trans(2, new Object[0]));
        list.add(PalmSizedBankBehavior.trans(3, new Object[0]));
        list.add(PalmSizedBankBehavior.trans(4, new Object[0]));
        list.add(Component.m_237119_());
        if (hasWallet) {
            list.add(PalmSizedBankBehavior.trans(6, player.m_7755_().getString()).m_130940_(ChatFormatting.WHITE));
            list.add(PalmSizedBankBehavior.trans(7, player.m_20148_().toString()).m_130940_(ChatFormatting.GRAY));
            mainGroup.addWidget((Widget)new ComponentPanelWidget(10, 10, list).setMaxWidthLimit(172));
        } else {
            list.add(ComponentPanelWidget.withButton((Component)PalmSizedBankBehavior.trans(8, new Object[0]), (String)"Create a wallet"));
            mainGroup.addWidget((Widget)new ComponentPanelWidget(10, 10, list).clickHandler((a2, b2) -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ServerLevel serverLevel = serverPlayer.m_284548_();
                    WalletUtils.createAndInitializeWallet((UUID)player.m_20148_(), (Level)serverLevel, (String)player.m_7755_().getString());
                    PalmSizedBankBehavior.initNewPlayerCurrencies(player.m_20148_(), serverLevel);
                }
            }).setMaxWidthLimit(172));
        }
        return group;
    }

    public IGuiTexture getTabIcon() {
        return new ItemStackTexture(new Item[]{GTOItems.PALM_SIZED_BANK.m_5456_()});
    }

    public Component getTitle() {
        return GTOItems.PALM_SIZED_BANK.asStack().m_41611_();
    }

    @NotNull
    private IFancyUIProvider assetOverview(PalmSizedBankBehavior parentBehavior) {
        return new IFancyUIProvider(this){
            static final int width = 256;
            static final int height = 144;

            public IGuiTexture getTabIcon() {
                return GuiTextures.GREGTECH_LOGO;
            }

            public Component getTitle() {
                return GTOItems.PALM_SIZED_BANK.asStack().m_41611_();
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                ServerLevel serverLevel;
                WidgetGroup group = new WidgetGroup(0, 0, 264, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 256, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
                Player player = PalmSizedBankBehavior.getPlayerFromWidget(widget2);
                if (player == null) {
                    return group;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverLevel = serverPlayer.m_284548_();
                } else {
                    serverLevel = null;
                }
                ServerLevel serverLevel2 = serverLevel;
                mainGroup.addWidget((Widget)new ComponentPanelWidget(8, 4, List1 -> {
                    Object2LongMap syncedCurrencyMap = WalletUtils.getCurrencyMap((UUID)player.m_20148_(), (Level)serverLevel2);
                    List1.add(Component.m_237113_((String)"-------------------"));
                    List1.add(PalmSizedBankBehavior.trans(11, new Object[0]));
                    List1.add(Component.m_237113_((String)"-------------------"));
                    for (Object2LongMap.Entry entry : syncedCurrencyMap.object2LongEntrySet()) {
                        List1.add(Component.m_237115_((String)("gtocore.currency." + (String)entry.getKey())).m_130940_(ChatFormatting.AQUA));
                    }
                    List1.add(Component.m_237113_((String)"-------------------"));
                }));
                mainGroup.addWidget((Widget)new ComponentPanelWidget(132, 4, List2 -> {
                    Object2LongMap syncedCurrencyMap = WalletUtils.getCurrencyMap((UUID)player.m_20148_(), (Level)serverLevel2);
                    List2.add(Component.m_237113_((String)"-------------------"));
                    List2.add(PalmSizedBankBehavior.trans(12, new Object[0]));
                    List2.add(Component.m_237113_((String)"-------------------"));
                    for (Object2LongMap.Entry entry : syncedCurrencyMap.object2LongEntrySet()) {
                        List2.add(Component.m_237113_((String)Long.toString(entry.getLongValue())));
                    }
                    List2.add(Component.m_237113_((String)"-------------------"));
                }));
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }
        };
    }

    @NotNull
    private IFancyUIProvider transfer(PalmSizedBankBehavior parentBehavior) {
        return new IFancyUIProvider(this){
            @DescSynced
            private UUID uuid = null;
            @DescSynced
            private String string = null;
            @DescSynced
            private boolean confirm1 = false;
            @DescSynced
            private int tradeAmount = 0;
            static final int width = 256;
            static final int height = 144;

            public IGuiTexture getTabIcon() {
                return GuiTextures.GREGTECH_LOGO;
            }

            public Component getTitle() {
                return GTOItems.PALM_SIZED_BANK.asStack().m_41611_();
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                ServerLevel serverLevel;
                WidgetGroup group = new WidgetGroup(0, 0, 264, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 256, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
                Player player = PalmSizedBankBehavior.getPlayerFromWidget(widget2);
                if (player == null) {
                    return group;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverLevel = serverPlayer.m_284548_();
                } else {
                    serverLevel = null;
                }
                ServerLevel serverLevel2 = serverLevel;
                Object2ObjectMap WalletPlayers = WalletUtils.getAllWalletPlayers(serverLevel2);
                ObjectSet CurrencySet = WalletUtils.getCurrencyMap((UUID)player.m_20148_(), (Level)serverLevel2).keySet();
                mainGroup.addWidget((Widget)new ComponentPanelWidget(8, 4, List1 -> {
                    List1.add(Component.m_237113_((String)"-------------------"));
                    List1.add(PalmSizedBankBehavior.trans(50, new Object[0]));
                    List1.add(PalmSizedBankBehavior.trans(51, new Object[0]));
                    List1.add(PalmSizedBankBehavior.trans(52, new Object[0]));
                    List1.add(ComponentPanelWidget.withButton((Component)PalmSizedBankBehavior.trans(53, new Object[0]), (String)"confirm1"));
                    List1.add(Component.m_237113_((String)"-------------------"));
                    for (Object2ObjectMap.Entry entry : WalletPlayers.object2ObjectEntrySet()) {
                        List1.add(ComponentPanelWidget.withHoverTextTranslate((Component)ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("\u00a7b" + (String)entry.getValue() + "\u00a7r")), (String)((UUID)entry.getKey()).toString()), (Component)Component.m_237113_((String)((String)entry.getValue()))));
                    }
                }).clickHandler((a2, b2) -> {
                    if (a2.equals("confirm1")) {
                        this.confirm1 = true;
                    } else {
                        this.uuid = UUID.fromString(a2);
                        this.confirm1 = false;
                    }
                }));
                mainGroup.addWidget((Widget)new ComponentPanelWidget(132, 4, arg_0 -> this.lambda$createMainPage$2(WalletPlayers, (Set)CurrencySet, arg_0)).clickHandler((a2, b2) -> {
                    if (a2.equals("confirm2")) {
                        long Amount = WalletUtils.getCurrencyAmount((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.string);
                        if (Amount >= (long)this.tradeAmount) {
                            WalletUtils.subtractCurrency((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.string, (long)this.tradeAmount);
                            WalletUtils.addCurrency((UUID)this.uuid, (Level)serverLevel2, (String)this.string, (long)this.tradeAmount);
                        } else {
                            this.tradeAmount = Math.toIntExact(Amount);
                        }
                    } else {
                        this.string = a2;
                        this.confirm1 = false;
                    }
                }));
                mainGroup.addWidget((Widget)new SimpleNumberInputWidget(133, 35, 64, 8, () -> this.tradeAmount, newValue -> {
                    this.tradeAmount = newValue;
                    this.confirm1 = false;
                }));
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }

            private /* synthetic */ void lambda$createMainPage$2(Object2ObjectMap WalletPlayers, Set CurrencySet, List List2) {
                List2.add(Component.m_237113_((String)"-------------------"));
                List2.add(this.uuid != null ? Component.m_237115_((String)((String)WalletPlayers.get((Object)this.uuid))) : Component.m_237119_());
                List2.add(this.string != null ? Component.m_237115_((String)("gtocore.currency." + this.string)) : Component.m_237119_());
                List2.add(Component.m_237119_());
                List2.add(this.confirm1 ? ComponentPanelWidget.withButton((Component)PalmSizedBankBehavior.trans(54, new Object[0]), (String)"confirm2") : Component.m_237119_());
                List2.add(Component.m_237113_((String)"-------------------"));
                for (String entry : CurrencySet) {
                    List2.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)("gtocore.currency." + entry)), (String)entry));
                }
            }
        };
    }

    @NotNull
    private IFancyUIProvider tradeRecords(PalmSizedBankBehavior parentBehavior) {
        return new IFancyUIProvider(this){
            @DescSynced
            private String choose = null;
            static final int width = 256;
            static final int height = 144;

            public IGuiTexture getTabIcon() {
                return GuiTextures.GREGTECH_LOGO;
            }

            public Component getTitle() {
                return GTOItems.PALM_SIZED_BANK.asStack().m_41611_();
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                ServerLevel serverLevel;
                WidgetGroup group = new WidgetGroup(0, 0, 264, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 256, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
                Player player = PalmSizedBankBehavior.getPlayerFromWidget(widget2);
                if (player == null) {
                    return group;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverLevel = serverPlayer.m_284548_();
                } else {
                    serverLevel = null;
                }
                ServerLevel serverLevel2 = serverLevel;
                mainGroup.addWidget((Widget)new ComponentPanelWidget(245, 0, list -> list.add(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" \u21a9 "), (String)"return"))).clickHandler((a2, b2) -> {
                    this.choose = null;
                }));
                Set syncedTransactionKeys = WalletUtils.getTransactionKeys((UUID)player.m_20148_(), (Level)serverLevel2);
                mainGroup.addWidget((Widget)new ComponentPanelWidget(8, 4, List1 -> {
                    if (this.choose == null) {
                        List1.add(Component.m_237113_((String)"-------------------"));
                        List1.add(PalmSizedBankBehavior.trans(21, new Object[0]));
                        List1.add(Component.m_237113_((String)"-------------------"));
                        for (String entry : syncedTransactionKeys) {
                            List1.add(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("\u00a7b" + entry + "\u00a7r")), (String)entry));
                        }
                        List1.add(Component.m_237113_((String)"-------------------"));
                    } else {
                        List1.add(Component.m_237113_((String)"-------------------"));
                        List1.add(PalmSizedBankBehavior.trans(21, new Object[0]));
                        List1.add(PalmSizedBankBehavior.trans(22, new Object[0]));
                        List1.add(PalmSizedBankBehavior.trans(23, new Object[0]));
                        List1.add(PalmSizedBankBehavior.trans(24, new Object[0]));
                        List1.add(PalmSizedBankBehavior.trans(25, new Object[0]));
                        List1.add(Component.m_237113_((String)"-------------------"));
                        List1.add(PalmSizedBankBehavior.trans(26, new Object[0]));
                        Long2LongMap minuteMap = WalletUtils.getTransactionMinuteMap((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.choose);
                        ArrayList keys = new ArrayList(minuteMap.keySet());
                        keys.sort(Collections.reverseOrder());
                        for (Long key : keys) {
                            List1.add(Component.m_237113_((String)String.valueOf(key)));
                        }
                        List1.add(Component.m_237113_((String)"-------------------"));
                    }
                }).clickHandler((a2, b2) -> {
                    this.choose = a2;
                }));
                mainGroup.addWidget((Widget)new ComponentPanelWidget(132, 4, List2 -> {
                    if (this.choose == null) {
                        List2.add(Component.m_237113_((String)"-------------------"));
                        List2.add(PalmSizedBankBehavior.trans(22, new Object[0]));
                        List2.add(Component.m_237113_((String)"-------------------"));
                        for (String entry : syncedTransactionKeys) {
                            List2.add(Component.m_237113_((String)String.valueOf(WalletUtils.getTransactionTotalAmount((UUID)player.m_20148_(), (Level)serverLevel2, (String)entry))));
                        }
                        List2.add(Component.m_237113_((String)"-------------------"));
                    } else {
                        List2.add(Component.m_237113_((String)"-------------------"));
                        List2.add(Component.m_237113_((String)("\u00a7b" + this.choose + "\u00a7r")));
                        List2.add(Component.m_237113_((String)String.valueOf(WalletUtils.getTransactionTotalAmount((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.choose))));
                        List2.add(Component.m_237113_((String)String.valueOf(WalletUtils.getTransactionType((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.choose))));
                        List2.add(Component.m_237113_((String)String.valueOf(WalletUtils.getTransactionMinuteAmount((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.choose, (long)WalletUtils.getGameMinuteKey((Player)player)))));
                        List2.add(Component.m_237113_((String)String.valueOf(WalletUtils.getTransactionMinuteAmount((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.choose, (long)(WalletUtils.getGameMinuteKey((Player)player) - 1L)))));
                        List2.add(Component.m_237113_((String)"-------------------"));
                        List2.add(Component.m_237119_());
                        Long2LongMap minuteMap = WalletUtils.getTransactionMinuteMap((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.choose);
                        ArrayList keys = new ArrayList(minuteMap.keySet());
                        keys.sort(Collections.reverseOrder());
                        for (Long key : keys) {
                            List2.add(Component.m_237113_((String)Long.toString(minuteMap.get((Object)key))));
                        }
                        List2.add(Component.m_237113_((String)"-------------------"));
                    }
                }));
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }
        };
    }

    @NotNull
    private IFancyUIProvider tagList(PalmSizedBankBehavior parentBehavior) {
        return new IFancyUIProvider(this){
            @DescSynced
            private String choose = null;
            static final int width = 256;
            static final int height = 144;

            public IGuiTexture getTabIcon() {
                return GuiTextures.GREGTECH_LOGO;
            }

            public Component getTitle() {
                return GTOItems.PALM_SIZED_BANK.asStack().m_41611_();
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                ServerLevel serverLevel;
                WidgetGroup group = new WidgetGroup(0, 0, 264, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 256, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
                Player player = PalmSizedBankBehavior.getPlayerFromWidget(widget2);
                if (player == null) {
                    return group;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverLevel = serverPlayer.m_284548_();
                } else {
                    serverLevel = null;
                }
                ServerLevel serverLevel2 = serverLevel;
                mainGroup.addWidget((Widget)new ComponentPanelWidget(245, 0, list -> list.add(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" \u21a9 "), (String)"return"))).clickHandler((a2, b2) -> {
                    this.choose = null;
                }));
                mainGroup.addWidget((Widget)new ComponentPanelWidget(8, 4, List1 -> {
                    List1.add(Component.m_237113_((String)"-------------------"));
                    List1.add(PalmSizedBankBehavior.trans(30, new Object[0]));
                    List1.add(Component.m_237113_((String)"-------------------"));
                    if (this.choose == null) {
                        Set tagKeysSet = WalletUtils.getAllTagKeysFromWallet((UUID)player.m_20148_(), (Level)serverLevel2);
                        for (String entry : tagKeysSet) {
                            List1.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)entry), (String)entry).m_6881_().m_130940_(ChatFormatting.AQUA));
                        }
                    } else {
                        List1.add(Component.m_237115_((String)this.choose).m_130940_(ChatFormatting.AQUA));
                    }
                }).clickHandler((a2, b2) -> {
                    this.choose = a2;
                }));
                mainGroup.addWidget((Widget)new ComponentPanelWidget(132, 4, List2 -> {
                    List2.add(Component.m_237113_((String)"-------------------"));
                    List2.add(PalmSizedBankBehavior.trans(31, new Object[0]));
                    List2.add(Component.m_237113_((String)"-------------------"));
                    if (this.choose != null) {
                        Set tagsSet = WalletUtils.getTagsFromWallet((UUID)player.m_20148_(), (Level)serverLevel2, (String)this.choose);
                        for (String entry : tagsSet) {
                            List2.add(Component.m_237113_((String)entry));
                        }
                    }
                }));
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }
        };
    }

    @NotNull
    private IFancyUIProvider generateCard(PalmSizedBankBehavior parentBehavior) {
        return new IFancyUIProvider(this){
            static final int width = 256;
            static final int height = 144;

            public IGuiTexture getTabIcon() {
                return GuiTextures.GREGTECH_LOGO;
            }

            public Component getTitle() {
                return GTOItems.PALM_SIZED_BANK.asStack().m_41611_();
            }

            public Widget createMainPage(FancyMachineUIWidget widget2) {
                ServerLevel serverLevel;
                WidgetGroup group = new WidgetGroup(0, 0, 264, 152);
                DraggableScrollableWidgetGroup mainGroup = new DraggableScrollableWidgetGroup(4, 4, 256, 144).setBackground((IGuiTexture)GuiTextures.DISPLAY);
                Player player = PalmSizedBankBehavior.getPlayerFromWidget(widget2);
                if (player == null) {
                    return group;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverLevel = serverPlayer.m_284548_();
                } else {
                    serverLevel = null;
                }
                ServerLevel serverLevel2 = serverLevel;
                Object2ObjectMap WalletPlayers = WalletUtils.getAllWalletPlayers(serverLevel2);
                HashSet shared = new HashSet();
                mainGroup.addWidget((Widget)new ComponentPanelWidget(10, 16, list -> list.add(ComponentPanelWidget.withHoverTextTranslate((Component)ComponentPanelWidget.withButton((Component)PalmSizedBankBehavior.trans(41, new Object[0]), (String)"getGrayMembershipCard"), (Component)PalmSizedBankBehavior.trans(40, Component.m_237115_((String)"gtocore.currency.tech_operator_coin"), 15)))).clickHandler((a2, b2) -> {
                    if (WalletUtils.getCurrencyAmount((UUID)player.m_20148_(), (Level)serverLevel2, (String)"tech_operator_coin") >= 15L) {
                        ItemEntity itemEntity = player.m_19983_(GregMembershipCardItem.createWithUuidAndSharedList(player.m_20148_(), new ArrayList<UUID>(shared)));
                        WalletUtils.subtractCurrency((UUID)player.m_20148_(), (Level)serverLevel2, (String)"tech_operator_coin", (long)15L);
                        if (itemEntity != null) {
                            itemEntity.m_32061_();
                        }
                    }
                }));
                mainGroup.addWidget((Widget)new LabelWidget(10, 32, (Component)PalmSizedBankBehavior.trans(42, new Object[0])));
                mainGroup.addWidget((Widget)new ComponentPanelWidget(8, 4, List1 -> {
                    List1.add(Component.m_237113_((String)"-------------------"));
                    List1.add(Component.m_237119_());
                    List1.add(Component.m_237119_());
                    List1.add(Component.m_237119_());
                    List1.add(Component.m_237113_((String)"-------------------"));
                    for (Object2ObjectMap.Entry entry : WalletPlayers.object2ObjectEntrySet()) {
                        List1.add(ComponentPanelWidget.withHoverTextTranslate((Component)ComponentPanelWidget.withButton((Component)Component.m_237113_((String)("\u00a7b" + (String)entry.getValue() + "\u00a7r")), (String)((UUID)entry.getKey()).toString()), (Component)Component.m_237113_((String)((UUID)entry.getKey()).toString())));
                    }
                }).clickHandler((a2, b2) -> shared.add(UUID.fromString(a2))));
                mainGroup.addWidget((Widget)new ComponentPanelWidget(132, 4, List2 -> {
                    List2.add(Component.m_237113_((String)"-------------------"));
                    List2.add(Component.m_237119_());
                    List2.add(Component.m_237119_());
                    List2.add(Component.m_237119_());
                    List2.add(Component.m_237113_((String)"-------------------"));
                    for (UUID entry : shared) {
                        List2.add(ComponentPanelWidget.withHoverTextTranslate((Component)ComponentPanelWidget.withButton((Component)Component.m_237113_((String)((String)WalletPlayers.get((Object)entry))), (String)entry.toString()), (Component)Component.m_237113_((String)entry.toString())));
                    }
                }).clickHandler((a2, b2) -> shared.remove(UUID.fromString(a2))));
                group.addWidget((Widget)mainGroup);
                group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
                return group;
            }
        };
    }

    public void attachSideTabs(TabsWidget sideTabs) {
        sideTabs.setMainTab((IFancyUIProvider)this);
        sideTabs.attachSubTab(this.assetOverview(this));
        sideTabs.attachSubTab(this.transfer(this));
        sideTabs.attachSubTab(this.tradeRecords(this));
        sideTabs.attachSubTab(this.tagList(this));
        sideTabs.attachSubTab(this.generateCard(this));
    }

    private static void initNewPlayerCurrencies(UUID playerUUID, ServerLevel world) {
        O2LOpenCacheHashMap initialCurrencies = new O2LOpenCacheHashMap();
        initialCurrencies.put((Object)"tech_operator_coin", 37L);
        WalletUtils.setCurrencies((UUID)playerUUID, (Level)world, (O2LOpenCacheHashMap)initialCurrencies);
        WalletUtils.addTagToWallet((UUID)playerUUID, (Level)world, (String)"Unlock Shop", (String)"Base");
        WalletUtils.addTagToWallet((UUID)playerUUID, (Level)world, (String)"Unlock Trade", (String)"Base");
    }

    private void openUI(Item item, Level level, Player player, InteractionHand hand) {
        this.initializationParameters(player);
        super.use(item, level, player, hand);
    }

    private void initializationParameters(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = serverPlayer.m_284548_();
            WalletUtils.updatePlayerName((UUID)player.m_20148_(), (Level)serverLevel, (String)player.m_7755_().getString());
        }
    }

    private static Player getPlayerFromWidget(FancyMachineUIWidget widget2) {
        ModularUI modularUI = widget2.getGui();
        return modularUI != null ? modularUI.entityPlayer : null;
    }
}

