/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.common.item.TooltipBehavior;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public final class StructureDetectBehavior
extends TooltipBehavior
implements IToolBehavior,
IInteractionItem {
    public static final StructureDetectBehavior INSTANCE = new StructureDetectBehavior(lines -> {
        lines.add(Component.m_237115_((String)"item.gtocore.structure_detect.tooltip.0"));
        lines.add(Component.m_237115_((String)"item.gtocore.structure_detect.tooltip.1"));
    });
    @RegisterLanguage(cn="\u53ef\u80fd\u7684\u6a21\u5757\u9519\u8bef", en="Possible module error")
    private static final String MODULE = "gtocore.structure_detect.module";

    private StructureDetectBehavior(@NotNull Consumer<List<Component>> tooltips) {
        super(tooltips);
    }

    public static BlockPos[] getPos(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("error_pos");
        if (tag.m_128425_("pos", 9)) {
            return (BlockPos[])tag.m_128437_("pos", 10).stream().map(p -> {
                CompoundTag pos = (CompoundTag)p;
                return new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z"));
            }).toArray(BlockPos[]::new);
        }
        return null;
    }

    private static void addPos(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41698_("error_pos");
        if (tag.m_128425_("pos", 9)) {
            ListTag list = tag.m_128437_("pos", 10);
            list.add((Object)StructureDetectBehavior.pos2tag(pos));
        } else {
            ListTag list = new ListTag();
            list.add((Object)StructureDetectBehavior.pos2tag(pos));
            tag.m_128365_("pos", (Tag)list);
        }
    }

    private static CompoundTag pos2tag(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
        return tag;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            Level level = context.m_43725_();
            if (level.m_5776_()) {
                return InteractionResult.PASS;
            }
            stack.m_41751_(new CompoundTag());
            BlockPos blockPos = context.m_8083_();
            MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, (BlockPos)blockPos);
            if (metaMachine instanceof IMultiController) {
                IMultiController controller = (IMultiController)metaMachine;
                if (controller.isFormed()) {
                    player.m_213846_((Component)Component.m_237115_((String)"gtceu.top.valid_structure").m_130940_(ChatFormatting.GREEN));
                    MultiblockState[] subs = controller.getSubMultiblockState();
                    if (subs != null) {
                        for (MultiblockState s : subs) {
                            if (s.error == null) continue;
                            player.m_213846_((Component)Component.m_237115_((String)MODULE).m_130940_(ChatFormatting.AQUA));
                            StructureDetectBehavior.showError(player, s.error, stack);
                            for (PatternError error : s.errorRecord) {
                                StructureDetectBehavior.showError(player, error, stack);
                            }
                        }
                    }
                } else {
                    MultiblockState multiblockState = controller.getMultiblockState();
                    if (multiblockState.error != null) {
                        StructureDetectBehavior.showError(player, multiblockState.error, stack);
                    }
                    for (PatternError error : controller.getMultiblockState().errorRecord) {
                        StructureDetectBehavior.showError(player, error, stack);
                    }
                    MultiblockState[] subs = controller.getSubMultiblockState();
                    if (subs != null) {
                        for (MultiblockState s : subs) {
                            if (s.error == null) continue;
                            player.m_213846_((Component)Component.m_237115_((String)MODULE).m_130940_(ChatFormatting.AQUA));
                            StructureDetectBehavior.showError(player, s.error, stack);
                            for (PatternError error : s.errorRecord) {
                                StructureDetectBehavior.showError(player, error, stack);
                            }
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private static void showError(Player player, PatternError error, ItemStack stack) {
        player.m_213846_(error.getErrorInfo());
        StructureDetectBehavior.addPos(stack, error.getPos());
    }

    public static boolean isItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof ComponentItem) {
            ComponentItem item2 = (ComponentItem)item;
            return item2.getComponents().contains((Object)INSTANCE);
        }
        return false;
    }
}

