/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.item.ColoringItems;
import dev.shadowsoffire.placebo.color.GradientColor;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TarotArcanum
extends ColoringItems {
    private final int serialNumber;
    private final List<Consumer<List<Component>>> tooltipConsumers;

    private TarotArcanum(Item.Properties properties, int color, int serialNumber, List<Consumer<List<Component>>> tooltipConsumers) {
        super(properties, color, 0);
        this.serialNumber = serialNumber;
        this.tooltipConsumers = tooltipConsumers;
    }

    public static TarotArcanum create(Item.Properties properties, int color, int serialNumber, List<Consumer<List<Component>>> tooltipConsumers) {
        return new TarotArcanum(properties, color, serialNumber, tooltipConsumers);
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        return Rarity.EPIC;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack pStack) {
        return Component.m_237115_((String)this.m_5671_(pStack)).m_130938_(s -> s.m_131148_((TextColor)GradientColor.RAINBOW));
    }

    public int getMaxStackSize(ItemStack stack) {
        return 8;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.tooltipConsumers == null || this.tooltipConsumers.isEmpty()) {
            return;
        }
        int stateIndex = 0;
        if (GTUtil.isAltDown()) {
            stateIndex = 3;
        } else if (GTUtil.isCtrlDown()) {
            stateIndex = 2;
        } else if (GTUtil.isShiftDown()) {
            stateIndex = 1;
        }
        if (this.tooltipConsumers.size() <= stateIndex) {
            stateIndex = 0;
        }
        this.tooltipConsumers.get(stateIndex).accept(tooltip);
        if (stateIndex == 0 && this.tooltipConsumers.size() > 1) {
            String keys = switch (this.tooltipConsumers.size()) {
                case 2 -> "SHIFT";
                case 3 -> "SHIFT CTRL";
                case 4 -> "SHIFT CTRL ALT";
                default -> "";
            };
            tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)"tooltip.gtocore.hold_for_more", (Object[])new Object[]{keys})));
        }
    }

    @Generated
    public int getSerialNumber() {
        return this.serialNumber;
    }
}

