/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.entity.TaskEntity;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.mana.feature.IManaContainerMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.wireless.ExtendWirelessEnergyContainer;
import com.gtolib.api.wireless.WirelessManaContainer;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import java.math.BigInteger;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;

@DataGeneratorScanned
public final class TimeTwisterBehavior
implements IInteractionItem {
    @RegisterLanguage(cn="\u6d88\u8017\u4e86 %s EU\uff0c\u4f7f\u65b9\u5757\u5b9e\u4f53\u989d\u5916\u6267\u884c\u4e86 %s Tick", en="Consumed %s EU, making the block entity execute an additional %s ticks")
    private static final String CONSUMED_EU = "gtocore.item.time_twister.consumed_eu";
    @RegisterLanguage(cn="\u6d88\u8017\u4e86 %s Mana\uff0c\u4f7f\u65b9\u5757\u5b9e\u4f53\u989d\u5916\u6267\u884c\u4e86 %s Tick", en="Consumed %s Mana, making the block entity execute an additional %s ticks")
    private static final String CONSUMED_MANA = "gtocore.item.time_twister.consumed_mana";
    public static final TimeTwisterBehavior INSTANCE = new TimeTwisterBehavior();

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43725_().m_5776_()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ExtendWirelessEnergyContainer euContainer = (ExtendWirelessEnergyContainer)WirelessEnergyContainer.getOrCreateContainer((UUID)context.m_43723_().m_20148_());
        WirelessManaContainer manaContainer = WirelessManaContainer.getOrCreateContainer((UUID)context.m_43723_().m_20148_());
        if (player.m_6144_() && euContainer.removeEnergy(819200L, null) == 819200L) {
            if (TimeTwisterBehavior.isBlockEntity(context)) {
                context.m_43725_().m_7967_((Entity)new TaskEntity(context.m_43725_(), context.m_8083_(), e -> TimeTwisterBehavior.tick(euContainer, manaContainer, e, context, false)));
            } else {
                context.m_43725_().m_7967_((Entity)new TaskEntity(context.m_43725_(), context.m_8083_(), e -> TimeTwisterBehavior.tick(euContainer, manaContainer, e, context, true)));
            }
        } else if (euContainer.removeEnergy(8192L, null) == 8192L) {
            if (TimeTwisterBehavior.isBlockEntity(context)) {
                TimeTwisterBehavior.tickBlock(context.m_43725_(), context.m_8083_(), 0);
                player.m_5661_((Component)Component.m_237110_((String)CONSUMED_EU, (Object[])new Object[]{8192, 200}), true);
                return InteractionResult.CONSUME;
            }
            if (TimeTwisterBehavior.tickGT(euContainer, manaContainer, context)) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean tickGT(ExtendWirelessEnergyContainer euContainer, WirelessManaContainer manaContainer, UseOnContext context) {
        RecipeLogic recipeLogic = GTCapabilityHelper.getRecipeLogic((BlockEntity)context.m_43725_().m_7702_(context.m_8083_()));
        if (recipeLogic == null || !recipeLogic.isWorking()) {
            return false;
        }
        MetaMachine machine = recipeLogic.getMachine();
        GTRecipe recipe = recipeLogic.getLastRecipe();
        if (recipe == null) {
            return false;
        }
        int maxReducedDuration = Math.max((int)((double)(recipeLogic.getDuration() - recipeLogic.getProgress()) * 0.5), 10);
        int energyMultiplier = 2 << GTOCore.difficulty;
        if (machine instanceof IOverclockMachine) {
            BigInteger eut = BigInteger.valueOf(recipe.getInputEUt());
            if (eut.compareTo(BigInteger.ZERO) <= 0) {
                return false;
            }
            eut = eut.multiply(BigInteger.valueOf(energyMultiplier));
            BigInteger limit = euContainer.getStorage().min(BigInteger.valueOf(euContainer.getRate()));
            if (limit.compareTo(eut) < 0) {
                return false;
            }
            BigInteger tick = limit.divide(eut).min(BigInteger.valueOf(maxReducedDuration));
            BigInteger usedEU = eut.multiply(tick);
            euContainer.setStorage(euContainer.getStorage().subtract(usedEU));
            recipeLogic.setProgress(recipeLogic.getProgress() + tick.intValue());
            if (context.m_43723_() == null) {
                return false;
            }
            context.m_43723_().m_5661_((Component)Component.m_237110_((String)CONSUMED_EU, (Object[])new Object[]{FormattingUtil.formatNumbers((Object)usedEU), tick}), true);
            return true;
        }
        if (machine instanceof IManaContainerMachine) {
            BigInteger manat = BigInteger.valueOf(Recipe.of((GTRecipe)recipe).getInputMANAt());
            if (manat.compareTo(BigInteger.ZERO) <= 0) {
                return false;
            }
            manat = manat.multiply(BigInteger.valueOf(energyMultiplier));
            BigInteger storage = manaContainer.getStorage();
            if (storage.compareTo(manat) < 0) {
                return false;
            }
            BigInteger tick = storage.divide(manat).min(BigInteger.valueOf(maxReducedDuration));
            BigInteger usedMana = manat.multiply(tick);
            manaContainer.setStorage(manaContainer.getStorage().subtract(usedMana));
            recipeLogic.setProgress(recipeLogic.getProgress() + tick.intValue());
            if (context.m_43723_() == null) {
                return false;
            }
            context.m_43723_().m_5661_((Component)Component.m_237110_((String)CONSUMED_MANA, (Object[])new Object[]{FormattingUtil.formatNumbers((Object)usedMana), tick}), true);
            return true;
        }
        return false;
    }

    private static boolean isBlockEntity(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(pos = context.m_8083_());
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            return false;
        }
        return block instanceof EntityBlock && level.m_7702_(pos) != null;
    }

    private static void tick(ExtendWirelessEnergyContainer euContainer, WirelessManaContainer manaContainer, TaskEntity entity, UseOnContext context, boolean gt) {
        if (entity.f_19797_ > 100) {
            BlockEntity blockEntity;
            entity.m_146870_();
            if (!gt && (blockEntity = context.m_43725_().m_7702_(context.m_8083_())) != null) {
                blockEntity.getPersistentData().m_128473_("accelerate_tick");
            }
            return;
        }
        if (gt) {
            TimeTwisterBehavior.tickGT(euContainer, manaContainer, context);
        } else {
            TimeTwisterBehavior.tickBlock(context.m_43725_(), context.m_8083_(), entity.f_19797_);
        }
    }

    private static void tickBlock(Level level, BlockPos pos, int tick) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (level instanceof ServerLevel && block.m_6724_(blockState)) {
            blockState.m_222972_((ServerLevel)level, pos, level.m_213780_());
        }
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity == null) {
                return;
            }
            BlockEntityTicker ticker = entityBlock.m_142354_(level, blockState, blockEntity.m_58903_());
            if (ticker == null) {
                return;
            }
            for (int i = 0; i < 200 && !blockEntity.m_58901_(); ++i) {
                ticker.m_155252_(level, pos, blockState, blockEntity);
            }
            if (tick > 0) {
                blockEntity.getPersistentData().m_128405_("accelerate_tick", tick);
            }
        }
    }
}

