/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.component.ElectricStats;
import com.gtocore.common.data.translation.GTOItemTooltips;
import com.gtocore.config.GTOConfig;
import com.gtocore.eio_travel.api.TravelHandler;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TravelStaffBehavior
extends ElectricStats {
    private static final long EU_COST = 128L;
    private static final long EU_MAX = 768000L;

    protected TravelStaffBehavior(long maxCharge, int tier, boolean chargeable, boolean dischargeable) {
        super(maxCharge, tier, chargeable, dischargeable);
    }

    public static TravelStaffBehavior create() {
        return new TravelStaffBehavior(768000L, 1, true, false);
    }

    public InteractionResultHolder<ItemStack> use(Item self, Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (this.getActivationStatus(stack).isAir()) {
            if (this.tryPerformAction(self, level, player, stack)) {
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.use(self, level, player, usedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this.getActivationStatus(context.m_43722_()).isBlock()) {
            if (context.m_43723_() != null && this.tryPerformAction(context.m_43722_().m_41720_(), context.m_43725_(), context.m_43723_(), context.m_43722_())) {
                return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    private boolean tryPerformAction(Item self, Level level, Player player, ItemStack stack) {
        boolean isCreative = player.m_7500_();
        if (this.hasResources(stack) || isCreative) {
            if (this.performAction(self, level, player, stack)) {
                if (!level.m_5776_() && !isCreative) {
                    this.consumeResources(stack);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean performAction(Item self, Level level, Player player, ItemStack stack) {
        if (player.m_6144_()) {
            if (TravelHandler.shortTeleport(level, player)) {
                player.m_36335_().m_41524_(self, GTOConfig.INSTANCE.travelConfig.travelStaffCooldown);
                return true;
            }
        } else if (TravelHandler.blockTeleport(level, player)) {
            player.m_36335_().m_41524_(self, GTOConfig.INSTANCE.travelConfig.travelStaffCooldown);
            return true;
        }
        return false;
    }

    public void appendTooltips(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.addAll((Collection<Component>)GTOItemTooltips.INSTANCE.getTravelStaff().get());
        super.appendTooltips(stack, level, tooltipComponents, isAdvanced);
    }

    public boolean hasResources(ItemStack stack) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem((ItemStack)stack);
        if (electricItem == null) {
            return false;
        }
        return electricItem.getCharge() >= 128L;
    }

    public void consumeResources(ItemStack stack) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem((ItemStack)stack);
        if (electricItem == null) {
            return;
        }
        electricItem.discharge(128L, 1, true, true, false);
    }

    protected ActivationStatus getActivationStatus(ItemStack stack) {
        return ActivationStatus.ALL;
    }

    protected static enum ActivationStatus {
        BLOCK(true, false),
        AIR(false, true),
        ALL(true, true);

        private final boolean isBlock;
        private final boolean isAir;

        private ActivationStatus(boolean isBlock, boolean isAir) {
            this.isBlock = isBlock;
            this.isAir = isAir;
        }

        @Generated
        public boolean isBlock() {
            return this.isBlock;
        }

        @Generated
        public boolean isAir() {
            return this.isAir;
        }
    }
}

