/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gtolib.api.machine.feature.IVacuumMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VacuumPumpMachine
extends SimpleTieredMachine
implements IVacuumMachine {
    @Persisted
    @DescSynced
    private int vacuumTier;
    @Persisted
    private int totalEU;
    private TickableSubscription tickSubs;

    public VacuumPumpMachine(MetaMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, GTMachineUtils.defaultTankSizeFunction, args);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tick, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    private void tick() {
        if (this.getRecipeLogic().isWorking()) {
            if (this.totalEU < 12000) {
                this.totalEU += 2 * GTValues.VA[this.getTier()];
            }
        } else if (this.totalEU > 0) {
            this.totalEU -= 4 * GTValues.VA[this.getTier()];
        }
        this.vacuumTier = Math.min(this.getTier() + 1, (int)Math.ceil((double)this.totalEU / 1200.0));
    }

    public void afterWorking() {
        super.afterWorking();
        this.update();
    }

    @Nullable
    public GTRecipe doModifyRecipe(@NotNull GTRecipe recipe) {
        if (this.getTier() == recipe.data.m_128451_("tier")) {
            return recipe;
        }
        return null;
    }

    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        super.attachTooltips(tooltipsPanel);
        tooltipsPanel.attachTooltips(new IFancyTooltip[]{new IFancyTooltip.Basic(() -> GuiTextures.INFO_ICON, () -> List.of(Component.m_237110_((String)"gtocore.recipe.vacuum.tier", (Object[])new Object[]{this.vacuumTier})), () -> true, () -> null)});
    }

    public int getVacuumTier() {
        return this.vacuumTier;
    }

    @Generated
    public int getTotalEU() {
        return this.totalEU;
    }

    @Generated
    public TickableSubscription getTickSubs() {
        return this.tickSubs;
    }
}

