/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana;

import appeng.core.definitions.AEItems;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.item.CoordinateCardBehavior;
import com.gtolib.utils.explosion.AreaExplosion;
import com.gtolib.utils.explosion.ChunkExplosion;
import com.gtolib.utils.explosion.CylinderExplosion;
import com.gtolib.utils.explosion.SphereExplosion;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AreaDestructionToolsMachine
extends MetaMachine
implements IFancyUIMachine,
IMachineLife {
    @Persisted
    private final NotifiableItemStackHandler inventory = new NotifiableItemStackHandler((MetaMachine)this, 9, IO.NONE, IO.BOTH);
    private int model = 0;
    private int explosiveYield = 0;
    private BlockPos pos1;
    private BlockPos pos2;

    public AreaDestructionToolsMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.inventory.addChangedListener(() -> {
            Level level = this.getLevel();
            if (level == null) {
                return;
            }
            this.model = 0;
            long explosiveEnergy = 0L;
            this.explosiveYield = 0;
            this.pos1 = null;
            this.pos2 = null;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                Item item = stack.m_41720_();
                if (item == GTItems.SHAPE_MOLD_BALL.m_5456_()) {
                    this.model = 1;
                    continue;
                }
                if (item == GTItems.SHAPE_MOLD_CYLINDER.m_5456_()) {
                    this.model = 2;
                    continue;
                }
                if (item == GTItems.SHAPE_MOLD_BLOCK.m_5456_()) {
                    this.model = 3;
                    continue;
                }
                if (item == AEItems.SINGULARITY.m_5456_()) {
                    this.model = 4;
                    continue;
                }
                if (item == GTOItems.INDUSTRIAL_COMPONENTS[3][2].m_5456_()) {
                    explosiveEnergy += 5000L * (long)stack.m_41613_();
                    continue;
                }
                if (item == GTOItems.INDUSTRIAL_COMPONENTS[3][1].m_5456_()) {
                    explosiveEnergy += 1000L * (long)stack.m_41613_();
                    continue;
                }
                if (item == GTOItems.INDUSTRIAL_COMPONENTS[3][0].m_5456_()) {
                    explosiveEnergy += 200L * (long)stack.m_41613_();
                    continue;
                }
                if (item == GTBlocks.INDUSTRIAL_TNT.m_5456_()) {
                    explosiveEnergy += 30L * (long)stack.m_41613_();
                    continue;
                }
                if (item == GTOBlocks.NUKE_BOMB.m_5456_()) {
                    explosiveEnergy += 2048L * (long)stack.m_41613_();
                    continue;
                }
                if (item == GTOBlocks.NAQUADRIA_CHARGE.m_5456_()) {
                    explosiveEnergy += 3200L * (long)stack.m_41613_();
                    continue;
                }
                if (item == GTOBlocks.LEPTONIC_CHARGE.m_5456_()) {
                    explosiveEnergy += 2048000L * (long)stack.m_41613_();
                    continue;
                }
                if (item == GTOBlocks.QUANTUM_CHROMODYNAMIC_CHARGE.m_5456_()) {
                    explosiveEnergy += 32000000L * (long)stack.m_41613_();
                    continue;
                }
                if (item != GTOItems.COORDINATE_CARD.m_5456_()) continue;
                if (this.pos1 == null) {
                    this.pos1 = CoordinateCardBehavior.getStoredCoordinates(stack);
                    continue;
                }
                this.pos2 = CoordinateCardBehavior.getStoredCoordinates(stack);
            }
            if (this.model == 1) {
                this.explosiveYield = (int)Math.cbrt((double)explosiveEnergy / 4.0) * 10;
            } else if (this.model == 2) {
                this.explosiveYield = (int)Math.sqrt((double)explosiveEnergy / (double)level.m_141928_()) * 18;
            } else if (this.model == 3) {
                this.explosiveYield = (int)Math.sqrt((double)explosiveEnergy / (double)level.m_141928_()) * 16;
            } else if (this.model == 4 && this.pos1 != null && this.pos2 != null) {
                int volume = this.countBlocksInCube(this.pos1, this.pos2);
                this.explosiveYield = explosiveEnergy > (long)volume ? Math.max(1, volume / 200000) : -1;
            }
        });
    }

    public void onLoad() {
        super.onLoad();
        this.inventory.notifyListeners();
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    private void triggerExplosion() {
        BlockPos pos = this.getPos();
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        if (this.model == 0) {
            return;
        }
        if (this.model == 1) {
            SphereExplosion.explosion((BlockPos)pos, (Level)level, (int)this.explosiveYield, (boolean)true, (boolean)true, (boolean)false);
        } else if (this.model == 2) {
            CylinderExplosion.explosion((BlockPos)pos, (Level)level, (int)this.explosiveYield, (boolean)true, (boolean)true, (boolean)false);
        } else if (this.model == 3) {
            ChunkExplosion.explosion((BlockPos)pos, (Level)level, (int)this.explosiveYield, (boolean)true, (boolean)true, (boolean)false);
        } else if (this.model == 4 && this.explosiveYield > 0) {
            AreaExplosion.explosion((BlockPos)pos, (BlockPos)this.pos1, (BlockPos)this.pos2, (Level)level, (boolean)true, (boolean)true, (boolean)false);
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick)));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotIndex = y * 3 + x;
                group.addWidget(new SlotWidget((IItemHandlerModifiable)this.inventory, slotIndex, 133 + x * 18, 68 + y * 18, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}));
            }
        }
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private void addDisplayText(List<Component> textList) {
        textList.add((Component)Component.m_237115_((String)"gtocore.machine.area_destruction_tools.detonate_instruction").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [\ud83d\udca5]"), (String)"detonate")));
        textList.add((Component)Component.m_237115_((String)("gtocore.machine.area_destruction_tools.model." + this.model)));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.area_destruction_tools.explosive_yield", (Object[])new Object[]{this.explosiveYield}));
    }

    private void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote && "detonate".equals(componentData)) {
            this.triggerExplosion();
        }
    }

    public int countBlocksInCube(BlockPos pos1, BlockPos pos2) {
        int x1 = pos1.m_123341_();
        int y1 = pos1.m_123342_();
        int z1 = pos1.m_123343_();
        int x2 = pos2.m_123341_();
        int y2 = pos2.m_123342_();
        int z2 = pos2.m_123343_();
        int dx = Math.abs(x1 - x2) / 10;
        int dy = Math.abs(y1 - y2) / 10;
        int dz = Math.abs(z1 - z2) / 10;
        return dx * dy * dz;
    }
}

