/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana;

import com.gtolib.api.data.Dimension;
import com.gtolib.api.data.GTODimensions;
import earth.terrarium.adastra.api.planets.PlanetApi;
import lombok.Generated;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CelestialHandler {
    public static final String SOLARIS = "solaris";
    public static final String LUNARA = "lunara";
    public static final String VOIDFLUX = "voidflux";
    public static final String STELLARM = "stellarm";
    private final long MAX_CAPACITY;

    public CelestialHandler(long MAX_CAPACITY) {
        this.MAX_CAPACITY = MAX_CAPACITY;
    }

    public long clampToMaxCapacity(long value) {
        return Math.min(this.MAX_CAPACITY, value);
    }

    public Mode initMode(Level world) {
        if (world == null) {
            return Mode.OVERWORLD;
        }
        ResourceKey dim = world.m_46472_();
        if (PlanetApi.API.isSpace(world)) {
            return Mode.SPACE;
        }
        if (GTODimensions.isVoid((ResourceLocation)dim.m_135782_())) {
            return Mode.VOID;
        }
        return switch (Dimension.from((ResourceKey)dim)) {
            case Dimension.OTHERSIDE -> Mode.OTHERSIDE;
            case Dimension.ALFHEIM -> Mode.ALFHEIM;
            case Dimension.THE_END -> Mode.END;
            default -> Mode.OVERWORLD;
        };
    }

    public Resource increase(Level world, int multiple, long solaris, long lunara, long voidflux, long stellarm, Mode mode) {
        if (world == null) {
            return new Resource(solaris, lunara, voidflux, stellarm);
        }
        switch (mode.ordinal()) {
            case 2: {
                stellarm = this.clampToMaxCapacity(stellarm + 20L * (long)multiple);
                break;
            }
            case 0: {
                solaris = this.clampToMaxCapacity(solaris + 5L * (long)multiple);
                lunara = this.clampToMaxCapacity(lunara + 5L * (long)multiple);
                break;
            }
            case 3: {
                if (world.m_46461_()) {
                    solaris = this.clampToMaxCapacity(solaris + 20L * (long)multiple);
                    break;
                }
                if (!world.m_46462_()) break;
                lunara = this.clampToMaxCapacity(lunara + 20L * (long)multiple);
                break;
            }
            case 1: {
                voidflux = this.clampToMaxCapacity(voidflux + 50L * (long)multiple);
                break;
            }
            case 4: {
                voidflux = this.clampToMaxCapacity(voidflux + 10L * (long)multiple);
                break;
            }
            case 5: {
                if (world.m_46461_()) {
                    solaris = this.clampToMaxCapacity(solaris + 10L * (long)multiple);
                    break;
                }
                if (!world.m_46462_()) break;
                lunara = this.clampToMaxCapacity(lunara + 10L * (long)multiple);
            }
        }
        return new Resource(solaris, lunara, voidflux, stellarm);
    }

    public ResourceResult deductResource(String type, int cost, long parallel, long solaris, long lunara, long voidflux, long stellarm) {
        long totalCost = (long)cost * parallel;
        if (totalCost <= 0L) {
            return new ResourceResult(true, solaris, lunara, voidflux, stellarm);
        }
        switch (type) {
            case "solaris": {
                if (solaris < totalCost) {
                    return new ResourceResult(false, solaris, lunara, voidflux, stellarm);
                }
                solaris = Math.max(0L, solaris - totalCost);
                break;
            }
            case "lunara": {
                if (lunara < totalCost) {
                    return new ResourceResult(false, solaris, lunara, voidflux, stellarm);
                }
                lunara = Math.max(0L, lunara - totalCost);
                break;
            }
            case "voidflux": {
                if (voidflux < totalCost) {
                    return new ResourceResult(false, solaris, lunara, voidflux, stellarm);
                }
                voidflux = Math.max(0L, voidflux - totalCost);
                break;
            }
            case "stellarm": {
                if (stellarm < totalCost) {
                    return new ResourceResult(false, solaris, lunara, voidflux, stellarm);
                }
                stellarm = Math.max(0L, stellarm - totalCost);
                break;
            }
            case "ANY": {
                long deduct;
                long remainingCost = totalCost;
                if (remainingCost > 0L && solaris > 0L) {
                    deduct = Math.min(solaris, remainingCost);
                    solaris = Math.max(0L, solaris - deduct);
                    remainingCost -= deduct;
                }
                if (remainingCost > 0L && lunara > 0L) {
                    deduct = Math.min(lunara, remainingCost);
                    lunara = Math.max(0L, lunara - deduct);
                    remainingCost -= deduct;
                }
                if (remainingCost > 0L && voidflux > 0L) {
                    deduct = Math.min(voidflux, remainingCost);
                    voidflux = Math.max(0L, voidflux - deduct);
                    remainingCost -= deduct;
                }
                if (remainingCost > 0L && stellarm > 0L) {
                    deduct = Math.min(stellarm, remainingCost);
                    stellarm = Math.max(0L, stellarm - deduct);
                    remainingCost -= deduct;
                }
                if (remainingCost <= 0L) break;
                return new ResourceResult(false, solaris, lunara, voidflux, stellarm);
            }
            default: {
                return new ResourceResult(false, solaris, lunara, voidflux, stellarm);
            }
        }
        return new ResourceResult(true, solaris, lunara, voidflux, stellarm);
    }

    @Generated
    public long getMAX_CAPACITY() {
        return this.MAX_CAPACITY;
    }

    public static enum Mode {
        VOID,
        OTHERSIDE,
        SPACE,
        ALFHEIM,
        END,
        OVERWORLD;

    }

    public record Resource(long solaris, long lunara, long voidflux, long stellarm) {
    }

    public record ResourceResult(boolean success, long solaris, long lunara, long voidflux, long stellarm) {
    }
}

