/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtocore.common.data.GTOFluids;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.utils.holder.ObjectHolder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Align;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public class ExperienceObelisk
extends MetaMachine
implements IFancyUIMachine,
IDropSaveMachine {
    @Persisted
    private final NotifiableFluidTank experienceTank = new NotifiableFluidTank((MetaMachine)this, 1, Integer.MAX_VALUE, IO.NONE, IO.BOTH);
    @Persisted
    private int currentConfigAmount = 0;
    @Persisted
    private boolean isConfiguringLevels = false;
    @Persisted
    private boolean vacuumHopperMode = false;
    private final ConditionalSubscriptionHandler tickSubs;
    @RegisterLanguage(cn="\u5355\u4f4d\uff1a\u7ecf\u9a8c\u7b49\u7ea7", en="Unit: Experience Levels")
    private static final String LANG_CONFIGURE_LEVELS = "gtocore.machine.experience_obelisk.configure_levels";
    @RegisterLanguage(cn="\u5355\u4f4d\uff1a\u7ecf\u9a8c\u503c", en="Unit: Experience Points")
    private static final String LANG_CONFIGURE_POINTS = "gtocore.machine.experience_obelisk.configure_points";
    @RegisterLanguage(cn="\u8bbe\u5b9a\u7ecf\u9a8c\u503c\u8f6c\u79fb\u6570\u91cf", en="Transfer the configured experience amount")
    private static final String LANG_CONFIGURE_AMOUNT = "gtocore.machine.experience_obelisk.configure_amount";
    @RegisterLanguage(cn="\u4ece\u73a9\u5bb6\u8f6c\u79fb\u8bbe\u5b9a\u7684\u7ecf\u9a8c\u503c\u5230\u673a\u5668", en="Transfer the configured experience from player to machine")
    private static final String LANG_TRANSFER_TO_MACHINE = "gtocore.machine.experience_obelisk.transfer_to_machine";
    @RegisterLanguage(cn="\u4ece\u673a\u5668\u8f6c\u79fb\u8bbe\u5b9a\u7684\u7ecf\u9a8c\u503c\u5230\u73a9\u5bb6", en="Transfer the configured experience from machine to player")
    private static final String LANG_TRANSFER_TO_PLAYER = "gtocore.machine.experience_obelisk.transfer_to_player";
    @RegisterLanguage(cn="\u8f6c\u79fb\u6240\u6709\u7684\u7ecf\u9a8c\u503c\u5230\u73a9\u5bb6", en="Transfer all experience from machine to player")
    private static final String LANG_TRANSFER_ALL_TO_PLAYER = "gtocore.machine.experience_obelisk.transfer_all_to_player";
    @RegisterLanguage(cn="\u8f6c\u79fb\u6240\u6709\u7684\u7ecf\u9a8c\u503c\u5230\u673a\u5668", en="Transfer all experience from machine to player")
    private static final String LANG_TRANSFER_ALL_TO_MACHINE = "gtocore.machine.experience_obelisk.transfer_all_to_machine";
    @RegisterLanguage(cn="\u771f\u7a7a\u7bb1\u5b50\u6a21\u5f0f", en="Vacuum Hopper Mode")
    private static final String LANG_VACUUM_HOPPER_MODE = "gtocore.machine.experience_obelisk.vacuum_hopper_mode";
    @RegisterLanguage(cn="\u5df2\u5b58\u50a8%s\u7ea7\u7ecf\u9a8c", en="Stored %s Levels of Experience")
    public static final String LANG_STORED_EXPERIENCE = "gtocore.machine.experience_obelisk.stored_experience";
    @RegisterLanguage(cn="\u4fee\u590d\u5e26\u6709\u7ecf\u9a8c\u4fee\u8865\u9644\u9b54\u7684\u5de5\u5177", en="Repair tools with Mending enchantment")
    private static final String LANG_REPAIR_MENDING_TOOLS = "gtocore.machine.experience_obelisk.repair_mending_tools";

    public ExperienceObelisk(MetaMachineBlockEntity holder) {
        super(holder);
        this.experienceTank.setFilter(f -> f.getFluid() == GTOFluids.XP_JUICE.getSource());
        this.tickSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::absorbXpOrb, 20, this::isVacuumHopperMode);
    }

    private void absorbXpOrb() {
        this.tickSubs.updateSubscription();
        Level world = this.holder.m_58904_();
        if (world == null) {
            return;
        }
        AABB aabb = new AABB(this.holder.getSelf().m_58899_()).m_82400_(14.0);
        List xpOrbs = world.m_45976_(ExperienceOrb.class, aabb);
        for (ExperienceOrb xpOrb : xpOrbs) {
            int juiceAmount = xpOrb.m_20801_();
            int xpAbsorbed = this.experienceTank.fill(new FluidStack((Fluid)GTOFluids.XP_JUICE.getSource(), juiceAmount), IFluidHandler.FluidAction.EXECUTE);
            if (xpAbsorbed <= 0) continue;
            xpOrb.m_146870_();
            int remainingXp = xpOrb.m_20801_() - xpAbsorbed;
            if (remainingXp <= 0) continue;
            ExperienceOrb orb = new ExperienceOrb(world, xpOrb.m_20185_(), xpOrb.m_20186_(), xpOrb.m_20189_(), remainingXp);
            world.m_7967_((Entity)orb);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.tickSubs.initialize(this.getLevel());
    }

    public void onUnload() {
        super.onUnload();
        this.tickSubs.unsubscribe();
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.experienceTank).cast();
        }
        return null;
    }

    public ModularUI createUI(Player entityPlayer) {
        WidgetGroup widgetsOuter = new WidgetGroup(0, 0, 100, 100);
        widgetsOuter.setAlign(Align.TOP_CENTER);
        WidgetGroup widgets = new WidgetGroup(0, 8, 100, 92);
        widgetsOuter.addWidget((Widget)widgets);
        widgets.addWidget((Widget)new WidgetGroup(0, 0, 100, 12).addWidget(new LabelWidget(0, 0, LANG_CONFIGURE_AMOUNT).setAlign(Align.CENTER)));
        widgets.addWidget((Widget)this.createConfigAmountWidget());
        widgets.addWidget((Widget)this.createLevelsModeToggleButton());
        widgets.addWidget((Widget)new LabelWidget(20, 40, () -> Component.m_237110_((String)LANG_STORED_EXPERIENCE, (Object[])new Object[]{EnchantmentUtils.getLevelForExperience((int)this.experienceTank.getFluidInTank(0).getAmount())}).getString()));
        widgets.addWidget((Widget)this.createTransferConfiguredButton(entityPlayer, true, 0));
        widgets.addWidget((Widget)this.createTransferConfiguredButton(entityPlayer, false, 20));
        widgets.addWidget((Widget)this.createTransferAllButton(entityPlayer, true, 40));
        widgets.addWidget((Widget)this.createTransferAllButton(entityPlayer, false, 60));
        widgets.addWidget((Widget)this.createVacuumHopperModeButton(80));
        widgets.addWidget(this.fixToolsWithMendingEnchantmentButton(entityPlayer, 100));
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget((IFancyUIProvider)this, 176, 166)).widget((Widget)widgetsOuter);
    }

    public void attachSideTabs(TabsWidget sideTabs) {
        sideTabs.setMainTab((IFancyUIProvider)this);
    }

    public Widget createUIWidget() {
        return new WidgetGroup();
    }

    private IntInputWidget createConfigAmountWidget() {
        IntInputWidget intWidget = new IntInputWidget(this::getCurrentConfigAmount, this::setCurrentConfigAmount);
        intWidget.setSelfPosition(0, 12);
        intWidget.setMax((Number)100000000);
        intWidget.setMin((Number)0);
        intWidget.setValue((Number)this.currentConfigAmount);
        return intWidget;
    }

    private ToggleButtonWidget createLevelsModeToggleButton() {
        ObjectHolder toggleHolder = new ObjectHolder(null);
        ToggleButtonWidget toggleButton = new ToggleButtonWidget(0, 40, 16, 16, this::isConfiguringLevels, pressed -> {
            this.isConfiguringLevels = pressed;
            if (LDLib.isRemote()) {
                ((ToggleButtonWidget)toggleHolder.value).setHoverTooltips(new Component[]{ExperienceObelisk.getConfigureLevelsOrPointsTooltip(pressed)});
            }
        });
        toggleHolder.value = toggleButton;
        toggleButton.setPressed(this.isConfiguringLevels);
        toggleButton.setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GTOGuiTextures.SMALL_XP_ORB}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, GTOGuiTextures.LARGE_XP_ORB.scale(0.8f)}));
        toggleButton.setHoverTooltips(new Component[]{ExperienceObelisk.getConfigureLevelsOrPointsTooltip(this.isConfiguringLevels)});
        return toggleButton;
    }

    private ButtonWidget createTransferConfiguredButton(Player player, boolean toPlayer, int x) {
        ButtonWidget button2 = this.createTransferButton(player, () -> this.calculateConfiguredAmount(player, toPlayer), x);
        if (toPlayer) {
            button2.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON_RIGHT.copy().rotate(45.0f)});
            button2.setHoverTooltips(new Component[]{Component.m_237115_((String)LANG_TRANSFER_TO_PLAYER)});
        } else {
            button2.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON_LEFT.copy().rotate(45.0f)});
            button2.setHoverTooltips(new Component[]{Component.m_237115_((String)LANG_TRANSFER_TO_MACHINE)});
        }
        return button2;
    }

    private ButtonWidget createTransferAllButton(Player player, boolean toPlayer, int x) {
        IntSupplier amountSupplier = toPlayer ? () -> this.experienceTank.getFluidInTank(0).getAmount() : () -> -ExperienceObelisk.getExperiencePoints(player);
        ButtonWidget button2 = this.createTransferButton(player, amountSupplier, x);
        if (toPlayer) {
            button2.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON_RIGHT.copy().rotate(45.0f)});
            button2.setHoverTooltips(new Component[]{Component.m_237115_((String)LANG_TRANSFER_ALL_TO_PLAYER)});
        } else {
            button2.setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON_LEFT.copy().rotate(45.0f)});
            button2.setHoverTooltips(new Component[]{Component.m_237115_((String)LANG_TRANSFER_ALL_TO_MACHINE)});
        }
        return button2;
    }

    private ToggleButtonWidget createVacuumHopperModeButton(int x) {
        ToggleButtonWidget button2 = new ToggleButtonWidget(x, 60, 16, 16, this::isVacuumHopperMode, this::setVacuumHopperMode);
        button2.setTexture((IGuiTexture)this.createToggleTexture(false), (IGuiTexture)this.createToggleTexture(true));
        button2.setHoverTooltips(new Component[]{Component.m_237115_((String)LANG_VACUUM_HOPPER_MODE)});
        return button2;
    }

    private GuiTextureGroup createToggleTexture(boolean active) {
        ResourceTexture baseTexture = GuiTextures.PROGRESS_BAR_SOLAR_STEAM.get(true).copy();
        if (active) {
            return new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, baseTexture.getSubTexture(0.0, 0.5, 1.0, 0.5).scale(0.8f)});
        }
        return new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, baseTexture.getSubTexture(0.0, 0.0, 1.0, 0.5).scale(0.8f)});
    }

    private int calculateConfiguredAmount(Player player, boolean toPlayer) {
        int amount;
        int n = amount = toPlayer ? this.currentConfigAmount : -this.currentConfigAmount;
        if (this.isConfiguringLevels) {
            int targetLevel = player.f_36078_ + (toPlayer ? amount : -amount);
            int experienceNeeded = EnchantmentUtils.getTotalExperienceForLevel((int)targetLevel) - ExperienceObelisk.getExperiencePoints(player);
            amount = toPlayer ? experienceNeeded : -experienceNeeded;
        }
        return amount;
    }

    private ButtonWidget createTransferButton(Player player, IntSupplier amountToPlayer, int x) {
        return new ButtonWidget(x, 60, 16, 16, clickData -> {
            int amount = amountToPlayer.getAsInt();
            if (player instanceof ServerPlayer && amount != 0) {
                int canTransfer = amount;
                if (amount > 0) {
                    int beforeAdd = ExperienceObelisk.getExperiencePoints(player);
                    EnchantmentUtils.chargeExperience((Player)player, (int)(-amount));
                    int afterAdd = ExperienceObelisk.getExperiencePoints(player);
                    int drained = this.experienceTank.drain(afterAdd - beforeAdd, IFluidHandler.FluidAction.EXECUTE).getAmount();
                    if (drained < canTransfer) {
                        EnchantmentUtils.chargeExperience((Player)player, (int)(canTransfer - drained));
                    }
                } else {
                    canTransfer = this.experienceTank.fill(new FluidStack((Fluid)GTOFluids.XP_JUICE.getSource(), -canTransfer), IFluidHandler.FluidAction.SIMULATE);
                    if (EnchantmentUtils.chargeExperience((Player)player, (int)canTransfer)) {
                        this.experienceTank.fill(new FluidStack((Fluid)GTOFluids.XP_JUICE.getSource(), canTransfer), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            }
        });
    }

    private Widget fixToolsWithMendingEnchantmentButton(Player player, int x) {
        return new ButtonWidget(x, 60, 16, 16, clickData -> {
            int value;
            int extracted;
            int remainingExp;
            if (player instanceof ServerPlayer && (remainingExp = this.repairPlayerItems(player, extracted = this.experienceTank.drain(value = this.experienceTank.getFluidInTank(0).getAmount(), IFluidHandler.FluidAction.EXECUTE).getAmount(), extracted)) > 0) {
                this.experienceTank.fill(new FluidStack((Fluid)GTOFluids.XP_JUICE.getSource(), remainingExp), IFluidHandler.FluidAction.EXECUTE);
            }
        }).setButtonTexture(new IGuiTexture[]{GuiTextures.BUTTON, GuiTextures.TOOL_SLOT_OVERLAY.copy().scale(0.88f)}).setHoverTooltips(new Component[]{Component.m_237115_((String)LANG_REPAIR_MENDING_TOOLS)});
    }

    private int repairPlayerItems(Player p_147093_, int remainingExp, int initialValue) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)Enchantments.f_44962_, (LivingEntity)p_147093_, ItemStack::m_41768_);
        if (entry != null) {
            ItemStack itemstack = (ItemStack)entry.getValue();
            int i = Math.min((int)((float)initialValue * itemstack.getXpRepairRatio()), itemstack.m_41773_());
            itemstack.m_41721_(itemstack.m_41773_() - i);
            int j = remainingExp - this.durabilityToXp(i);
            return j > 0 ? this.repairPlayerItems(p_147093_, j, initialValue) : 0;
        }
        return remainingExp;
    }

    private int durabilityToXp(int pDurability) {
        return pDurability / 2;
    }

    public void setVacuumHopperMode(boolean vacuumHopperMode) {
        this.vacuumHopperMode = vacuumHopperMode;
        this.tickSubs.updateSubscription();
    }

    public void saveToItem(CompoundTag tag) {
        super.saveToItem(tag);
        tag.m_128405_("xp", this.experienceTank.getFluidInTank(0).getAmount());
    }

    public void loadFromItem(CompoundTag tag) {
        super.loadFromItem(tag);
        int xpAmount = tag.m_128451_("xp");
        this.experienceTank.setFluidInTank(0, new FluidStack((Fluid)GTOFluids.XP_JUICE.getSource(), xpAmount));
    }

    private void setCurrentConfigAmount(int integer) {
        this.currentConfigAmount = integer;
    }

    private static Component getConfigureLevelsOrPointsTooltip(boolean isConfiguringLevels) {
        return isConfiguringLevels ? Component.m_237115_((String)LANG_CONFIGURE_LEVELS) : Component.m_237115_((String)LANG_CONFIGURE_POINTS);
    }

    private static int getExperiencePoints(Player player) {
        return (int)((float)EnchantmentUtils.getTotalExperienceForLevel((int)player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    @Generated
    public int getCurrentConfigAmount() {
        return this.currentConfigAmount;
    }

    @Generated
    public boolean isConfiguringLevels() {
        return this.isConfiguringLevels;
    }

    @Generated
    public boolean isVacuumHopperMode() {
        return this.vacuumHopperMode;
    }
}

