/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.machine.mana.SimpleManaMachine;
import com.gtolib.api.machine.feature.IHeaterMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManaHeaterMachine
extends SimpleManaMachine
implements IHeaterMachine {
    private static final Fluid SALAMANDER = GTOMaterials.Salamander.getFluid(FluidStorageKeys.GAS);
    @Persisted
    @DescSynced
    @RequireRerender
    private int temperature = 293;
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean salamanderInput = false;
    private TickableSubscription tickSubs;

    public ManaHeaterMachine(MetaMachineBlockEntity holder) {
        super(holder, 2, t -> 8000, new Object[0]);
    }

    @Nullable
    private Recipe getRecipe() {
        if (this.temperature >= this.getMaxTemperature()) {
            return null;
        }
        Recipe recipe = this.getRecipeBuilder().duration(20).MANAt(16L).buildRawRecipe();
        if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    @NotNull
    public RecipeLogic createRecipeLogic() {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    @NotNull
    public GTRecipeType getRecipeType() {
        return GTORecipeTypes.MANA_HEATER_RECIPES;
    }

    public int getOutputSignal(@Nullable Direction side) {
        return this.getSignal(side);
    }

    public boolean canConnectRedstone(@NotNull Direction side) {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, () -> {
                this.tickUpdate();
                this.getRecipeLogic().updateTickSubscription();
            }, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.getOffsetTimer() % 10 == 0 && this.getMaxTemperature() > this.temperature + 10) {
                boolean hasSalamander;
                this.salamanderInput = hasSalamander = this.inputFluid(SALAMANDER, 10L);
                this.raiseTemperature(hasSalamander ? 10 : 2);
            }
            return true;
        }
        this.salamanderInput = false;
        return false;
    }

    public int getHeatCapacity() {
        return 8;
    }

    public int getMaxTemperature() {
        return 2400;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean hasSalamanderInput() {
        return this.salamanderInput;
    }
}

