/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtocore.client.renderer.StructurePattern;
import com.gtocore.client.renderer.StructureVBO;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.machine.mana.CelestialHandler;
import com.gtocore.common.machine.mana.multiblock.ManaMultiblockMachine;
import com.gtolib.api.GTOValues;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.ClientUtil;
import com.gtolib.utils.RegistriesUtils;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosmicCelestialSpireOfConvergence
extends ManaMultiblockMachine {
    private final CelestialHandler celestialHandler;
    @Persisted
    private long solaris = 0L;
    @Persisted
    private long lunara = 0L;
    @Persisted
    private long voidflux = 0L;
    @Persisted
    private long stellarm = 0L;
    private CelestialHandler.Mode mode = CelestialHandler.Mode.OVERWORLD;
    @Persisted
    private short accelerate = 0;
    private int timing;
    private final ConditionalSubscriptionHandler tickSubs;
    private boolean clientRemovedBlocks = false;

    public CosmicCelestialSpireOfConvergence(MetaMachineBlockEntity holder) {
        super(holder);
        this.celestialHandler = new CelestialHandler(5000000000000000000L);
        this.tickSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::tickUpdate, 10, () -> ((CosmicCelestialSpireOfConvergence)this).isFormed());
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (!super.beforeWorking(recipe)) {
            return null;
        }
        int solarisCost = recipe.data.m_128451_("solaris");
        int lunaraCost = recipe.data.m_128451_("lunara");
        int voidfluxCost = recipe.data.m_128451_("voidflux");
        int stellarmCost = recipe.data.m_128451_("stellarm");
        int anyCost = recipe.data.m_128451_("any");
        long parallel = 0L;
        if (solarisCost > 0) {
            parallel = this.solaris / (long)solarisCost;
        } else if (lunaraCost > 0) {
            parallel = this.lunara / (long)lunaraCost;
        } else if (voidfluxCost > 0) {
            parallel = this.voidflux / (long)voidfluxCost;
        } else if (stellarmCost > 0) {
            parallel = this.stellarm / (long)stellarmCost;
        } else if (anyCost > 0) {
            parallel = (this.solaris + this.lunara + this.voidflux + this.stellarm) / (long)anyCost;
        }
        if (parallel == 0L) {
            return null;
        }
        if ((recipe = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)parallel)) == null) {
            return null;
        }
        parallel = recipe.parallels;
        CelestialHandler.ResourceResult deductResult = null;
        if (solarisCost > 0) {
            deductResult = this.celestialHandler.deductResource("solaris", solarisCost, parallel, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (lunaraCost > 0) {
            deductResult = this.celestialHandler.deductResource("lunara", lunaraCost, parallel, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (voidfluxCost > 0) {
            deductResult = this.celestialHandler.deductResource("voidflux", voidfluxCost, parallel, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (stellarmCost > 0) {
            deductResult = this.celestialHandler.deductResource("stellarm", stellarmCost, parallel, this.solaris, this.lunara, this.voidflux, this.stellarm);
        } else if (anyCost > 0) {
            deductResult = this.celestialHandler.deductResource("ANY", anyCost, parallel, this.solaris, this.lunara, this.voidflux, this.stellarm);
        }
        if (deductResult != null && deductResult.success()) {
            this.solaris = deductResult.solaris();
            this.lunara = deductResult.lunara();
            this.voidflux = deductResult.voidflux();
            this.stellarm = deductResult.stellarm();
        }
        return recipe;
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        if (this.isFormed()) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.oc_amount", (Object[])new Object[]{this.accelerate}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gtocore.machine.steam_parallel_machine.oc")))));
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.steam_parallel_machine.modification_oc").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-] "), (String)"ocSub")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"ocAdd")));
        }
        if (this.solaris > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.solaris", (Object[])new Object[]{this.solaris}));
        }
        if (this.lunara > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.lunara", (Object[])new Object[]{this.lunara}));
        }
        if (this.voidflux > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.voidflux", (Object[])new Object[]{this.voidflux}));
        }
        if (this.stellarm > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.stellarm", (Object[])new Object[]{this.stellarm}));
        }
    }

    public void handleDisplayClick(@NotNull String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            this.accelerate = (short)Mth.m_14045_((int)(this.accelerate + ("ocAdd".equals(componentData) ? 1 : -1)), (int)0, (int)4);
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tickSubs.initialize(this.getLevel());
    }

    public void clientTick() {
        super.clientTick();
        if (this.getLevel() == null || this.getLevel() instanceof TrackedDummyWorld) {
            return;
        }
        if (this.isFormed()) {
            if (!this.clientRemovedBlocks) {
                this.clientRemovedBlocks = this.removeBlockFromWorld();
            }
        } else if (this.clientRemovedBlocks) {
            this.clientRemovedBlocks = !this.addBlockToWorld();
        }
    }

    private void tickUpdate() {
        Level world = this.getLevel();
        if (world == null) {
            return;
        }
        if (this.timing == 0) {
            this.getRecipeLogic().updateTickSubscription();
            this.timing = 40;
        } else {
            --this.timing;
        }
        CelestialHandler.Resource updatedResources = this.celestialHandler.increase(world, this.getMultiple() * 100, this.solaris, this.lunara, this.voidflux, this.stellarm, this.mode);
        this.solaris = updatedResources.solaris();
        this.lunara = updatedResources.lunara();
        this.voidflux = updatedResources.voidflux();
        this.stellarm = updatedResources.stellarm();
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel() != null) {
            this.mode = this.celestialHandler.initMode(this.getLevel());
        }
    }

    private int getMultiple() {
        if (this.accelerate > 0) {
            int cost = GTOValues.MANA[this.accelerate * 2 + 4] * 2;
            if ((long)cost > this.removeMana(cost, 1, false)) {
                this.accelerate = 0;
            } else if ((long)cost > this.removeMana(cost, 1, true)) {
                this.accelerate = 0;
            }
        }
        return 1 << this.accelerate * 5;
    }

    private boolean removeBlockFromWorld() {
        String[][] structure = StructurePattern.tinyLight;
        for (int x = 0; x < structure.length; ++x) {
            String[] plane = structure[x];
            for (int y = 0; y < plane.length; ++y) {
                String row = plane[y];
                for (int z = 0; z < row.length(); ++z) {
                    char letter = row.charAt(z);
                    if (letter == ' ') continue;
                    BlockPos realPos = this.getRealPos(x, y, z);
                    if (!this.getLevel().m_46749_(realPos)) {
                        return false;
                    }
                    this.getLevel().m_7731_(realPos, Blocks.f_50016_.m_49966_(), 48);
                    ClientUtil.getPreventUpdate((Level)this.getLevel()).add(realPos.m_121878_());
                }
            }
        }
        return true;
    }

    private boolean addBlockToWorld() {
        StructureVBO ringStructure = new StructureVBO().addMapping('X', (Block)GTOBlocks.THE_SOLARIS_LENS.get()).addMapping('[', RegistriesUtils.getBlock((String)"ars_nouveau:sky_block"));
        String[][] structure = StructurePattern.tinyLight;
        ringStructure.assignStructure(structure);
        for (int x = 0; x < structure.length; ++x) {
            String[] plane = structure[x];
            for (int y = 0; y < plane.length; ++y) {
                String row = plane[y];
                for (int z = 0; z < row.length(); ++z) {
                    char letter = row.charAt(z);
                    if (letter == ' ') continue;
                    BlockPos realPos = this.getRealPos(x, y, z);
                    if (!this.getLevel().m_46749_(realPos)) {
                        return false;
                    }
                    BlockState blockState = ((Block)ringStructure.mapper.get(letter)).m_49966_();
                    ClientUtil.getPreventUpdate((Level)this.getLevel()).remove(realPos.m_121878_());
                    this.getLevel().m_7731_(realPos, blockState, 48);
                }
            }
        }
        return true;
    }

    private BlockPos getRealPos(int x, int y, int z) {
        String[][] structure = StructurePattern.tinyLight;
        BlockPos.MutableBlockPos pos = BlockPos.f_121853_.m_7918_(5 + structure.length / 2 - x, -structure[0].length / 2 + y + 8, -structure[0][0].length() / 2 + z).m_122032_();
        switch (this.getFrontFacing()) {
            case EAST: {
                pos.m_122178_(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
                break;
            }
            case NORTH: {
                pos.m_122178_(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
                break;
            }
            case SOUTH: {
                pos.m_122178_(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
            }
        }
        return pos.m_121955_((Vec3i)this.getPos());
    }

    @Generated
    public long getSolaris() {
        return this.solaris;
    }

    @Generated
    public long getLunara() {
        return this.lunara;
    }

    @Generated
    public long getVoidflux() {
        return this.voidflux;
    }

    @Generated
    public long getStellarm() {
        return this.stellarm;
    }
}

