/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gtolib.api.machine.mana.feature.IManaMultiblock;
import com.gtolib.api.machine.mana.trait.ManaTrait;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.misc.ManaContainerList;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricManaMultiblockMachine
extends ElectricMultiblockMachine
implements IManaMultiblock {
    private final ManaTrait manaTrait = new ManaTrait((IManaMultiblock)this);

    public ElectricManaMultiblockMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public boolean handleTickRecipe(@Nullable Recipe recipe) {
        if (recipe != null) {
            long eu = recipe.eut;
            if (eu != 0L && !this.useEnergy(eu, false)) {
                IdleReason.setIdleReason((IRecipeLogicMachine)this, (IdleReason)(recipe.eut < 0L ? IdleReason.INSUFFICIENT_OUT : IdleReason.NO_EU));
                return false;
            }
            long mana = recipe.manat;
            if (mana != 0L && !this.useMana(mana, false)) {
                IdleReason.setIdleReason((IRecipeLogicMachine)this, (IdleReason)(recipe.manat < 0L ? IdleReason.INSUFFICIENT_OUT : IdleReason.NO_MANA));
                return false;
            }
            long cwu = recipe.cwut;
            if (cwu != 0L && this.requestCWU(cwu, false) < cwu) {
                IdleReason.setIdleReason((IRecipeLogicMachine)this, (IdleReason)IdleReason.NO_CWU);
                return false;
            }
        }
        return true;
    }

    public boolean regressWhenWaiting() {
        return false;
    }

    @NotNull
    public ManaContainerList getManaContainer() {
        return this.manaTrait.getManaContainers();
    }

    public boolean isGeneratorMana() {
        return true;
    }
}

