/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gtocore.common.machine.mana.multiblock.ManaMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LargeAlchemicalDeviceMachine
extends ManaMultiblockMachine {
    @Persisted
    private final int[] probabilityParams = new int[]{10000, 10000, 10000};
    private final int[] currentRecipeParams = new int[3];
    private boolean perfectProbability = false;
    private double timeReduction = 0.4;

    public LargeAlchemicalDeviceMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.perfectProbability = this.getSubFormedAmount() == 1;
        this.timeReduction = this.getSubFormedAmount() == 1 ? 0.01 : 0.4;
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        boolean param = false;
        long parallels = MachineUtils.getHatchParallel((MetaMachine)this);
        recipe.duration = Math.max(1, (int)((double)recipe.duration * this.timeReduction));
        for (int i = 0; i < 3; ++i) {
            String key = "param" + (i + 1);
            param = param || recipe.data.m_128441_(key);
            this.currentRecipeParams[i] = recipe.data.m_128441_(key) ? recipe.data.m_128451_(key) * 100 : 10000;
        }
        if (param) {
            this.adjustParameters(this.currentRecipeParams);
            return ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)this.enhanceRecipe(recipe, this.currentRecipeParams), (long)parallels);
        }
        return ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)parallels);
    }

    private Recipe enhanceRecipe(Recipe recipe, int[] recipeParams) {
        int matchRate = this.calculateMatchRate(recipeParams);
        recipe.outputs.put(ItemRecipeCapability.CAP, recipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP).stream().map(content -> {
            if (content.chance < 11) {
                return new Content(content.content, matchRate, 0);
            }
            return content;
        }).toList());
        recipe.outputs.put(FluidRecipeCapability.CAP, recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP).stream().map(content -> {
            if (content.chance < 11) {
                return new Content(content.content, matchRate, 0);
            }
            return content;
        }).toList());
        return recipe;
    }

    private int calculateMatchRate(int[] recipeParams) {
        if (this.perfectProbability) {
            return 10000;
        }
        int distance = LargeAlchemicalDeviceMachine.calculateDistance(this.probabilityParams, recipeParams);
        if (distance <= 0) {
            return 10000;
        }
        if (distance <= 5) {
            return 9000;
        }
        if (distance >= 3000) {
            return 1;
        }
        float linear = 1.0f - (float)distance * 3.3333333E-4f;
        float exponential = (float)Math.exp((float)(1000 - distance) * 5.0E-4f);
        int randomValue = LDLib.random.nextInt() & 3;
        return Mth.m_14045_((int)Math.round(5000.0f * linear * exponential * (float)randomValue), (int)0, (int)10000);
    }

    private static int calculateDistance(int[] p, int[] r) {
        int d = 0;
        int rmc = 0;
        int pmc = 0;
        boolean pMask = false;
        boolean rMask = false;
        double cp2 = 0.0;
        double pr2 = 0.0;
        double dot = 0.0;
        int c = 10000;
        for (int i = 0; i < 3; ++i) {
            int pi = p[i];
            int ri = r[i];
            d += Math.abs(pi - ri);
            rmc += Math.abs(ri - 10000);
            pmc += Math.abs(pi - 10000);
            pMask |= pi >= 10000 ? 1 << i : 0;
            rMask |= ri >= 10000 ? 1 << i : 0;
            double cp = pi - 10000;
            double pr = ri - pi;
            cp2 += cp * cp;
            pr2 += pr * pr;
            dot += cp * pr;
        }
        if (pMask != rMask | rmc > pmc) {
            return d;
        }
        return dot * dot >= 0.984807753 * cp2 * pr2 ? -d : d;
    }

    private void adjustParameters(int[] targetParams) {
        for (int i = 0; i < 3; ++i) {
            this.probabilityParams[i] = Mth.m_14045_((int)Math.round((float)this.probabilityParams[i] * 0.66f + (float)targetParams[i] * 0.34f), (int)0, (int)20000);
        }
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.duration_multiplier.tooltip", (Object[])new Object[]{this.timeReduction}));
        if (this.perfectProbability) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.alchemical_device.2"));
        } else {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.alchemical_device.1"));
        }
    }
}

