/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.widget.LongInputWidget;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gtocore.api.gui.DisplayComponentGroup;
import com.gtocore.common.machine.monitor.BasicMonitor;
import com.gtocore.common.machine.monitor.IInformationProvider;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractInfoProviderMonitor
extends BasicMonitor
implements IInformationProvider {
    @Persisted
    @DescSynced
    private long priority = 0L;
    @Persisted
    @DescSynced
    private ResourceLocation[] displayOrderCache = new ResourceLocation[0];
    @Persisted
    @DescSynced
    private boolean[] displayEnabledCache = new boolean[0];
    private TickableSubscription tickableSubscription;

    AbstractInfoProviderMonitor(MetaMachineBlockEntity holder) {
        super(holder);
        Class<?> clazz = this.getClass();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.tickableSubscription = this.subscribeServerTick(this.tickableSubscription, () -> {
            this.syncInfoFromServer();
            this.getSyncStorage().markAllDirty();
            this.requestSync();
        }, 10);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tickableSubscription != null) {
            this.tickableSubscription.unsubscribe();
            this.tickableSubscription = null;
        }
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(long priority) {
        this.priority = priority;
        if (this.getLevel() != null && !this.getLevel().m_5776_()) {
            this.requestSync();
        }
    }

    @Override
    public List<ResourceLocation> getSortedRLs() {
        if (this.displayOrderCache == null || this.displayOrderCache.length == 0) {
            return this.getAvailableRLs();
        }
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.displayOrderCache.length; ++i) {
            if (i >= this.displayEnabledCache.length || !this.displayEnabledCache[i] || !this.getAvailableRLs().contains(this.displayOrderCache[i])) continue;
            list.add(this.displayOrderCache[i]);
        }
        return list;
    }

    private List<ObjectBooleanPair<ResourceLocation>> getComponentStatesForGui() {
        if (this.displayOrderCache == null || this.displayOrderCache.length == 0) {
            return this.getAvailableRLs().stream().map(rl -> ObjectBooleanPair.of((Object)rl, (boolean)true)).toList();
        }
        ArrayList<ObjectBooleanPair<ResourceLocation>> list = new ArrayList<ObjectBooleanPair<ResourceLocation>>();
        for (int i = 0; i < this.displayOrderCache.length; ++i) {
            if (!this.getAvailableRLs().contains(this.displayOrderCache[i])) continue;
            boolean isEnabled = i < this.displayEnabledCache.length && this.displayEnabledCache[i];
            list.add((ObjectBooleanPair<ResourceLocation>)ObjectBooleanPair.of((Object)this.displayOrderCache[i], (boolean)isEnabled));
        }
        return list;
    }

    public Widget createUIWidget() {
        long initialPriority = this.priority;
        LongInputWidget input = new LongInputWidget(Position.of((int)50, (int)144), this::getPriority, this::setPriority);
        input.setMax((Number)Integer.MAX_VALUE).setMin((Number)Integer.MIN_VALUE).setValue((Number)initialPriority);
        input.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.monitor.priority")});
        Widget panel = new ComponentPanelWidget(input.getPositionX() + input.getSizeWidth() / 2, input.getPositionY() - 15, List.of(Component.m_237115_((String)"gtocore.machine.monitor.priority").m_130940_(ChatFormatting.BLACK))).setCenter(true).setClientSideWidget();
        DisplayComponentGroup scrollAreaWrapper = new DisplayComponentGroup(this.getAvailableRLs(), this.getComponentStatesForGui(), this::setComponentStateCache, new Position(16, 16), new Size(168, 108));
        return new WidgetGroup(0, 0, 200, 160).addWidget(panel).addWidget((Widget)input).addWidget((Widget)scrollAreaWrapper);
    }

    private void setComponentStateCache(List<ObjectBooleanPair<ResourceLocation>> componentStates) {
        if (this.getLevel() != null && !this.getLevel().m_5776_()) {
            int size = componentStates.size();
            this.displayOrderCache = new ResourceLocation[size];
            this.displayEnabledCache = new boolean[size];
            for (int i = 0; i < size; ++i) {
                ObjectBooleanPair<ResourceLocation> pair = componentStates.get(i);
                this.displayOrderCache[i] = (ResourceLocation)pair.left();
                this.displayEnabledCache[i] = pair.rightBoolean();
            }
        }
    }
}

