/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import appeng.api.networking.IGrid;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.PowerSubstationMachine;
import com.gtocore.common.machine.monitor.AbstractAEInfoMonitor;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEFluidList;
import com.gtocore.common.machine.multiblock.part.ae.slots.ExportOnlyAEItemList;
import com.gtocore.common.machine.multiblock.part.ae.widget.AEFluidConfigWidget;
import com.gtocore.common.machine.multiblock.part.ae.widget.AEItemConfigWidget;
import com.gtolib.api.ae2.IExpandedStorageService;
import com.hepdd.gtmthings.api.misc.EnergyStat;
import com.hepdd.gtmthings.utils.FormatUtil;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonitorAEThroughput
extends AbstractAEInfoMonitor {
    @DescSynced
    private CompoundTag displayingEntry = new CompoundTag();
    private final EnergyStat[] stats = new EnergyStat[2];
    private final long[] lastAmount = new long[]{0L, 0L};
    @Persisted
    private final AEItem aeItem = new AEItem(this);
    @Persisted
    private final AEFluid aeFluid = new AEFluid(this);
    @DescSynced
    private final long[] currentAmount = new long[]{0L, 0L};
    @DescSynced
    private final long[] lastMinuteStat = new long[]{0L, 0L};
    @DescSynced
    private final long[] lastHourStat = new long[]{0L, 0L};
    @DescSynced
    private final long[] lastDayStat = new long[]{0L, 0L};
    @DescSynced
    private final long[] nowStat = new long[]{0L, 0L};
    private final CurrentGettable[] aeItemFluidGettables = new CurrentGettable[]{this.aeItem, this.aeFluid};
    private static final ImmutableList<DisplayRegistry> ID_MAP = ImmutableList.of((Object)((Object)DisplayRegistry.AE_STATUS_0), (Object)((Object)DisplayRegistry.AE_AMOUNT_0), (Object)((Object)DisplayRegistry.AE_STAT_MINUTE_0), (Object)((Object)DisplayRegistry.AE_STAT_HOUR_0), (Object)((Object)DisplayRegistry.AE_STAT_DAY_0), (Object)((Object)DisplayRegistry.AE_STAT_REMAINING_TIME_0), (Object)((Object)DisplayRegistry.AE_STATUS_1), (Object)((Object)DisplayRegistry.AE_AMOUNT_1), (Object)((Object)DisplayRegistry.AE_STAT_MINUTE_1), (Object)((Object)DisplayRegistry.AE_STAT_HOUR_1), (Object)((Object)DisplayRegistry.AE_STAT_DAY_1), (Object)((Object)DisplayRegistry.AE_STAT_REMAINING_TIME_1), (Object[])new DisplayRegistry[0]);

    public MonitorAEThroughput(MetaMachineBlockEntity holder) {
        super(holder);
        this.aeItem.addChangedListener(() -> this.onFilterChanged(0));
        this.aeFluid.addChangedListener(() -> this.onFilterChanged(1));
    }

    public MonitorAEThroughput(Object o) {
        this((MetaMachineBlockEntity)o);
    }

    @Override
    public void syncInfoFromServer() {
        int time = (int)Objects.requireNonNull(this.getLevel(), "Not on the server side").m_46467_();
        if (time - this.lastUpdateTime < 40) {
            return;
        }
        this.lastUpdateTime = time;
        IGrid grid = this.nodeHolder.getMainNode().getGrid();
        if (grid == null || !this.isOnline()) {
            this.state = AbstractAEInfoMonitor.State.NO_GRID;
            return;
        }
        boolean hasConfig = false;
        this.displayingEntry = new CompoundTag();
        for (int i = 0; i < 2; ++i) {
            AEKey current = this.aeItemFluidGettables[i].getCurrent();
            if (current == null) continue;
            hasConfig = true;
            long amount = IExpandedStorageService.of((IStorageService)grid.getStorageService()).getLazyKeyCounter().get(current);
            long change = amount - this.lastAmount[i];
            if (this.stats[i] == null) {
                this.stats[i] = new EnergyStat(this.lastUpdateTime);
            }
            if (change != 0L) {
                this.stats[i].update(BigInteger.valueOf(change), this.lastUpdateTime);
            }
            this.lastAmount[i] = this.currentAmount[i];
            this.currentAmount[i] = amount;
            this.lastMinuteStat[i] = this.stats[i].minute.getAvgByTick().longValue();
            this.lastHourStat[i] = this.stats[i].hour.getAvgByTick().longValue();
            this.lastDayStat[i] = this.stats[i].day.getAvgByTick().longValue();
            this.nowStat[i] = change;
            this.displayingEntry.m_128365_(String.valueOf(i), (Tag)current.toTagGeneric());
        }
        this.state = hasConfig ? AbstractAEInfoMonitor.State.NORMAL : AbstractAEInfoMonitor.State.NO_CONFIG;
    }

    @Override
    public List<ResourceLocation> getAvailableRLs() {
        List<ResourceLocation> rls = super.getAvailableRLs();
        rls.add(DisplayRegistry.AE_STAT_TITLE.id());
        rls.addAll(ID_MAP.stream().map(DisplayRegistry::id).toList());
        return rls;
    }

    @Override
    public DisplayComponentList provideInformation() {
        DisplayComponentList infoList = super.provideInformation();
        if (this.state == AbstractAEInfoMonitor.State.NORMAL) {
            for (int i = 0; i < 2; ++i) {
                if (!this.displayingEntry.m_128441_(String.valueOf(i))) continue;
                int unit = i == 0 ? 80 : 80000;
                AtomicInteger atomI = new AtomicInteger(i == 0 ? 0 : 6);
                BiFunction<Long, ChatFormatting, Component> formatter = this.getAmountFormatter(i, unit);
                ResourceLocation itemId = ((DisplayRegistry)((Object)ID_MAP.get(atomI.getAndIncrement()))).id();
                AEKey itemKey = AEKey.fromTagGeneric((CompoundTag)this.displayingEntry.m_128469_(String.valueOf(i)));
                if (itemKey != null) {
                    infoList.addIfAbsent(itemId, Component.m_237110_((String)("gtocore.machine.monitor.ae.status." + i), (Object[])new Object[]{itemKey.getDisplayName().m_6881_().m_130940_(ChatFormatting.AQUA)}).m_7532_());
                }
                infoList.addIfAbsent(((DisplayRegistry)((Object)ID_MAP.get(atomI.getAndIncrement()))).id(), Component.m_237110_((String)"gtocore.machine.monitor.ae.amount", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatNumber((long)(this.currentAmount[i] / (long)unit * 80L))).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(i == 0 ? "" : "B")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"(").m_130940_(ChatFormatting.WHITE).m_7220_(formatter.apply(this.nowStat[i], ChatFormatting.DARK_PURPLE)).m_7220_((Component)Component.m_237113_((String)"/t").m_130940_(ChatFormatting.GRAY)).m_130946_(")").m_130940_(ChatFormatting.WHITE))}).m_7532_());
                infoList.addIfAbsent(DisplayRegistry.AE_STAT_TITLE.id(), Component.m_237115_((String)"gtocore.machine.monitor.ae.stat.title").m_7532_());
                infoList.addIfAbsent(((DisplayRegistry)((Object)ID_MAP.get(atomI.getAndIncrement()))).id(), Component.m_237110_((String)"gtocore.machine.monitor.ae.stat.minute", (Object[])new Object[]{formatter.apply(this.lastMinuteStat[i], ChatFormatting.DARK_AQUA)}).m_7532_());
                infoList.addIfAbsent(((DisplayRegistry)((Object)ID_MAP.get(atomI.getAndIncrement()))).id(), Component.m_237110_((String)"gtocore.machine.monitor.ae.stat.hour", (Object[])new Object[]{formatter.apply(this.lastHourStat[i], ChatFormatting.YELLOW)}).m_7532_());
                infoList.addIfAbsent(((DisplayRegistry)((Object)ID_MAP.get(atomI.getAndIncrement()))).id(), Component.m_237110_((String)"gtocore.machine.monitor.ae.stat.day", (Object[])new Object[]{formatter.apply(this.lastDayStat[i], ChatFormatting.DARK_GREEN)}).m_7532_());
                if (this.nowStat[i] >= 0L) continue;
                long absSec = Math.abs(this.nowStat[i]) * 20L;
                infoList.addIfAbsent(((DisplayRegistry)((Object)ID_MAP.get(atomI.getAndIncrement()))).id(), Component.m_237110_((String)"gtocore.machine.monitor.ae.stat.remaining_time", (Object[])new Object[]{PowerSubstationMachine.getTimeToFillDrainText((BigInteger)BigInteger.valueOf(this.currentAmount[i] / absSec)).m_130940_(ChatFormatting.GRAY)}).m_7532_());
            }
        }
        return infoList;
    }

    @NotNull
    private BiFunction<Long, ChatFormatting, Component> getAmountFormatter(int i, int unit) {
        return (num, color) -> {
            Object sign;
            Object object = sign = this.nowStat[i] >= 0L ? "+" : "-";
            if (num % (long)unit != 0L) {
                sign = (String)sign + "~";
            }
            return Component.m_237113_((String)sign).m_130940_(color).m_7220_((Component)Component.m_237113_((String)FormatUtil.formatNumber((long)(Math.abs(num) / (long)unit))).m_130940_(color)).m_7220_((Component)Component.m_237113_((String)(i == 0 ? "" : "B")).m_130940_(ChatFormatting.GRAY));
        };
    }

    @Override
    public Widget createUIWidget() {
        Widget superWidget = super.createUIWidget();
        AEItemConfigWidget itemWidget = new AEItemConfigWidget(50, 186, this.aeItem);
        AEFluidConfigWidget fluidWidget = new AEFluidConfigWidget(132, 186, this.aeFluid);
        Widget panel = new ComponentPanelWidget(96 + fluidWidget.getSizeWidth(), 171, List.of(Component.m_237115_((String)"gtocore.machine.monitor.ae.set_filter").m_130940_(ChatFormatting.BLACK))).setCenter(true).setClientSideWidget();
        return new WidgetGroup(0, 0, 200, 216).addWidget(superWidget).addWidget((Widget)itemWidget).addWidget((Widget)fluidWidget).addWidget(panel);
    }

    private void onFilterChanged(int slot) {
        this.stats[slot] = null;
    }

    private class AEItem
    extends ExportOnlyAEItemList
    implements CurrentGettable {
        AEItem(MonitorAEThroughput monitorAEThroughput) {
            super(monitorAEThroughput, 1);
        }

        @Override
        @Nullable
        public AEKey getCurrent() {
            return this.getInventory()[0].getConfig() == null ? null : this.getInventory()[0].getConfig().what();
        }

        @Override
        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }
    }

    private class AEFluid
    extends ExportOnlyAEFluidList
    implements CurrentGettable {
        AEFluid(MonitorAEThroughput monitorAEThroughput) {
            super(monitorAEThroughput, 1);
        }

        @Override
        @Nullable
        public AEKey getCurrent() {
            return this.getInventory()[0].getConfig() == null ? null : this.getInventory()[0].getConfig().what();
        }

        @Override
        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }
    }

    private static interface CurrentGettable {
        @Nullable
        public AEKey getCurrent();
    }
}

