/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.google.common.collect.ImmutableBiMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.PowerSubstationMachine;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.machine.monitor.AbstractInfoProviderMonitor;
import com.gtocore.common.machine.monitor.DisplayComponent;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.gtocore.common.machine.monitor.ITeamInformationProvider;
import com.hepdd.gtmthings.api.misc.EnergyStat;
import com.hepdd.gtmthings.api.misc.WirelessEnergyContainer;
import com.hepdd.gtmthings.common.item.IWirelessMonitor;
import com.hepdd.gtmthings.utils.FormatUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class MonitorEU
extends AbstractInfoProviderMonitor
implements IWirelessMonitor,
ITeamInformationProvider {
    private WirelessEnergyContainer WirelessEnergyContainerCache;
    private List<FormattedCharSequence> textListCache;
    private static final ImmutableBiMap<Integer, DisplayRegistry> DISPLAY_REGISTRY = ImmutableBiMap.builder().put((Object)0, (Object)DisplayRegistry.TOTAL_ENERGY).put((Object)1, (Object)DisplayRegistry.ENERGY_TRANSFER_LIMIT).put((Object)2, (Object)DisplayRegistry.ENERGY_STAT_TITLE).put((Object)3, (Object)DisplayRegistry.ENERGY_STAT_MINUTE).put((Object)4, (Object)DisplayRegistry.ENERGY_STAT_HOUR).put((Object)5, (Object)DisplayRegistry.ENERGY_STAT_DAY).put((Object)6, (Object)DisplayRegistry.ENERGY_STAT_NOW).put((Object)7, (Object)DisplayRegistry.ENERGY_STAT_TITLE_INPUT).put((Object)8, (Object)DisplayRegistry.ENERGY_STAT_MINUTE_INPUT).put((Object)9, (Object)DisplayRegistry.ENERGY_STAT_HOUR_INPUT).put((Object)10, (Object)DisplayRegistry.ENERGY_STAT_DAY_INPUT).put((Object)11, (Object)DisplayRegistry.ENERGY_STAT_NOW_INPUT).put((Object)12, (Object)DisplayRegistry.ENERGY_STAT_TITLE_OUTPUT).put((Object)13, (Object)DisplayRegistry.ENERGY_STAT_MINUTE_OUTPUT).put((Object)14, (Object)DisplayRegistry.ENERGY_STAT_HOUR_OUTPUT).put((Object)15, (Object)DisplayRegistry.ENERGY_STAT_DAY_OUTPUT).put((Object)16, (Object)DisplayRegistry.ENERGY_STAT_NOW_OUTPUT).put((Object)17, (Object)DisplayRegistry.ENERGY_STAT_REMAINING_TIME).put((Object)18, (Object)DisplayRegistry.ENERGY_STAT_BOUND_INFO).build();
    @DescSynced
    private Component[] bufferCache = new Component[0];
    @DescSynced
    private float energyFullness = 0.0f;
    @DescSynced
    private ArrayList<String> EnergyInputHistoryDay = new ArrayList();
    @DescSynced
    private ArrayList<String> EnergyOutputHistoryDay = new ArrayList();
    @DescSynced
    private ArrayList<String> EnergyInputHistoryHour = new ArrayList();
    @DescSynced
    private ArrayList<String> EnergyOutputHistoryHour = new ArrayList();
    @DescSynced
    private ArrayList<String> EnergyInputHistoryMinute = new ArrayList();
    @DescSynced
    private ArrayList<String> EnergyOutputHistoryMinute = new ArrayList();

    public MonitorEU(Object o) {
        this((MetaMachineBlockEntity)o);
    }

    public MonitorEU(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.getOffsetTimer() % 10 == 0 && this.bufferCache != null) {
            this.textListCache = Stream.of(this.bufferCache).map(component -> (Component)Objects.requireNonNullElse(component, Component.m_237119_())).map(Component::m_7532_).toList();
        }
    }

    public void setWirelessEnergyContainerCache(WirelessEnergyContainer container) {
        this.WirelessEnergyContainerCache = container;
    }

    public WirelessEnergyContainer getWirelessEnergyContainerCache() {
        return this.WirelessEnergyContainerCache;
    }

    @Override
    public void syncInfoFromServer() {
        if (this.textListCache == null) {
            this.bufferCache = this.getComponentArray();
        }
    }

    public Component[] getComponentArray() {
        WirelessEnergyContainer container = this.getWirelessEnergyContainer();
        if (container == null) {
            return new Component[0];
        }
        Component[] textListCache = new Component[DISPLAY_REGISTRY.size()];
        BigInteger energyTotal = container.getStorage();
        textListCache[0] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.1", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigIntegerNumberOrSic((BigInteger)energyTotal)), new Component[0]}).m_130940_(ChatFormatting.GOLD);
        long rate = container.getRate();
        textListCache[1] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.2", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigIntegerNumberOrSic((BigInteger)BigInteger.valueOf(rate))), Component.m_237113_((String)String.valueOf(rate / GTValues.VEX[GTUtil.getFloorTierByVoltage((long)rate)])), Component.m_237113_((String)GTValues.VNF[GTUtil.getFloorTierByVoltage((long)rate)])}).m_130940_(ChatFormatting.GRAY);
        EnergyStat stat = container.getEnergyStat();
        textListCache[2] = Component.m_237115_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.net_power");
        BigDecimal avgMinute = stat.minute.getAvgByTick();
        textListCache[3] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_minute", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)avgMinute)).m_130940_(ChatFormatting.DARK_AQUA), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)avgMinute).toEngineeringString()), FormatUtil.voltageName((BigDecimal)avgMinute)});
        BigDecimal avgHour = stat.hour.getAvgByTick();
        textListCache[4] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_hour", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)avgHour)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)avgHour).toEngineeringString()), FormatUtil.voltageName((BigDecimal)avgHour)});
        BigDecimal avgDay = stat.day.getAvgByTick();
        textListCache[5] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_day", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)avgDay)).m_130940_(ChatFormatting.DARK_GREEN), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)avgDay).toEngineeringString()), FormatUtil.voltageName((BigDecimal)avgDay)});
        BigDecimal avgEnergy = stat.getAvgEnergy();
        textListCache[6] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.now", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)avgEnergy)).m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)avgEnergy).toEngineeringString()), FormatUtil.voltageName((BigDecimal)avgEnergy)});
        textListCache[7] = Component.m_237115_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.input_power");
        BigDecimal InputMinute = stat.minute.getAvgInputByTick();
        textListCache[8] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_minute", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)InputMinute)).m_130940_(ChatFormatting.DARK_AQUA), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)InputMinute).toEngineeringString()), FormatUtil.voltageName((BigDecimal)InputMinute)});
        BigDecimal InputHour = stat.hour.getAvgInputByTick();
        textListCache[9] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_hour", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)InputHour)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)InputHour).toEngineeringString()), FormatUtil.voltageName((BigDecimal)InputHour)});
        BigDecimal InputDay = stat.day.getAvgInputByTick();
        textListCache[10] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_day", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)InputDay)).m_130940_(ChatFormatting.DARK_GREEN), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)InputDay).toEngineeringString()), FormatUtil.voltageName((BigDecimal)InputDay)});
        BigDecimal InputEnergy = stat.getAvgInput();
        textListCache[11] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.now", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)InputEnergy)).m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)InputEnergy).toEngineeringString()), FormatUtil.voltageName((BigDecimal)InputEnergy)});
        textListCache[12] = Component.m_237115_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.output_power");
        BigDecimal OutputMinute = stat.minute.getAvgOutputByTick();
        textListCache[13] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_minute", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)OutputMinute)).m_130940_(ChatFormatting.DARK_AQUA), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)OutputMinute).toEngineeringString()), FormatUtil.voltageName((BigDecimal)OutputMinute)});
        BigDecimal OutputHour = stat.hour.getAvgOutputByTick();
        textListCache[14] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_hour", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)OutputHour)).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)OutputHour).toEngineeringString()), FormatUtil.voltageName((BigDecimal)OutputHour)});
        BigDecimal OutputDay = stat.day.getAvgOutputByTick();
        textListCache[15] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.last_day", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)OutputDay)).m_130940_(ChatFormatting.DARK_GREEN), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)OutputDay).toEngineeringString()), FormatUtil.voltageName((BigDecimal)OutputDay)});
        BigDecimal OutputEnergy = stat.getAvgOutput();
        textListCache[16] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.now", (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigDecimalNumberOrSic((BigDecimal)OutputEnergy)).m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)FormatUtil.voltageAmperage((BigDecimal)OutputEnergy).toEngineeringString()), FormatUtil.voltageName((BigDecimal)OutputEnergy)});
        int compare = avgEnergy.compareTo(BigDecimal.valueOf(0L));
        BigInteger multiply = avgEnergy.abs().toBigInteger().multiply(BigInteger.valueOf(20L));
        textListCache[17] = compare > 0 ? Component.m_237110_((String)"gtceu.multiblock.power_substation.time_to_fill", (Object[])new Object[]{container.getCapacity() == null ? Component.m_237115_((String)"gtmthings.machine.wireless_energy_monitor.tooltip.time_to_fill") : PowerSubstationMachine.getTimeToFillDrainText((BigInteger)container.getCapacity().subtract(energyTotal).divide(multiply))}).m_130940_(ChatFormatting.GRAY) : (compare < 0 ? Component.m_237110_((String)"gtceu.multiblock.power_substation.time_to_drain", (Object[])new Object[]{PowerSubstationMachine.getTimeToFillDrainText((BigInteger)energyTotal.divide(multiply))}).m_130940_(ChatFormatting.GRAY) : Component.m_237110_((String)"gtceu.multiblock.power_substation.time_to_drain", (Object[])new Object[]{Component.m_237115_((String)"gtceu.multiblock.power_substation.time_forever").m_130940_(ChatFormatting.GRAY)}));
        if (container.getBindPos() == null) {
            textListCache[18] = Component.m_237115_((String)"gtocore.machine.monitor.eu.no_container").m_130940_(ChatFormatting.RED);
        } else {
            String pos = container.getBindPos().m_122646_().m_123344_();
            textListCache[18] = Component.m_237110_((String)"gtmthings.machine.wireless_energy_hatch.tooltip.2", (Object[])new Object[]{Component.m_237110_((String)"recipe.condition.dimension.tooltip", (Object[])new Object[]{container.getBindPos().m_122640_().m_135782_().toString()}).m_130946_(" [").m_130946_(pos).m_130946_("] ")}).m_130940_(ChatFormatting.GRAY);
        }
        this.energyFullness = container.getCapacity() == null || container.getCapacity().equals(BigInteger.ZERO) ? 0.0f : new BigDecimal(energyTotal).divide(new BigDecimal(container.getCapacity()), 4, RoundingMode.DOWN).floatValue();
        this.EnergyInputHistoryDay = stat.day.getInputHistory().stream().map(BigInteger::toString).collect(Collectors.toCollection(ArrayList::new));
        this.EnergyOutputHistoryDay = stat.day.getOutputHistory().stream().map(BigInteger::toString).collect(Collectors.toCollection(ArrayList::new));
        this.EnergyInputHistoryHour = stat.hour.getInputHistory().stream().map(BigInteger::toString).collect(Collectors.toCollection(ArrayList::new));
        this.EnergyOutputHistoryHour = stat.hour.getOutputHistory().stream().map(BigInteger::toString).collect(Collectors.toCollection(ArrayList::new));
        this.EnergyInputHistoryMinute = stat.minute.getInputHistory().stream().map(BigInteger::toString).collect(Collectors.toCollection(ArrayList::new));
        this.EnergyOutputHistoryMinute = stat.minute.getOutputHistory().stream().map(BigInteger::toString).collect(Collectors.toCollection(ArrayList::new));
        return textListCache;
    }

    @Override
    public DisplayComponentList provideInformation() {
        DisplayComponentList informationList = ITeamInformationProvider.super.provideInformation();
        if (this.bufferCache.length == DISPLAY_REGISTRY.size()) {
            for (int i = 0; i < this.bufferCache.length; ++i) {
                if (!DISPLAY_REGISTRY.containsKey((Object)i) || this.bufferCache[i] == null) continue;
                informationList.addIfAbsent(((DisplayRegistry)((Object)DISPLAY_REGISTRY.get((Object)i))).id(), this.bufferCache[i].m_7532_());
            }
            informationList.addIfAbsent(DisplayRegistry.EU_STATUS_BAR.id(), DisplayComponent.progressBar(DisplayRegistry.EU_STATUS_BAR.id(), this.energyFullness, Component.m_237110_((String)"gtocore.machine.monitor.eu.fullness", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.energyFullness * 100.0f))}).getString()));
            informationList.addIfAbsent(DisplayRegistry.EnergyInputHistoryDay.id(), DisplayComponent.lineChart(DisplayRegistry.EnergyInputHistoryDay.id(), this.EnergyInputHistoryDay.stream().map(BigInteger::new).toList()));
            informationList.addIfAbsent(DisplayRegistry.EnergyOutputHistoryDay.id(), DisplayComponent.lineChart(DisplayRegistry.EnergyOutputHistoryDay.id(), this.EnergyOutputHistoryDay.stream().map(BigInteger::new).toList()));
            informationList.addIfAbsent(DisplayRegistry.EnergyInputHistoryHour.id(), DisplayComponent.lineChart(DisplayRegistry.EnergyInputHistoryHour.id(), this.EnergyInputHistoryHour.stream().map(BigInteger::new).toList()));
            informationList.addIfAbsent(DisplayRegistry.EnergyOutputHistoryHour.id(), DisplayComponent.lineChart(DisplayRegistry.EnergyOutputHistoryHour.id(), this.EnergyOutputHistoryHour.stream().map(BigInteger::new).toList()));
            informationList.addIfAbsent(DisplayRegistry.EnergyInputHistoryMinute.id(), DisplayComponent.lineChart(DisplayRegistry.EnergyInputHistoryMinute.id(), this.EnergyInputHistoryMinute.stream().map(BigInteger::new).toList()));
            informationList.addIfAbsent(DisplayRegistry.EnergyOutputHistoryMinute.id(), DisplayComponent.lineChart(DisplayRegistry.EnergyOutputHistoryMinute.id(), this.EnergyOutputHistoryMinute.stream().map(BigInteger::new).toList()));
        }
        return informationList;
    }

    @Override
    public List<ResourceLocation> getAvailableRLs() {
        List<ResourceLocation> rls = ITeamInformationProvider.super.getAvailableRLs();
        rls.addAll(DISPLAY_REGISTRY.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(DisplayRegistry::id).toList());
        rls.add(DisplayRegistry.EU_STATUS_BAR.id());
        rls.add(DisplayRegistry.EnergyInputHistoryDay.id());
        rls.add(DisplayRegistry.EnergyOutputHistoryDay.id());
        rls.add(DisplayRegistry.EnergyInputHistoryHour.id());
        rls.add(DisplayRegistry.EnergyOutputHistoryHour.id());
        rls.add(DisplayRegistry.EnergyInputHistoryMinute.id());
        rls.add(DisplayRegistry.EnergyOutputHistoryMinute.id());
        return rls;
    }
}

