/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.PowerSubstationMachine;
import com.gtocore.common.machine.monitor.AbstractInfoProviderMonitor;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.gtocore.common.machine.monitor.DisplayType;
import com.gtocore.common.machine.monitor.IDisplayComponent;
import com.gtocore.common.machine.monitor.ITeamInformationProvider;
import com.gtolib.api.wireless.WirelessManaContainer;
import com.hepdd.gtmthings.utils.FormatUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MonitorMana
extends AbstractInfoProviderMonitor
implements ITeamInformationProvider {
    @DescSynced
    private long manaBufferCache = 0L;
    private long manaBufferCache0_5s = 0L;
    @DescSynced
    private long manaBufferCache1s = 0L;

    public MonitorMana(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public void syncInfoFromServer() {
        if (this.getUUID() != null) {
            this.manaBufferCache1s = this.manaBufferCache0_5s;
            this.manaBufferCache0_5s = this.manaBufferCache;
            this.manaBufferCache = WirelessManaContainer.getOrCreateContainer((UUID)this.getUUID()).getStorage().longValue();
        }
    }

    public MonitorMana(Object o) {
        this((MetaMachineBlockEntity)o);
    }

    @Override
    public DisplayComponentList provideInformation() {
        DisplayComponentList informationList = ITeamInformationProvider.super.provideInformation();
        if (this.getUUID() != null) {
            informationList.addIfAbsent(DisplayRegistry.MANA_CURRENT.id(), Component.m_237115_((String)"gtocore.machine.monitor.mana.current").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)FormatUtil.formatNumber((long)this.manaBufferCache)).m_130940_(ChatFormatting.AQUA)).m_7532_());
            informationList.addIfAbsent(DisplayRegistry.MANA_CURRENT_AS_POOL.id(), Component.m_237115_((String)"gtocore.machine.monitor.mana.pool.0").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(this.manaBufferCache / 1000000L >= 1000L ? FormatUtil.formatNumber((long)(this.manaBufferCache / 1000000L)) : String.format("%.02f", Float.valueOf((float)this.manaBufferCache / 1000000.0f)))).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237115_((String)"gtocore.machine.monitor.mana.pool.1").m_130940_(ChatFormatting.GRAY)).m_7532_());
            long manaChange = this.manaBufferCache - this.manaBufferCache1s;
            long manaChangeAbs = Math.abs(manaChange);
            if (manaChange >= 0L) {
                informationList.addIfAbsent(DisplayRegistry.MANA_CHANGE.id(), Component.m_237115_((String)"gtocore.machine.monitor.mana.increase").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)FormatUtil.formatNumber((long)manaChangeAbs)).m_130940_(ChatFormatting.AQUA)).m_7532_());
                informationList.addIfAbsent(DisplayRegistry.MANA_CHANGE_AS_POOL.id(), Component.m_237115_((String)"gtocore.machine.monitor.mana.pool.0").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(manaChangeAbs / 1000000L >= 1000L ? FormatUtil.formatNumber((long)(manaChangeAbs / 1000000L)) : String.format("%.02f", Float.valueOf((float)manaChangeAbs / 1000000.0f)))).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237115_((String)"gtocore.machine.monitor.mana.pool.2").m_130940_(ChatFormatting.BLUE)).m_7532_());
            } else {
                informationList.addIfAbsent(DisplayRegistry.MANA_CHANGE.id(), Component.m_237115_((String)"gtocore.machine.monitor.mana.decrease").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)FormatUtil.formatNumber((long)manaChangeAbs)).m_130940_(ChatFormatting.AQUA)).m_7532_());
                informationList.addIfAbsent(DisplayRegistry.MANA_CHANGE_AS_POOL.id(), Component.m_237115_((String)"gtocore.machine.monitor.mana.pool.0").m_130940_(ChatFormatting.BLUE).m_7220_((Component)Component.m_237113_((String)(manaChangeAbs / 1000000L >= 1000L ? FormatUtil.formatNumber((long)(manaChangeAbs / 1000000L)) : String.format("%.02f", Float.valueOf((float)manaChangeAbs / 1000000.0f)))).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237115_((String)"gtocore.machine.monitor.mana.pool.2").m_130940_(ChatFormatting.BLUE)).m_7532_());
                informationList.addIfAbsent(DisplayRegistry.MANA_REMAINING_TIME.id(), Component.m_237110_((String)"gtceu.multiblock.power_substation.time_to_drain", (Object[])new Object[]{PowerSubstationMachine.getTimeToFillDrainText((BigInteger)BigInteger.valueOf(manaChangeAbs))}).m_7532_());
            }
            informationList.addIfAbsent(DisplayRegistry.EU_STATUS_BAR.id(), new IDisplayComponent(this){

                @Override
                public ResourceLocation getId() {
                    return DisplayRegistry.EU_STATUS_BAR.id();
                }

                @Override
                public IDisplayComponent setInformation(Object ... information) {
                    return this;
                }

                @Override
                public DisplayType getDisplayType() {
                    return DisplayType.CUSTOM_RENDERER;
                }

                @Override
                public int getVisualWidth() {
                    return 16;
                }

                @Override
                public int getVisualHeight() {
                    return 16;
                }
            });
        }
        return informationList;
    }

    @Override
    public List<ResourceLocation> getAvailableRLs() {
        List<ResourceLocation> rls = ITeamInformationProvider.super.getAvailableRLs();
        rls.addAll(List.of(DisplayRegistry.MANA_CURRENT.id(), DisplayRegistry.MANA_CURRENT_AS_POOL.id(), DisplayRegistry.MANA_CHANGE.id(), DisplayRegistry.MANA_CHANGE_AS_POOL.id(), DisplayRegistry.MANA_REMAINING_TIME.id()));
        return rls;
    }
}

