/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.machine.trait.InaccessibleInfiniteTank;
import com.gtolib.api.misc.AsyncTask;
import com.gtolib.api.misc.IAsyncTaskHolder;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DistillationTowerMachine
extends ElectricMultiblockMachine {
    private List<IFluidHandler> fluidOutputs;

    public DistillationTowerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new DistillationTowerLogic((IRecipeLogicMachine)this);
    }

    public Comparator<IMultiPart> getPartSorter() {
        return Comparator.comparingInt(p -> p.self().getPos().m_123342_());
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        int startY = this.getPos().m_123342_() + 1;
        List<IWorkableMultiPart> parts = Arrays.stream(this.getParts()).filter(IWorkableMultiPart.class::isInstance).map(IWorkableMultiPart.class::cast).filter(part -> PartAbility.EXPORT_FLUIDS.isApplicable(part.self().getBlockState().m_60734_())).filter(part -> part.self().getPos().m_123342_() >= startY).toList();
        if (!parts.isEmpty()) {
            int maxY = parts.get(parts.size() - 1).self().getPos().m_123342_();
            this.fluidOutputs = new ArrayList<IFluidHandler>(maxY - startY);
            int outputIndex = 0;
            for (int y = startY; y <= maxY; ++y) {
                if (parts.size() <= outputIndex) {
                    this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
                    continue;
                }
                IWorkableMultiPart part2 = parts.get(outputIndex);
                if (part2.self().getPos().m_123342_() == y) {
                    IFluidHandler handler = ((RecipeHandlerList)part2.getRecipeHandlers().get(0)).getCapability((RecipeCapability)FluidRecipeCapability.CAP).stream().filter(IFluidHandler.class::isInstance).findFirst().map(IFluidHandler.class::cast).orElse((IFluidHandler)VoidFluidHandler.INSTANCE);
                    this.addOutput(handler);
                    ++outputIndex;
                    continue;
                }
                if (part2.self().getPos().m_123342_() > y) {
                    this.fluidOutputs.add((IFluidHandler)VoidFluidHandler.INSTANCE);
                    continue;
                }
                GTCEu.LOGGER.error("The Distillation Tower at {} has a fluid export hatch with an unexpected Y position", (Object)this.getPos());
                this.onStructureInvalid();
                return;
            }
        } else {
            this.onStructureInvalid();
        }
    }

    private void addOutput(IFluidHandler handler) {
        this.fluidOutputs.add(handler);
    }

    public void onStructureInvalid() {
        this.fluidOutputs = null;
        super.onStructureInvalid();
    }

    private List<IFluidHandler> getFluidOutputs() {
        return this.fluidOutputs;
    }

    private static final class DistillationTowerLogic
    extends RecipeLogic
    implements IEnhancedRecipeLogic {
        @Persisted
        private GTRecipe workingRecipe = null;

        private DistillationTowerLogic(IRecipeLogicMachine machine) {
            super(machine);
        }

        public DistillationTowerMachine getMachine() {
            return (DistillationTowerMachine)super.getMachine();
        }

        public GTRecipe getLastRecipe() {
            return this.workingRecipe;
        }

        protected boolean matchRecipe(GTRecipe recipe) {
            return RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)((Recipe)recipe)) && this.matchDTRecipe((Recipe)recipe);
        }

        public void findAndHandleRecipe() {
            this.workingRecipe = null;
            super.findAndHandleRecipe();
        }

        private boolean matchDTRecipe(Recipe recipe) {
            if (!RecipeRunner.matchRecipeInput((IRecipeCapabilityHolder)this.machine, (Recipe)recipe)) {
                return false;
            }
            List items = recipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP);
            if (!items.isEmpty() && !RecipeRunner.handleRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)recipe, (IO)IO.OUT, Map.of(ItemRecipeCapability.CAP, items), Collections.emptyMap(), (boolean)true)) {
                return false;
            }
            return this.applyFluidOutputs((GTRecipe)recipe, IFluidHandler.FluidAction.SIMULATE);
        }

        private void updateWorkingRecipe(GTRecipe recipe) {
            this.workingRecipe = recipe.copy();
            List contents = recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP);
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            ArrayList<Content> trimmed = new ArrayList<Content>(12);
            int size = Math.min(contents.size(), outputs.size());
            for (int i = 0; i < size; ++i) {
                if (outputs.get(i) instanceof VoidFluidHandler) continue;
                trimmed.add((Content)contents.get(i));
            }
            this.workingRecipe.outputs.put(FluidRecipeCapability.CAP, trimmed);
        }

        protected boolean handleRecipeIO(GTRecipe recipe, IO io) {
            if (io != IO.OUT) {
                boolean handleIO = super.handleRecipeIO(recipe, io);
                if (handleIO) {
                    this.updateWorkingRecipe(recipe);
                } else {
                    this.workingRecipe = null;
                }
                return handleIO;
            }
            if (this.getMachine().isDualMEOutput(recipe)) {
                AsyncTask.addAsyncTask((IAsyncTaskHolder)this, () -> this.output((Recipe)recipe));
            } else {
                this.output((Recipe)recipe);
            }
            this.workingRecipe = null;
            return true;
        }

        private void output(Recipe recipe) {
            List items = recipe.getOutputContents((RecipeCapability)ItemRecipeCapability.CAP);
            if (!items.isEmpty()) {
                RecipeRunner.handleRecipe((IRecipeCapabilityHolder)this.machine, (Recipe)recipe, (IO)IO.OUT, Map.of(ItemRecipeCapability.CAP, items), Collections.emptyMap(), (boolean)false);
            }
            this.applyFluidOutputs((GTRecipe)recipe, IFluidHandler.FluidAction.EXECUTE);
        }

        private boolean applyFluidOutputs(GTRecipe recipe, IFluidHandler.FluidAction action) {
            List<FluidIngredient> fluids = recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP).stream().map(Content::getContent).map(arg_0 -> ((FluidRecipeCapability)FluidRecipeCapability.CAP).of(arg_0)).toList();
            if (fluids.isEmpty()) {
                return true;
            }
            boolean valid = true;
            List<IFluidHandler> outputs = this.getMachine().getFluidOutputs();
            int size = Math.min(fluids.size(), outputs.size());
            for (int i = 0; i < size; ++i) {
                int filled;
                IFluidHandler handler = outputs.get(i);
                FluidIngredient ingredient = fluids.get(i);
                FluidStack fluid = ingredient.getStacks()[0];
                if (handler instanceof InaccessibleInfiniteTank) {
                    InaccessibleInfiniteTank tank = (InaccessibleInfiniteTank)handler;
                    if (action.simulate()) continue;
                    tank.fillInternal(fluid, FastFluidIngredient.getAmount((FluidIngredient)ingredient));
                    continue;
                }
                if (handler instanceof NotifiableFluidTank) {
                    NotifiableFluidTank nft = (NotifiableFluidTank)handler;
                    v0 = nft.fillInternal(fluid, action);
                } else {
                    v0 = filled = handler.fill(fluid, action);
                }
                if (filled != fluid.getAmount()) {
                    valid = false;
                }
                if (action.simulate() && !valid) break;
            }
            return valid;
        }
    }
}

