/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.data.Algae;
import com.gtocore.api.gui.helper.LineChartHelper;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.multiblock.part.ae.StorageAccessPartMachine;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.GTOUtils;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class LargeAlgaeFarm
extends ElectricMultiblockMachine
implements ITierCasingMachine {
    private final Map<Algae, LongList> statistics = new EnumMap<Algae, LongList>(Algae.class);
    private static final int statMaxSeconds = 30;
    private boolean statsChanged = false;
    private StorageAccessPartMachine.AlgaeAccessHatch algaeAccessHatch;
    private final TierCasingTrait tierCasingTrait;
    private int lightIntensity = 0;
    private float redWeight = 1.0f;
    private float greenWeight = 1.0f;
    private float blueWeight = 1.0f;
    @DescSynced
    private Algae selectedAlgae = Algae.BlueAlge;

    public LargeAlgaeFarm(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity);
        this.tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"g_b"});
    }

    public void onPartScan(@NotNull IMultiPart iMultiPart) {
        super.onPartScan(iMultiPart);
        if (this.algaeAccessHatch == null && iMultiPart instanceof StorageAccessPartMachine.AlgaeAccessHatch) {
            StorageAccessPartMachine.AlgaeAccessHatch h;
            this.algaeAccessHatch = h = (StorageAccessPartMachine.AlgaeAccessHatch)iMultiPart;
            h.setInfinite(true);
            h.setCheck(true);
        }
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.getOffsetTimer() % 20 == 0) {
                this.produceAlgae();
            }
            return true;
        }
        return false;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }

    public void customText(@NotNull List<Component> list) {
        super.customText(list);
        this.algaeAccessHatch.setObserve(true);
        for (Algae algae : Algae.values()) {
            long amount = this.algaeAccessHatch != null ? this.algaeAccessHatch.getAvailableStacks().get((AEKey)algae.aeKey()) : 0L;
            list.add((Component)Component.m_237119_().m_7220_(algae.getDisplayName()).m_7220_((Component)Component.m_237113_((String)(" x " + FormattingUtil.formatNumbers((long)amount)))));
        }
    }

    private Recipe getRecipe() {
        return this.getRecipeBuilder().duration(200).EUt(GTValues.V[this.tier] / 2L).buildRawRecipe();
    }

    public SoundEntry getSound() {
        return GTSoundEntries.COOLING;
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        if (this.algaeAccessHatch != null) {
            this.algaeAccessHatch.setInfinite(false);
            this.algaeAccessHatch.setCheck(false);
            this.algaeAccessHatch = null;
        }
    }

    public void onUnload() {
        if (this.algaeAccessHatch != null) {
            this.algaeAccessHatch.setCheck(false);
            this.algaeAccessHatch = null;
        }
        super.onUnload();
    }

    private static long getIncreasement(long current, int voltageTier, int tier, double absorption, double weight) {
        if (current <= 0L) {
            return 0L;
        }
        double r = ((double)voltageTier + 1.0) * absorption;
        double capacity = Math.pow(4.0, tier) * weight;
        double x = current;
        double increaseFactor = 0.1 + 0.9 * Math.exp(-r / 2.0);
        double numerator = x * (capacity - x) * (1.0 - increaseFactor);
        double denominator = x + (capacity - x) * increaseFactor;
        double derivative = numerator / denominator;
        return (long)derivative;
    }

    private void produceAlgae() {
        this.updateLightIntensity();
        EnumMap<Algae, Double> algaeRedAbsorptions = new EnumMap<Algae, Double>(Algae.class);
        EnumMap<Algae, Double> algaeGreenAbsorptions = new EnumMap<Algae, Double>(Algae.class);
        EnumMap<Algae, Double> algaeBlueAbsorptions = new EnumMap<Algae, Double>(Algae.class);
        double totalAbsorptionRed = 1.0E-6;
        double totalAbsorptionGreen = 1.0E-6;
        double totalAbsorptionBlue = 1.0E-6;
        if (this.lightIntensity == 0) {
            return;
        }
        for (Algae algae : Algae.values()) {
            algaeRedAbsorptions.put(algae, (double)algae.redAbsorption / 255.0 * (double)this.redWeight);
            totalAbsorptionRed += (double)algae.redAbsorption / 255.0 * (double)this.redWeight;
            algaeGreenAbsorptions.put(algae, (double)algae.greenAbsorption / 255.0 * (double)this.greenWeight);
            totalAbsorptionGreen += (double)algae.greenAbsorption / 255.0 * (double)this.greenWeight;
            algaeBlueAbsorptions.put(algae, (double)algae.blueAbsorption / 255.0 * (double)this.blueWeight);
            totalAbsorptionBlue += (double)algae.blueAbsorption / 255.0 * (double)this.blueWeight;
        }
        for (Algae algae : Algae.values()) {
            double algaeWeight = NumberUtils.max((double)((Double)algaeRedAbsorptions.get((Object)algae) / totalAbsorptionRed), (double)((Double)algaeGreenAbsorptions.get((Object)algae) / totalAbsorptionGreen), (double)((Double)algaeBlueAbsorptions.get((Object)algae) / totalAbsorptionBlue));
            long currentCount = this.algaeAccessHatch.extract((AEKey)algae.aeKey(), Long.MAX_VALUE, Actionable.SIMULATE, IActionSource.ofMachine((IActionHost)this.algaeAccessHatch));
            long increasement = LargeAlgaeFarm.getIncreasement(currentCount, this.tier, this.getCasingTier("g_b"), ((Double)algaeRedAbsorptions.get((Object)algae) + (Double)algaeGreenAbsorptions.get((Object)algae) + (Double)algaeBlueAbsorptions.get((Object)algae)) * (double)this.lightIntensity / 16.0, algaeWeight);
            long total = Math.min(this.getFluidAmount(new Fluid[]{GTMaterials.Biomass.getFluid()})[0], currentCount + increasement);
            this.inputFluid(GTMaterials.Biomass.getFluid(), total);
            if (total - currentCount > 0L) {
                this.algaeAccessHatch.insert((AEKey)algae.aeKey(), total - currentCount, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this.algaeAccessHatch));
            } else {
                this.algaeAccessHatch.extract((AEKey)algae.aeKey(), currentCount - total, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this.algaeAccessHatch));
            }
            this.updateStatistics(algae, total);
        }
    }

    private long[] getRGBIntensity() {
        return this.getItemAmount(new Item[]{(Item)GTOItems.RED_HALIDE_LAMP.get(), (Item)GTOItems.GREEN_HALIDE_LAMP.get(), (Item)GTOItems.BLUE_HALIDE_LAMP.get()});
    }

    private void updateLightIntensity() {
        long[] rgb = this.getRGBIntensity();
        int r = (int)Math.min(16L, rgb[0]);
        int g = (int)Math.min(16L, rgb[1]);
        int b2 = (int)Math.min(16L, rgb[2]);
        int total = r + g + b2;
        this.lightIntensity = Math.min(16, total);
        this.redWeight = (float)r / (float)total;
        this.greenWeight = (float)g / (float)total;
        this.blueWeight = (float)b2 / (float)total;
    }

    @NotNull
    public Widget createUIWidget() {
        WidgetGroup widget2 = (WidgetGroup)super.createUIWidget();
        widget2.getWidgetsByType(DraggableScrollableWidgetGroup.class).stream().findAny().ifPresent(ds -> ds.setSizeHeight(ds.getSizeHeight() - 55));
        widget2.addWidget((Widget)new StatisticWidget(8, 69, 174, 50));
        return widget2;
    }

    private void updateStatistics(Algae algae, long amount) {
        LongList stat = this.statistics.computeIfAbsent(algae, a2 -> new LongArrayList(31));
        stat.add(amount);
        if (stat.size() > 30) {
            stat.removeFirst();
        }
        this.statsChanged = true;
    }

    public boolean hasBatchConfig() {
        return false;
    }

    public boolean hasOverclockConfig() {
        return false;
    }

    public Object2IntMap<String> getCasingTiers() {
        return this.tierCasingTrait.getCasingTiers();
    }

    private class StatisticWidget
    extends WidgetGroup {
        ComponentPanelWidget panelWidget;

        private StatisticWidget(int x, int y, int width, int height) {
            super(x, y, width, height);
            this.panelWidget = new ComponentPanelWidget(3, 3, l -> l.add(Component.m_237115_((String)"config.jade.display_mode").m_130946_(" ").m_7220_((Component)Arrays.stream(Algae.values()).map(algae -> {
                MutableComponent m = (MutableComponent)algae.getDisplayName();
                if (algae == LargeAlgaeFarm.this.selectedAlgae) {
                    m.m_130940_(ChatFormatting.UNDERLINE);
                }
                return ComponentPanelWidget.withButton((Component)m, (String)("select_algae_" + algae.ordinal()));
            }).collect(GTOUtils.joiningComponent((Component)Component.m_237113_((String)" ")))))).clickHandler(this::handleDisplayClick);
            this.addWidget((Widget)this.panelWidget);
        }

        private void handleDisplayClick(String componentData, ClickData clickData) {
            if (componentData.startsWith("select_algae_")) {
                int ordinal = Integer.parseInt(componentData.substring("select_algae_".length()));
                LargeAlgaeFarm.this.selectedAlgae = Algae.values()[ordinal];
            } else {
                LargeAlgaeFarm.this.handleDisplayClick(componentData, clickData);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)this.getPositionX(), (float)this.getPositionY(), 0.0f);
            LineChartHelper.INSTANCE.builder(graphics, (List)LargeAlgaeFarm.this.statistics.getOrDefault((Object)LargeAlgaeFarm.this.selectedAlgae, LongList.of())).width(this.getSizeWidth()).height(this.getSizeHeight()).lineColor(LargeAlgaeFarm.this.selectedAlgae.getColor() | 0xFF000000).draw();
            graphics.m_280168_().m_85849_();
            super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        }

        public void detectAndSendChanges() {
            super.detectAndSendChanges();
            if (LargeAlgaeFarm.this.statsChanged) {
                LargeAlgaeFarm.this.statsChanged = false;
                this.writeUpdateInfo(6, buf -> {
                    buf.writeInt(LargeAlgaeFarm.this.statistics.size());
                    for (Map.Entry<Algae, LongList> entry : LargeAlgaeFarm.this.statistics.entrySet()) {
                        buf.writeInt(entry.getKey().ordinal());
                        LongList stat = entry.getValue();
                        buf.writeInt(stat.size());
                        for (Long v : stat) {
                            buf.writeLong(v.longValue());
                        }
                    }
                });
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
            if (id == 6) {
                LargeAlgaeFarm.this.statistics.clear();
                int mapSize = buffer.readInt();
                for (int i = 0; i < mapSize; ++i) {
                    Algae algae = Algae.values()[buffer.readInt()];
                    int statSize = buffer.readInt();
                    LongArrayList stat = new LongArrayList(statSize);
                    for (int j = 0; j < statSize; ++j) {
                        stat.add(buffer.readLong());
                    }
                    LargeAlgaeFarm.this.statistics.put(algae, (LongList)stat);
                }
                LargeAlgaeFarm.this.statsChanged = true;
            } else {
                super.readUpdateInfo(id, buffer);
            }
        }
    }
}

