/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.api.pattern.GTOPredicates;
import com.gtocore.common.data.GTOBlocks;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.multiblock.IMultiStructureMachine;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@DataGeneratorScanned
public final class PCBFactoryMachine
extends StorageMultiblockMachine
implements IMultiStructureMachine {
    @RegisterLanguage(en="PCB Factory Tier: ", cn="PCB\u5de5\u5382\u7b49\u7ea7\uff1a")
    public static final String TIER = "gtocore.pcb_factory.tier";
    private static final Int2ObjectOpenHashMap<BlockPattern> PATTERNS = new Int2ObjectOpenHashMap(3, 0.9f);
    @Persisted
    @DescSynced
    private int machineTier = 1;

    public PCBFactoryMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, i -> ChemicalHelper.getPrefix((ItemLike)i.m_41720_()) == GTOTagPrefix.NANITES);
    }

    public void onMachineChanged() {
        this.machineTier = 0;
        MaterialStack stack = ChemicalHelper.getMaterialStack((ItemStack)this.getStorageStack());
        if (stack.isEmpty()) {
            return;
        }
        Material material = stack.material();
        if (material == GTMaterials.Gold) {
            this.machineTier = 1;
        } else if (material == GTOMaterials.Orichalcum) {
            this.machineTier = 2;
        } else if (material == GTOMaterials.Enderium) {
            this.machineTier = 3;
        }
        this.updateCheck();
    }

    public static BlockPattern getBlockPattern(int tier, MultiblockMachineDefinition definition) {
        return (BlockPattern)PATTERNS.computeIfAbsent(tier, t -> {
            FactoryBlockPattern builder = FactoryBlockPattern.start((MultiblockMachineDefinition)definition).where(' ', Predicates.any());
            return switch (t) {
                case 2 -> builder.aisle(new String[]{"       AAAAA       ", "        AAA        ", "         A         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"       ABCBA       ", "       AADAA       ", "        AAA        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"     AADBCBDAA     ", "       ADDDA       ", "        AAA        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"    A  BBCBB  A    ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"   A BBBBCBBBB A   ", "        ACA        ", "       AACAA       ", "       AACAA       ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"  A BBBBBBBBBBB A  ", "       HIJIH       ", "      AIIJIIA      ", "      AAACAAA      ", "       AACAA       ", "        ACA        ", "       DACAD       ", "        ACA        ", "        ACA        ", "        A A        ", "       DA AD       ", "        A A        ", "        A A        ", "        A A        ", "       DA AD       ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"  A BBBBBBBBBBB A  ", "      HKKKKKH      ", "     AIKKKKKIA     ", "     AIIIJIIIA     ", "      IIIJIII      ", "      IIIJIII      ", "      DIIJIID      ", "       IIJII       ", "       IICII       ", "       IICII       ", "      DIICIID      ", "       IICII       ", "       IICII       ", "       IICII       ", "      DIICIID      ", "       IICII       ", "       IICII       ", "       IICII       ", "       DACAD       ", "        ACA        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"AADBBBBBBBBBBBBBDAA", " AA  HKDNNNDKH  AA ", "    AIKD   DKIA    ", "    AAIDNNNDIAA    ", "     AID   DIA     ", "      IDNNNDI      ", "     DID   DID     ", "      IDNNNDI      ", "      ID   DI      ", "      IDNNNDI      ", "     DID   DID     ", "      IDNNNDI      ", "      ID   DI      ", "      IDNNNDI      ", "     DID   DID     ", "      IDNNNDI      ", "      ID   DI      ", "      IDNNNDI      ", "      DII IID      ", "       IICII       ", "       IICII       ", "        ICI        ", "        ICI        ", "        ICI        ", "       AACAA       ", "         C         ", "         C         ", "         C         ", "         C         ", "         C         "}).aisle(new String[]{"ABBBBBBBBBBBBBBBBBA", "AAD AIKN   NKIA DAA", " AA AIK     KIA AA ", "    AAIN   NIAA    ", "    AAI     IAA    ", "    AAIN   NIAA    ", "    AAI     IAA    ", "    AAIN   NIAA    ", "    AAI     IAA    ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AAI   IAA     ", "     AAI   IAA     ", "      AI   IA      ", "      AI   IA      ", "      AI   IA      ", "      AI   IA      ", "      AA   AA      ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"ACCCCBBBBBBBBBCCCCA", "ADD CJKN R NKJC DDA", "AAA CJK  R  KJC AAA", "    CCJN R NJCC    ", "     CJ  R  JC     ", "     CJN R NJC     ", "     CJ  R  JC     ", "     CJN R NJC     ", "     CC  R  CC     ", "      CN R NC      ", "      C  R  C      ", "      CN R NC      ", "      C  R  C      ", "      CN R NC      ", "      C  R  C      ", "      CN R NC      ", "      C  R  C      ", "      CN R NC      ", "      C  R  C      ", "      CC R CC      ", "       C   C       ", "       C   C       ", "       C   C       ", "       C   C       ", "       C   C       ", "       C   C       ", "       C   C       ", "       C   C       ", "       C   C       ", "       C   C       "}).aisle(new String[]{"ABBBBBBBBBBBBBBBBBA", "AAD AIKN   NKIA DAA", " AA AIK     KIA AA ", "    AAIN   NIAA    ", "    AAI     IAA    ", "    AAIN   NIAA    ", "    AAI     IAA    ", "    AAIN   NIAA    ", "    AAI     IAA    ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AI     IA     ", "     AIN   NIA     ", "     AAI   IAA     ", "     AAI   IAA     ", "      AI   IA      ", "      AI   IA      ", "      AI   IA      ", "      AI   IA      ", "      AA   AA      ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"AADBBBBBBBBBBBBBDAA", " AA  HKDNNNDKH  AA ", "    AIKD   DKIA    ", "    AAIDNNNDIAA    ", "     AID   DIA     ", "      IDNNNDI      ", "     DID   DID     ", "      IDNNNDI      ", "      ID   DI      ", "      IDNNNDI      ", "     DID   DID     ", "      IDNNNDI      ", "      ID   DI      ", "      IDNNNDI      ", "     DID   DID     ", "      IDNNNDI      ", "      ID   DI      ", "      IDNNNDI      ", "      DII IID      ", "       IICII       ", "       IICII       ", "        ICI        ", "        ICI        ", "        ICI        ", "       AACAA       ", "         C         ", "         C         ", "         C         ", "         C         ", "         C         "}).aisle(new String[]{"  A BBBBBBBBBBB A  ", "      HKKKKKH      ", "     AIKKKKKIA     ", "     AIIIJIIIA     ", "      IIIJIII      ", "      IIIJIII      ", "      DIIJIID      ", "       IIJII       ", "       IICII       ", "       IICII       ", "      DIICIID      ", "       IICII       ", "       IICII       ", "       IICII       ", "      DIICIID      ", "       IICII       ", "       IICII       ", "       IICII       ", "       DACAD       ", "        ACA        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"  A BBBBBBBBBBB A  ", "       HIJIH       ", "      AIIJIIA      ", "      AAACAAA      ", "       AACAA       ", "        ACA        ", "       DACAD       ", "        ACA        ", "        ACA        ", "        A A        ", "       DA AD       ", "        A A        ", "        A A        ", "        A A        ", "       DA AD       ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"   A BBBBCBBBB A   ", "        ACA        ", "       AACAA       ", "       AACAA       ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "        A A        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"    A  BBCBB  A    ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"     AADBCBDAA     ", "       ADDDA       ", "        AAA        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"       ABCBA       ", "       AADAA       ", "        AAA        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"       AAAAA       ", "        AAA        ", "         A         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"       EEEEE       ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "       FFFFF       ", "         F         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"      EEEEEEE      ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "       GGEGG       ", "      FEEEEEF      ", "         F         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"     EEEEEEEEE     ", "      G     G      ", "      G     G      ", "      G     G      ", "      G     G      ", "      G     G      ", "      G F F G      ", "      G  F  G      ", "      G F F G      ", "      G     G      ", "      G     G      ", "      G     G      ", "      G     G      ", "      G     G      ", "     FEEEEEEEF     ", "         F         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"    EEEEEEEEEEE    ", "     G  LLL  G     ", "     G  LLL  G     ", "     G  LLL  G     ", "     G  LLL  G     ", "     G FLLLF G     ", "     G  LLL  G     ", "     G  LLL  G     ", "     G  LLL  G     ", "     G FLLLF G     ", "     G  LLL  G     ", "     G  LLL  G     ", "     G  LLL  G     ", "     G  LLL  G     ", "    FEEEEEEEEEF    ", "        LLL        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"   EEEEEEEEEEEEE   ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G FL   LF G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G FL   LF G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "   FEEEEEEEEEEEF   ", "       LLLLL       ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"   EEEEEEEEEEEEE   ", "    G LO S OL G    ", "    G LP S PL G    ", "    GFLO S OLFG    ", "    G LP S PL G    ", "    G LO S OL G    ", "    G LP S PL G    ", "    G LO S OL G    ", "    G LP S PL G    ", "    G LO S OL G    ", "    G LP S PL G    ", "    GFLO S OLFG    ", "    G LP S PL G    ", "    G LO S OL G    ", "   FEEEEEEEEEEEF   ", "   FFFFLLLLLFFFF   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"   EEEEEEEEEEEEE   ", "    G  L   L  G    ", "    G FL   LF G    ", "    G  L S L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L S L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L   L  G    ", "    G  L S L  G    ", "    G FL   LF G    ", "    G  L   L  G    ", "   FEEEEEEEEEEEF   ", "       LLLLL       ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"   EEEEEEEEEEEEE   ", "    FEELQQQLEEF    ", "    FEELLLLLEEF    ", "    FEELLSLLEEF    ", "    FEELLLLLEEF    ", "    FEELQQQLEEF    ", "    FEELLLLLEEF    ", "    FEELLSLLEEF    ", "    FEELLLLLEEF    ", "    FEELQQQLEEF    ", "    FEELLLLLEEF    ", "    FEELLSLLEEF    ", "    FEELLLLLEEF    ", "    FEELQQQLEEF    ", "    FEEEEEEEEEF    ", "        LLL        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"    EEEEEEEEEEE    ", "     FMHEPEHMF     ", "     FMHEPEHMF     ", "     FMHESEHMF     ", "     FMHEPEHMF     ", "     FMHEPEHMF     ", "     F HEPEH F     ", "     F HESEH F     ", "     F HEPEH F     ", "     F HEPEH F     ", "     F HEPEH F     ", "     F HESEH F     ", "     F HEPEH F     ", "     F HEPEH F     ", "     FEEEEEEEF     ", "         F         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"     EEEEEEEEE     ", "      MPEEEPM      ", "      MPEEEPM      ", "      MPESEPM      ", "      MPEEEPM      ", "      MMEEEMM      ", "        EEE        ", "        ELE        ", "        EEE        ", "        EEE        ", "        EEE        ", "        ELE        ", "        EEE        ", "        EEE        ", "      FEEEEEF      ", "         F         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"     EEEEEEEEE     ", "      MMMSMMM      ", "      MMMSMMM      ", "      MMMSMMM      ", "      MMMMMMM      ", "      MMMMMMM      ", "                   ", "         L         ", "                   ", "                   ", "                   ", "         L         ", "                   ", "                   ", "       FFFFF       ", "         F         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"      EEEEEEE      ", "       HMSMH       ", "       HMSMH       ", "       HMSMH       ", "        MLM        ", "         L         ", "         L         ", "         L         ", "         L         ", "         L         ", "         L         ", "         L         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"       EEEEE       ", "        MMM        ", "        MMM        ", "        MTM        ", "        MMM        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).aisle(new String[]{"        EEE        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.IRIDIUM_CASING.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.HIGH_POWER_CASING.get()})).where('D', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Neutronium)})).where('E', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.BORON_CARBIDE_CERAMIC_RADIATION_RESISTANT_MECHANICAL_CUBE.get()})).where('F', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.MaragingSteel300)})).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TEMPERED_GLASS.get()})).where('H', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.STRONTIUM_CARBONATE_CERAMIC_RAY_ABSORBING_MECHANICAL_CUBE.get()})).where('I', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.GRAVITY_STABILIZATION_CASING.get()})).where('J', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.RADIATION_ABSORBENT_CASING.get()})).where('K', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.ADVANCED_ASSEMBLY_LINE_UNIT.get()})).where('L', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.PRESSURE_CONTAINMENT_CASING.get()})).where('M', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.IRIDIUM_CASING.get()}).or(GTOPredicates.autoLaserAbilities(definition.getRecipeTypes())).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where('N', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.SUPERCONDUCTING_COIL.get()})).where('O', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.MAGTECH_CASING.get()})).where('P', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Europium)})).where('Q', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.PPS_CORROSION_RESISTANT_MECHANICAL_HOUSING.get()})).where('R', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.HOLLOW_CASING.get()})).where('S', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.HERMETIC_CASING_ZPM.get()})).where('T', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).build();
                case 3 -> builder.aisle(new String[]{"               AAAAAAAAAAAAAAAAA               ", "                   A   A   A                   ", "                   A   A   A                   ", "               CCCCCCCCCCCCCCCCC               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AAOOOOOOOOOOOOOOOAA              ", "                DAAAAAAAAAAAAAD                ", "                DEEEEEEEEEEEEED                ", "               CDAAAAAAAAAAAAADC               ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AOOOOOOOOOOOOOOOOOA              ", "               CDPHHPHHPHHPHHPDC               ", "               CDJJJJJJJJJJJJJDC               ", "               CDPHHPHHPHHPHHPDC               ", "               CGGGGGGGGGGGGGGGC               ", "               CGGGGGGGGGGGGGGGC               ", "               CPPPPPPPPPPPPPPPC               ", "               CGGGGGGGGGGGGGGGC               ", "               CGGGGGGGGGGGGGGGC               ", "               C   H   H   H   C               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AOOOOOOOOOOOOOOOOOA              ", "               CKPPPPPPPPPPPPPKC               ", "               CKNNNNNNNNNNNNNKC               ", "               CKPPPPPPPPPPPPPKC               ", "               CIIIIIIIIIIIIIIIC               ", "               CA             AC               ", "      K        A               A        K      ", "      K        A               A        K      ", "      K        A               A        K      ", "      K        CAAAAAAAAAAAAAAAC        K      ", "      K        CCCCCCCCCCCCCCCCC        K      ", "      K                                 K      ", "      K                                 K      ", "      K                                 K      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AOOOOOOOOOOOOOOOOOA              ", "               CKLRRRRRRRRRRRLKC               ", "               CKNGGGGGGGGGGGNKC               ", "               CKLBBBBBBBBBBBLKC               ", "               CA             AC               ", "      K        AA             AA        K      ", "     CMCCCCCCCCA               ACCCCCCCCMC     ", "     CMCEEEEEEEA               AEEEEEEECMC     ", "     CMCCCCCCCCA               ACCCCCCCCMC     ", "     CMC       AAAAPPPPPAAPPPPAA       CMC     ", "     CMC       CEEEEEEEEEEEEEEEC       CMC     ", "     CMC                               CMC     ", "     CMC                               CMC     ", "     CMC                               CMC     ", "      K                                 K      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AOOOOOOOOOOOOOOOOOA              ", "              HCKN           NKCH              ", "              HCKNGGGGGGGGGGGNKCH              ", "              HCKNJJJJJJJJJJJNKCH              ", "      L       HCAN  J  J  J  NACH       L      ", "     KMK      HAAN  J  J  J  NAAH      KMK     ", "    KMMMAAAAAAAA N  J  J  J  N AAAAAAAAMMMK    ", "    KMJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJMK    ", "    KMJMAAAAAAAA               AAAAAAAAMJMK    ", "    KMJMK      APPPPAAAPPPPAAPPA      KMJMK    ", "    KMJMK      CEEEEEEEEEEEEEEEC      KMJMK    ", "    KMJMK                             KMJMK    ", "    KMJMK                             KMJMK    ", "    KMMMK                             KMMMK    ", "     KMK                               KMK     ", "      L                                 L      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AOOOOOOOOOOOOOOOOOA              ", "               CKLRRRRRRRRRRRLKC               ", "               CKNGGGGGGGGGGGNKC               ", "               CKLBBBBBBBBBBBLKC               ", "               CA             AC               ", "      K        AA             AA        K      ", "     CMCCCCCCCCA               ACCCCCCCCMC     ", "     CMCEEEEEEEA               AEEEEEEECMC     ", "     CMCCCCCCCCA               ACCCCCCCCMC     ", "     CMC       AAAAPPPPPAAPPPPAA       CMC     ", "     CMC       CEEEEEEEEEEEEEEEC       CMC     ", "     CMC                               CMC     ", "     AJA                               AJA     ", "     CMC                               CMC     ", "      K                                 K      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AOOOOOOOOOOOOOOOOOA              ", "               CKPPPPPPPPPPPPPKC               ", "               CKNNNNNNNNNNNNNKC               ", "               CKPPPPPPPPPPPPPKC               ", "               CIIIIIIIIIIIIIIIC               ", "               CA             AC               ", "      K        A               A        K      ", "      K        A               A        K      ", "      K        A               A        K      ", "      K        CAAAAAAAAAAAAAAAC        K      ", "      K        CCCCCCCCCCCCCCCCC        K      ", "     CKC                               CKC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AOOOOOOOOOOOOOOOOOA              ", "               CDPHHPHHPHHPHHPDC               ", "               CDJJJJJJJJJJJJJDC               ", "               CDPHHPHHPHHPHHPDC               ", "               CGGGGGGGGGGGGGGGC               ", "               CGGGGGGGGGGGGGGGC               ", "               CPPPPPPPPPPPPPPPC               ", "               CGGGGGGGGGGGGGGGC               ", "               CGGGGGGGGGGGGGGGC               ", "               C   H   H   H   C               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"              AAOOOOOOOOOOOOOOOAA              ", "                DAAAAAAAAAAAAAD                ", "                DEEEEEEEEEEEEED                ", "               CDAAAAAAAAAAAAADC               ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                   H   H   H                   ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"               AAAAAAAAAAAAAAAAA               ", "                   A   A   A                   ", "                   A   A   A                   ", "                CCCCCCCCCCCCCCC                ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                     AAAAA                     ", "                      AAA                      ", "                       A                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                     ACPCA                     ", "                     AAHAA                     ", "                      AAA                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                   AAHCPCHAA                   ", "                     AHHHA                     ", "                      AAA                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"    AAAAA         A  CCPCC  A         AAAAA    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"  AAABBBAAA      A CCCCPCCCC A      AAABBBAAA  ", "    CCCCC             APA             CCCCC    ", "                     AAPAA                     ", "                     AAPAA                     ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "    CCCCC             A A             CCCCC    ", "                                               ", "                                               ", "     CEC                               CEC     ", "     AJA                               AJA     ", "     CEC                               CEC     ", "                                               ", "                                               ", "   AAAAAAA                           AAAAAAA   ", "      A                                 A      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{" AABBBBBBBAA    A CCCCCCCCCCC A    AABBBBBBBAA ", "   CDAAADC           GMOMG           CDAAADC   ", "    DEEED           AMMOMMA           DEEED    ", "    DEEED           AAAPAAA           DEEED    ", "    DEEED            AAPAA            DEEED    ", "    DEEED             APA             DEEED    ", "    DEEED            HAPAH            DEEED    ", "    DEEED             APA             DEEED    ", "   CCAAACC            APA            CCAAACC   ", "    CDDDC             A A             CDDDC    ", "    CDEDC            HA AH            CDEDC    ", "    CDEDC             A A             CDEDC    ", "    CDJDC             A A             CDEDC    ", "    CDEDC             A A             CDEDC    ", "    CDEDC            HA AH            CDEDC    ", "    CDDDC             A A             CDDDC    ", "  A CFFFC A           A A           A CFFFC A  ", "   CCCCCCC            A A            CCCCCCC   ", "      A               A A               A      ", "                      A A                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{" ABBBBBBBBBA    A CCCCCCCCCCC A    ABBBBBBBBBA ", "  CGHHHHHGC         GSSSSSG         CGHHHHHGC  ", "   GHIIIHG         AMSSSSSMA         GHIIIHG   ", "   GH   HG         AMMMOMMMA         GH   HG   ", "   GHIIIHG          MMMOMMM          GHIIIHG   ", "   GH   HG          MMMOMMM          GH   HG   ", "   GHIIIHG          HMMOMMH          GHIIIHG   ", "   GH   HG           MMOMM           GH   HG   ", "  CCBBBBBCC          MMPMM          CCBBBBBCC  ", "   G     G           MMPMM           G     G   ", "   GH J HG          HMMPMMH          GH J HG   ", "   G  J  G           MMPMM           G  J  G   ", "   GJJJJJG           MMPMM           GJJJJJG   ", "   G  J  G           MMPMM           G  J  G   ", "   GH J HG          HMMPMMH          GH J HG   ", "   G     G           MMPMM           G     G   ", " A GBBBBBG A         MMPMM         A GBBBBBG A ", "  CCCCCCCCC          MMPMM          CCCCCCCCC  ", "      A              HAPAH              A      ", "                      APA                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"AABBBBBBBBBAA AAHCCCCCCCCCCCCCHAA AABBBBBBBBBAA", " CDHHIIIHHDC   AA  GSHUUUHSG  AA   CDHHIIIHHDC ", "  DHI   IHD       AMSH   HSMA       DHI   IHD  ", "  DH III HD       AAMHUUUHMAA       DH III HD  ", "  DHI   IHD        AMH   HMA        DHI   IHD  ", "  DH III HD         MHUUUHM         DH III HD  ", "  DHI   IHD        HMH   HMH        DHI   IHD  ", "  DH III HD         MHUUUHM         DH III HD  ", " CCBBBBBBBCC        MH   HM        CCBBBBBBBCC ", "  C H J H C         MHUUUHM         C H J H C  ", "  CHL   LHC        HMH   HMH        CHL   LHC  ", "  C       C         MHUUUHM         C       C  ", "  CJ     JC         MH   HM         CJ     JC  ", "  C       C         MHUUUHM         C       C  ", "  CHL   LHC        HMH   HMH        CHL   LHC  ", "  C H J H C         MHUUUHM         C H J H C  ", " ACBBBBBBBCA        MH   HM        ACBBBBBBBCA ", "  CCHCCCHCC         MHUUUHM         CCHCCCHCC  ", "    H A H           HMM MMH           H A H    ", "    HHHHH            MMPMM            HHHHH    ", "                     MMPMM                     ", "                      MPM                      ", "                      MPM                      ", "                      MPM                      ", "                     AAPAA                     ", "                       P                       ", "                       P                       ", "                       P                       ", "                       P                       ", "                       P                       "}).aisle(new String[]{"ABBBBBBBBBBBA ACCCCCCCCCCCCCCCCCA ABBBBBBBBBBBA", " CAHIILIIHAC  AAH AMSU   USMA HAA  CAHIILIIHAC ", "  EI  I  IE    AA AMS     SMA AA    EI  I  IE  ", "  E IILII E       AAMU   UMAA       E IILII E  ", "  EI  I  IE       AAM     MAA       EI  I  IE  ", "  E IILII E       AAMU   UMAA       E IILII E  ", "  EI  I  IE       AAM     MAA       EI  I  IE  ", "  E IILII E       AAMU   UMAA       E IILII E  ", " CABBBBBBBAC      AAM     MAA      CABBBBBBBAC ", "  D   J   D        AMU   UMA        D   J   D  ", "  D       D        AM     MA        D       D  ", "  D       D        AMU   UMA        D       D  ", "  DJ     JD        AM     MA        DJ     JD  ", "  D       D        AMU   UMA        D       D  ", "  D       D        AM     MA        D       D  ", "  D   J   D        AMU   UMA        D   J   D  ", " AFBBBBBBBFA       AM     MA       AFBBBBBBBFA ", "  CCCCCCCCC        AMU   UMA        CCCCCCCCC  ", "      A            AAM   MAA            A      ", "    H   H          AAM   MAA          H   H    ", "                    AM   MA                    ", "                    AM   MA                    ", "                    AM   MA                    ", "                    AM   MA                    ", "                    AA   AA                    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"ABBBBBBBBBBBA APPPPCCCCCCCCCPPPPA ABBBBBBBBBBBA", " CAHILNLIHAC  AHH POSU N USOP HHA  CAHILNLIHAC ", "  EI INI IE   AAA POS  N  SOP AAA   EI INI IE  ", "  E ILNLI E       PPOU N UOPP       E ILNLI E  ", "  EI INI IE        PO  N  OP        EI INI IE  ", "  E ILNLI E        POU N UOP        E ILNLI E  ", "  EI INI IE        PO  N  OP        EI INI IE  ", "  E ILNLI E        POU N UOP        E ILNLI E  ", " CABBBNBBBAC       PP  N  PP       CABBBNBBBAC ", "  D JJNJJ D         PU N UP         D JJNJJ D  ", "  EJ     JE         P  N  P         EJ     JE  ", "  EJ     JE         PU N UP         EJ     JE  ", "  EJ     JE         P  N  P         EJ     JE  ", "  EJ     JE         PU N UP         EJ     JE  ", "  EJ     JE         P  N  P         EJ     JE  ", "  D JJJJJ D         PU N UP         D JJJJJ D  ", " AFBBBBBBBFA        P  N  P        AFBBBBBBBFA ", " ACCCCCCCCCA        PU N UP        ACCCCCCCCCA ", "  AAAAAAAAA         P  N  P         AAAAAAAAA  ", "    H   H           PP N PP           H   H    ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     ", "                     P   P                     "}).aisle(new String[]{"ABBBBBBBBBBBA ACCCCCCCCCCCCCCCCCA ABBBBBBBBBBBA", " CAHIILIIHAC  AAH AMSU   USMA HAA  CAHIILIIHAC ", "  EI  I  IE    AA AMS     SMA AA    EI  I  IE  ", "  E IILII E       AAMU   UMAA       E IILII E  ", "  EI  I  IE       AAM     MAA       EI  I  IE  ", "  E IILII E       AAMU   UMAA       E IILII E  ", "  EI  I  IE       AAM     MAA       EI  I  IE  ", "  E IILII E       AAMU   UMAA       E IILII E  ", " CABBBBBBBAC      AAM     MAA      CABBBBBBBAC ", "  D   J   D        AMU   UMA        D   J   D  ", "  D       D        AM     MA        D       D  ", "  D       D        AMU   UMA        D       D  ", "  DJ     JD        AM     MA        DJ     JD  ", "  D       D        AMU   UMA        D       D  ", "  D       D        AM     MA        D       D  ", "  D   J   D        AMU   UMA        D   J   D  ", " AFBBBBBBBFA       AM     MA       AFBBBBBBBFA ", "  CCCCCCCCC        AMU   UMA        CCCCCCCCC  ", "      A            AAM   MAA            A      ", "    H   H          AAM   MAA          H   H    ", "                    AM   MA                    ", "                    AM   MA                    ", "                    AM   MA                    ", "                    AM   MA                    ", "                    AA   AA                    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"AABBBBBBBBBAA AAHCCCCCCCCCCCCCHAA AABBBBBBBBBAA", " CDHHIIIHHDC   AA  GSHUUUHSG  AA   CDHHIIIHHDC ", "  DHI   IHD       AMSH   HSMA       DHI   IHD  ", "  DH III HD       AAMHUUUHMAA       DH III HD  ", "  DHI   IHD        AMH   HMA        DHI   IHD  ", "  DH III HD         MHUUUHM         DH III HD  ", "  DHI   IHD        HMH   HMH        DHI   IHD  ", "  DH III HD         MHUUUHM         DH III HD  ", " CCBBBBBBBCC        MH   HM        CCBBBBBBBCC ", "  C H J H C         MHUUUHM         C H J H C  ", "  CHL   LHC        HMH   HMH        CHL   LHC  ", "  C       C         MHUUUHM         C       C  ", "  CJ     JC         MH   HM         CJ     JC  ", "  C       C         MHUUUHM         C       C  ", "  CHL   LHC        HMH   HMH        CHL   LHC  ", "  C H J H C         MHUUUHM         C H J H C  ", " ACBBBBBBBCA        MH   HM        ACBBBBBBBCA ", "  CCHCCCHCC         MHUUUHM         CCHCCCHCC  ", "    H A H           HMM MMH           H A H    ", "    HHHHH            MMPMM            HHHHH    ", "                     MMPMM                     ", "                      MPM                      ", "                      MPM                      ", "                      MPM                      ", "                     AAPAA                     ", "                       P                       ", "                       P                       ", "                       P                       ", "                       P                       ", "                       P                       "}).aisle(new String[]{" ABBBBBBBBBA    A CCCCCCCCCCC A    ABBBBBBBBBA ", "  CGHHHHHGC         GSSSSSG         CGHHHHHGC  ", "   GHIIIHG         AMSSSSSMA         GHIIIHG   ", "   GH   HG         AMMMOMMMA         GH   HG   ", "   GHIIIHG          MMMOMMM          GHIIIHG   ", "   GH   HG          MMMOMMM          GH   HG   ", "   GHIIIHG          HMMOMMH          GHIIIHG   ", "   GH   HG           MMOMM           GH   HG   ", "  CCBBBBBCC          MMPMM          CCBBBBBCC  ", "   G     G           MMPMM           G     G   ", "   GH J HG          HMMPMMH          GH J HG   ", "   G  J  G           MMPMM           G  J  G   ", "   GJJJJJG           MMPMM           GJJJJJG   ", "   G  J  G           MMPMM           G  J  G   ", "   GH J HG          HMMPMMH          GH J HG   ", "   G     G           MMPMM           G     G   ", " A GBBBBBG A         MMPMM         A GBBBBBG A ", "  CCCCCCCCC          MMPMM          CCCCCCCCC  ", "      A              HAPAH              A      ", "                      APA                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{" AABBBBBBBAA    A CCCCCCCCCCC A    AABBBBBBBAA ", "   CDAAADC           GMOMG           CDAAADC   ", "    DEEED           AMMOMMA           DEEED    ", "    DEEED           AAAPAAA           DEEED    ", "    DEEED            AAPAA            DEEED    ", "    DEEED             APA             DEEED    ", "    DEEED            HAPAH            DEEED    ", "    DEEED             APA             DEEED    ", "   CCAAACC            APA            CCAAACC   ", "    CDDDC             A A             CDDDC    ", "    CDEDC            HA AH            CDEDC    ", "    CDEDC             A A             CDEDC    ", "    CDEDC             A A             CDEDC    ", "    CDEDC             A A             CDEDC    ", "    CDEDC            HA AH            CDEDC    ", "    CDDDC             A A             CDDDC    ", "  A CFFFC A           A A           A CFFFC A  ", "   CCCCCCC            A A            CCCCCCC   ", "      A               A A               A      ", "                      A A                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"  AAABBBAAA      A CCCCPCCCC A      AAABBBAAA  ", "    CCCCC             APA             CCCCC    ", "                     AAPAA                     ", "                     AAPAA                     ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "                      A A                      ", "    CCCCC             A A             CCCCC    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "   AAAAAAA                           AAAAAAA   ", "      A                                 A      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"    AAAAA         A  CCPCC  A         AAAAA    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                   AAHCPCHAA                   ", "                     AHHHA                     ", "                      AAA                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                     ACPCA                     ", "                     AAHAA                     ", "                      AAA                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                     AAAAA                     ", "                      AAA                      ", "                       A                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                     DDDDD                     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                     QQQQQ                     ", "                       Q                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                    DDDDDDD                    ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                     EEDEE                     ", "                    QDDDDDQ                    ", "                       Q                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                   DDDDDDDDD                   ", "                    E     E                    ", "                    E     E                    ", "                    E     E                    ", "                    E     E                    ", "                    E     E                    ", "                    E Q Q E                    ", "                    E  Q  E                    ", "                    E Q Q E                    ", "                    E     E                    ", "                    E     E                    ", "                    E     E                    ", "                    E     E                    ", "                    E     E                    ", "                   QDDDDDDDQ                   ", "                       Q                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                  DDDDDDDDDDD                  ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                   E QKKKQ E                   ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                   E QKKKQ E                   ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                   E  KKK  E                   ", "                  QDDDDDDDDDQ                  ", "                      KKK                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                 DDDDDDDDDDDDD                 ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E QK   KQ E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E QK   KQ E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                 QDDDDDDDDDDDQ                 ", "                     KKKKK                     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                 DDDDDDDDDDDDD                 ", "                  E KF X FK E                  ", "                  E KV X VK E                  ", "                  EQKF X FKQE                  ", "                  E KV X VK E                  ", "                  E KF X FK E                  ", "                  E KV X VK E                  ", "                  E KF X FK E                  ", "                  E KV X VK E                  ", "                  E KF X FK E                  ", "                  E KV X VK E                  ", "                  EQKF X FKQE                  ", "                  E KV X VK E                  ", "                  E KF X FK E                  ", "                 QDDDDDDDDDDDQ                 ", "                 QQQQKKKKKQQQQ                 ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                 DDDDDDDDDDDDD                 ", "                  E  K   K  E                  ", "                  E QK   KQ E                  ", "                  E  K X K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K X K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K   K  E                  ", "                  E  K X K  E                  ", "                  E QK   KQ E                  ", "                  E  K   K  E                  ", "                 QDDDDDDDDDDDQ                 ", "                     KKKKK                     ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                 DDDDDDDDDDDDD                 ", "                  QDDKWWWKDDQ                  ", "                  QDDKKKKKDDQ                  ", "                  QDDKKXKKDDQ                  ", "                  QDDKKKKKDDQ                  ", "                  QDDKWWWKDDQ                  ", "                  QDDKKKKKDDQ                  ", "                  QDDKKXKKDDQ                  ", "                  QDDKKKKKDDQ                  ", "                  QDDKWWWKDDQ                  ", "                  QDDKKKKKDDQ                  ", "                  QDDKKXKKDDQ                  ", "                  QDDKKKKKDDQ                  ", "                  QDDKWWWKDDQ                  ", "                  QDDDDDDDDDQ                  ", "                      KKK                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                  DDDDDDDDDDD                  ", "                   QTGDVDGTQ                   ", "                   QTGDVDGTQ                   ", "                   QTGDXDGTQ                   ", "                   QTGDVDGTQ                   ", "                   QTGDVDGTQ                   ", "                   Q GDVDG Q                   ", "                   Q GDXDG Q                   ", "                   Q GDVDG Q                   ", "                   Q GDVDG Q                   ", "                   Q GDVDG Q                   ", "                   Q GDXDG Q                   ", "                   Q GDVDG Q                   ", "                   Q GDVDG Q                   ", "                   QDDDDDDDQ                   ", "                       Q                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                   DDDDDDDDD                   ", "                    TVDDDVT                    ", "                    TVDDDVT                    ", "                    TVDXDVT                    ", "                    TVDDDVT                    ", "                    TTDDDTT                    ", "                      DDD                      ", "                      DKD                      ", "                      DDD                      ", "                      DDD                      ", "                      DDD                      ", "                      DKD                      ", "                      DDD                      ", "                      DDD                      ", "                    QDDDDDQ                    ", "                       Q                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                   DDDDDDDDD                   ", "                    TTTXTTT                    ", "                    TTTXTTT                    ", "                    TTTXTTT                    ", "                    TTTTTTT                    ", "                    TTTTTTT                    ", "                                               ", "                       K                       ", "                                               ", "                                               ", "                                               ", "                       K                       ", "                                               ", "                                               ", "                     QQQQQ                     ", "                       Q                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                    DDDDDDD                    ", "                     GTXTG                     ", "                     GTXTG                     ", "                     GTXTG                     ", "                      TKT                      ", "                       K                       ", "                       K                       ", "                       K                       ", "                       K                       ", "                       K                       ", "                       K                       ", "                       K                       ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                     DDDDD                     ", "                      TTT                      ", "                      TTT                      ", "                      TYT                      ", "                      TTT                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).aisle(new String[]{"                      DDD                      ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.NAQUADAH_ALLOY_CASING.get()})).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.PLASMA_HEATER_CASING.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.IRIDIUM_CASING.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.BORON_CARBIDE_CERAMIC_RADIATION_RESISTANT_MECHANICAL_CUBE.get()})).where('E', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TEMPERED_GLASS.get()})).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.MAGTECH_CASING.get()})).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.STRONTIUM_CARBONATE_CERAMIC_RAY_ABSORBING_MECHANICAL_CUBE.get()})).where('H', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Neutronium)})).where('I', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.MOLECULAR_COIL.get()})).where('J', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.AMPROSIUM_ACTIVE_CASING.get()})).where('K', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.PRESSURE_CONTAINMENT_CASING.get()})).where('L', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.CONTAINMENT_FIELD_GENERATOR.get()})).where('M', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.GRAVITY_STABILIZATION_CASING.get()})).where('N', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.HOLLOW_CASING.get()})).where('O', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.RADIATION_ABSORBENT_CASING.get()})).where('P', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.HIGH_POWER_CASING.get()})).where('Q', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.MaragingSteel300)})).where('R', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.HIGH_ENERGY_ULTRAVIOLET_EMITTER_CASING.get()})).where('S', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.ADVANCED_ASSEMBLY_LINE_UNIT.get()})).where('T', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.IRIDIUM_CASING.get()}).or(GTOPredicates.autoLaserAbilities(definition.getRecipeTypes())).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where('U', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.SUPERCONDUCTING_COIL.get()})).where('V', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Europium)})).where('W', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.PPS_CORROSION_RESISTANT_MECHANICAL_HOUSING.get()})).where('X', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.HERMETIC_CASING_ZPM.get()})).where('Y', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).build();
                default -> builder.aisle(new String[]{"    AAAAA    ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "    BBBBB    ", "      B      "}).aisle(new String[]{"   AAAAAAA   ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "    CCACC    ", "   BAAAAAB   ", "      B      "}).aisle(new String[]{"  AAAAAAAAA  ", "   C     C   ", "   C     C   ", "   C     C   ", "   C     C   ", "   C     C   ", "   C B B C   ", "   C  B  C   ", "   C B B C   ", "   C     C   ", "   C     C   ", "   C     C   ", "   C     C   ", "   C     C   ", "  BAAAAAAAB  ", "      B      "}).aisle(new String[]{" AAAAAAAAAAA ", "  C  DDD  C  ", "  C  DDD  C  ", "  C  DDD  C  ", "  C  DDD  C  ", "  C BDDDB C  ", "  C  DDD  C  ", "  C  DDD  C  ", "  C  DDD  C  ", "  C BDDDB C  ", "  C  DDD  C  ", "  C  DDD  C  ", "  C  DDD  C  ", "  C  DDD  C  ", " BAAAAAAAAAB ", "     DDD     "}).aisle(new String[]{"AAAAAAAAAAAAA", " C  D   D  C ", " C  D   D  C ", " C  D   D  C ", " C BD   DB C ", " C  D   D  C ", " C  D   D  C ", " C  D   D  C ", " C  D   D  C ", " C  D   D  C ", " C BD   DB C ", " C  D   D  C ", " C  D   D  C ", " C  D   D  C ", "BAAAAAAAAAAAB", "    DDDDD    "}).aisle(new String[]{"AAAAAAAAAAAAA", " C DF J FD C ", " C DH J HD C ", " CBDF J FDBC ", " C DH J HD C ", " C DF J FD C ", " C DH J HD C ", " C DF J FD C ", " C DH J HD C ", " C DF J FD C ", " C DH J HD C ", " CBDF J FDBC ", " C DH J HD C ", " C DF J FD C ", "BAAAAAAAAAAAB", "BBBBDDDDDBBBB"}).aisle(new String[]{"AAAAAAAAAAAAA", " C  D   D  C ", " C BD   DB C ", " C  D J D  C ", " C  D   D  C ", " C  D   D  C ", " C  D   D  C ", " C  D J D  C ", " C  D   D  C ", " C  D   D  C ", " C  D   D  C ", " C  D J D  C ", " C BD   DB C ", " C  D   D  C ", "BAAAAAAAAAAAB", "    DDDDD    "}).aisle(new String[]{"AAAAAAAAAAAAA", " BAADIIIDAAB ", " BAADDDDDAAB ", " BAADDJDDAAB ", " BAADDDDDAAB ", " BAADIIIDAAB ", " BAADDDDDAAB ", " BAADDJDDAAB ", " BAADDDDDAAB ", " BAADIIIDAAB ", " BAADDDDDAAB ", " BAADDJDDAAB ", " BAADDDDDAAB ", " BAADIIIDAAB ", " BAAAAAAAAAB ", "     DDD     "}).aisle(new String[]{" AAAAAAAAAAA ", "  BEGAHAGEB  ", "  BEGAHAGEB  ", "  BEGAJAGEB  ", "  BEGAHAGEB  ", "  BEGAHAGEB  ", "  B GAHAG B  ", "  B GAJAG B  ", "  B GAHAG B  ", "  B GAHAG B  ", "  B GAHAG B  ", "  B GAJAG B  ", "  B GAHAG B  ", "  B GAHAG B  ", "  BAAAAAAAB  ", "      B      "}).aisle(new String[]{"  AAAAAAAAA  ", "   EHAAAHE   ", "   EHAAAHE   ", "   EHAJAHE   ", "   EHAAAHE   ", "   EEAAAEE   ", "     AAA     ", "     ADA     ", "     AAA     ", "     AAA     ", "     AAA     ", "     ADA     ", "     AAA     ", "     AAA     ", "   BAAAAAB   ", "      B      "}).aisle(new String[]{"  AAAAAAAAA  ", "   EEEJEEE   ", "   EEEJEEE   ", "   EEEJEEE   ", "   EEEEEEE   ", "   EEEEEEE   ", "             ", "      D      ", "             ", "             ", "             ", "      D      ", "             ", "             ", "    BBBBB    ", "      B      "}).aisle(new String[]{"   AAAAAAA   ", "    GEJEG    ", "    GEJEG    ", "    GEJEG    ", "     EDE     ", "      D      ", "      D      ", "      D      ", "      D      ", "      D      ", "      D      ", "      D      ", "             ", "             ", "             ", "             "}).aisle(new String[]{"    AAAAA    ", "     EEE     ", "     EEE     ", "     EKE     ", "     EEE     ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "}).aisle(new String[]{"     AAA     ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "}).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.BORON_CARBIDE_CERAMIC_RADIATION_RESISTANT_MECHANICAL_CUBE.get()})).where('B', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.MaragingSteel300)})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_TEMPERED_GLASS.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.PRESSURE_CONTAINMENT_CASING.get()})).where('E', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.IRIDIUM_CASING.get()}).or(GTOPredicates.autoLaserAbilities(definition.getRecipeTypes())).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.PARALLEL_HATCH}).setMaxGlobalLimited(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.MAINTENANCE}).setExactLimit(1))).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.MAGTECH_CASING.get()})).where('G', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.STRONTIUM_CARBONATE_CERAMIC_RAY_ABSORBING_MECHANICAL_CUBE.get()})).where('H', Predicates.blocks((Block[])new Block[]{ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Europium)})).where('I', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.PPS_CORROSION_RESISTANT_MECHANICAL_HOUSING.get()})).where('J', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.HERMETIC_CASING_ZPM.get()})).where('K', Predicates.controller((MachineDefinition)definition)).build();
            };
        });
    }

    public BlockPattern getPattern() {
        return PCBFactoryMachine.getBlockPattern(this.machineTier, this.getDefinition());
    }

    public List<BlockPattern> getMultiPattern() {
        return List.of(PCBFactoryMachine.getBlockPattern(1, this.getDefinition()), PCBFactoryMachine.getBlockPattern(2, this.getDefinition()), PCBFactoryMachine.getBlockPattern(3, this.getDefinition()));
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (this.machineTier < 2 ? recipe.getInputEUt() > 30719L : this.machineTier < 3 && recipe.getInputEUt() > 491519L) {
            return null;
        }
        return RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)RecipeModifierFunction.hatchParallel((MetaMachine)this, (Recipe)recipe));
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
    }
}

