/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.fast.fastcollection.OpenCacheHashSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.machine.IMultiFluidRendererMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class PigmentMixer
extends ElectricMultiblockMachine
implements IMultiFluidRendererMachine {
    @DescSynced
    final Set<BlockPos> cachedYellowOffsets = new OpenCacheHashSet();
    @DescSynced
    final Set<BlockPos> cachedCyanOffsets = new OpenCacheHashSet();
    @DescSynced
    final Set<BlockPos> cachedMagentaOffsets = new OpenCacheHashSet();
    @DescSynced
    final Set<BlockPos> cachedBlackOffsets = new OpenCacheHashSet();
    @DescSynced
    final Set<BlockPos> cachedWhiteOffsets = new OpenCacheHashSet();

    public PigmentMixer(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity);
    }

    protected boolean beforeWorking(@NotNull Recipe recipe) {
        this.cachedYellowOffsets.addAll((Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"yellow", (Object)new OpenCacheHashSet()));
        this.cachedCyanOffsets.addAll((Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"cyan", (Object)new OpenCacheHashSet()));
        this.cachedMagentaOffsets.addAll((Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"magenta", (Object)new OpenCacheHashSet()));
        this.cachedBlackOffsets.addAll((Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"black", (Object)new OpenCacheHashSet()));
        this.cachedWhiteOffsets.addAll((Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"white", (Object)new OpenCacheHashSet()));
        return super.beforeWorking(recipe);
    }

    public void afterWorking() {
        super.afterWorking();
        this.invalid();
    }

    private void invalid() {
        this.cachedYellowOffsets.clear();
        this.cachedCyanOffsets.clear();
        this.cachedMagentaOffsets.clear();
        this.cachedBlackOffsets.clear();
        this.cachedWhiteOffsets.clear();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.invalid();
    }

    @Override
    public Multimap<Fluid, BlockPos> getFluidBlockOffsets() {
        Multimap map = Multimaps.newMultimap((Map)new Reference2ObjectOpenHashMap(), OpenCacheHashSet::new);
        map.putAll((Object)Wrapper.Yellow, this.cachedYellowOffsets);
        map.putAll((Object)Wrapper.Cyan, this.cachedCyanOffsets);
        map.putAll((Object)Wrapper.Magenta, this.cachedMagentaOffsets);
        map.putAll((Object)Wrapper.Black, this.cachedBlackOffsets);
        map.putAll((Object)Wrapper.White, this.cachedWhiteOffsets);
        return map;
    }

    private static class Wrapper {
        public static final Fluid Yellow = GTMaterials.DyeYellow.getFluid();
        public static final Fluid Cyan = GTMaterials.DyeCyan.getFluid();
        public static final Fluid Magenta = GTMaterials.DyeMagenta.getFluid();
        public static final Fluid Black = GTMaterials.DyeBlack.getFluid();
        public static final Fluid White = GTMaterials.DyeWhite.getFluid();

        private Wrapper() {
        }
    }
}

