/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.common.data.GTOBlocks;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.multiblock.TierCasingMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.explosion.SphereExplosion;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public final class StellarForgeMachine
extends TierCasingMultiblockMachine
implements IExplosionMachine {
    @RegisterLanguage(cn="\u5185\u90e8\u538b\u529b\uff1a", en="Internal Pressure: ")
    private static final String PRESSURE = "gtocore.machine.stellar_forge.pressure";
    @Persisted
    private int pressure;
    private int consecutiveRecipes;

    public StellarForgeMachine(MetaMachineBlockEntity holder) {
        super(holder, new String[]{"s_c"});
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tier = switch (this.getCasingTier("s_c")) {
            case 3 -> 14;
            case 2 -> 13;
            default -> 12;
        };
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        ++this.consecutiveRecipes;
        if ((recipe = RecipeModifierFunction.laserLossOverclocking((MetaMachine)this, (Recipe)recipe)) != null && this.consecutiveRecipes > 1) {
            recipe.duration = Math.max(recipe.duration / 2, 1);
        }
        return recipe;
    }

    public void regressRecipe(RecipeLogic recipeLogic) {
        recipeLogic.interruptRecipe();
        this.doExplosion(1.0f);
    }

    public void doExplosion(BlockPos pos, float explosionPower) {
        MultiblockControllerMachine machine = this.self();
        Level level = machine.getLevel();
        if (level != null) {
            level.m_7471_(pos, false);
            SphereExplosion.explosion((BlockPos)pos, (Level)level, (int)100, (boolean)true, (boolean)true);
        }
    }

    private static final class Wrapper {
        private static final Map<Item, Integer> BOMB = Map.of(GTOBlocks.NUKE_BOMB.m_5456_(), 1, GTOBlocks.NAQUADRIA_CHARGE.m_5456_(), 4, GTOBlocks.LEPTONIC_CHARGE.m_5456_(), 16, GTOBlocks.QUANTUM_CHROMODYNAMIC_CHARGE.m_5456_(), 64);

        private Wrapper() {
        }
    }
}

