/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.bioengineering;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gtocore.common.data.GTOFluids;
import com.gtolib.api.machine.multiblock.CrossRecipeMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.MachineUtils;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BiologicalExtractionMachine
extends CrossRecipeMultiblockMachine {
    private static final FluidStack CLOUD_SEED_CONCENTRATED = new FluidStack((Fluid)GTOFluids.CLOUD_SEED_CONCENTRATED.getSource(), 1000);
    private static final FluidStack FIRE_WATER = new FluidStack((Fluid)GTOFluids.FIRE_WATER.getSource(), 1000);
    private static final FluidStack VAPOR_OF_LEVITY = new FluidStack((Fluid)GTOFluids.VAPOR_OF_LEVITY.getSource(), 1000);
    private static final Set<Fluid> FLUIDS = Set.of(CLOUD_SEED_CONCENTRATED.getFluid(), FIRE_WATER.getFluid(), VAPOR_OF_LEVITY.getFluid());
    private int redstoneSignalOutput;

    public BiologicalExtractionMachine(MetaMachineBlockEntity holder) {
        super(holder, false, true, MachineUtils::getHatchParallel);
    }

    public boolean isIndependentThread() {
        return false;
    }

    public Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (this.getRecipeLogic().getTotalContinuousRunningTime() < 400L) {
            recipe.outputs.remove(ItemRecipeCapability.CAP);
            recipe.outputs.remove(FluidRecipeCapability.CAP);
            return recipe;
        }
        return super.getRealRecipe(recipe);
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.redstoneSignalOutput > 9) {
                --this.redstoneSignalOutput;
                if (this.redstoneSignalOutput == 9) {
                    this.redstoneSignalOutput = 0;
                    this.updateSignal();
                }
            }
            if (this.getRecipeLogic().getProgress() % 20 == 0) {
                if (this.inputFluid((Fluid)GTOFluids.NUTRIENT_DISTILLATION.getSource(), 1000L)) {
                    this.redstoneSignalOutput = 15;
                    this.updateSignal();
                } else {
                    return false;
                }
            }
            return switch ((int)this.getRecipeLogic().getTotalContinuousRunningTime()) {
                case 100 -> this.input(CLOUD_SEED_CONCENTRATED);
                case 300 -> this.input(FIRE_WATER);
                case 400 -> this.input(VAPOR_OF_LEVITY);
                default -> true;
            };
        }
        return false;
    }

    private boolean input(FluidStack stack) {
        AtomicBoolean success = new AtomicBoolean(false);
        AtomicBoolean failed = new AtomicBoolean(false);
        this.forEachInputFluids((fluidStack, amount) -> {
            Fluid fluid = fluidStack.getFluid();
            if (FLUIDS.contains(fluid)) {
                if (fluid == stack.getFluid()) {
                    if (amount >= (long)stack.getAmount()) {
                        this.inputFluid(new FluidStack[]{stack});
                        success.set(true);
                    }
                } else {
                    failed.set(true);
                    return true;
                }
            }
            return false;
        });
        return success.get() && !failed.get();
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.total_time", (Object[])new Object[]{this.getRecipeLogic().getTotalContinuousRunningTime()}));
        if (!this.isActive()) {
            return;
        }
        if (this.getRecipeLogic().getTotalContinuousRunningTime() < 100L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.need", (Object[])new Object[]{CLOUD_SEED_CONCENTRATED.getDisplayName()}));
        } else if (this.getRecipeLogic().getTotalContinuousRunningTime() < 300L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.need", (Object[])new Object[]{FIRE_WATER.getDisplayName()}));
        } else if (this.getRecipeLogic().getTotalContinuousRunningTime() < 400L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.need", (Object[])new Object[]{VAPOR_OF_LEVITY.getDisplayName()}));
        }
    }

    public int getOutputSignal(@Nullable Direction side) {
        if (side == this.getFrontFacing().m_122424_()) {
            return this.redstoneSignalOutput;
        }
        return 0;
    }

    public boolean canConnectRedstone(@NotNull Direction side) {
        return side == this.getFrontFacing();
    }
}

