/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.gcym;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gtocore.common.machine.multiblock.electric.gcym.GCYMMultiblockMachine;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class LargeMacerationTowerMachine
extends GCYMMultiblockMachine {
    private AABB grindBound = new AABB(BlockPos.f_121853_);
    private final List<IItemHandler> handlers = new ArrayList<IItemHandler>();
    private TickableSubscription hurtSub;

    public LargeMacerationTowerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.updateBounds();
        List items = (List)this.gtolib$getInputFlat().get(ItemRecipeCapability.CAP);
        if (items != null) {
            for (IRecipeHandler holder : items) {
                if (!(holder instanceof IItemHandler)) continue;
                IItemHandler ih = (IItemHandler)holder;
                this.handlers.add(ih);
            }
            this.hurtSub = this.subscribeServerTick(this.hurtSub, this::spinWheels, 20);
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        ITickSubscription.unsubscribe((ISubscription)this.hurtSub);
        this.hurtSub = null;
        this.handlers.clear();
    }

    public void onUnload() {
        super.onUnload();
        ITickSubscription.unsubscribe((ISubscription)this.hurtSub);
        this.hurtSub = null;
        this.handlers.clear();
    }

    private void updateBounds() {
        BlockPos fl = RelativeDirection.offsetPos((BlockPos)this.getPos(), (Direction)this.getFrontFacing(), (Direction)this.getUpwardsFacing(), (boolean)this.isFlipped(), (int)1, (int)2, (int)0);
        BlockPos br = RelativeDirection.offsetPos((BlockPos)this.getPos(), (Direction)this.getFrontFacing(), (Direction)this.getUpwardsFacing(), (boolean)this.isFlipped(), (int)2, (int)-2, (int)-4);
        this.grindBound = new AABB(fl, br);
    }

    private void spinWheels() {
        if (this.isRemote() || this.getLevel() == null || this.recipeLogic.isSuspend()) {
            return;
        }
        ArrayList<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
        for (Entity entity : this.getLevel().m_45933_(null, this.grindBound)) {
            if (entity instanceof ItemEntity) {
                ItemEntity ie = (ItemEntity)entity;
                itemEntities.add(ie);
                continue;
            }
            if (!this.recipeLogic.isWorking()) continue;
            entity.m_6469_(entity.m_269291_().m_269354_(), (float)this.getTier());
        }
        if (this.handlers.isEmpty()) {
            return;
        }
        block1: for (ItemEntity item : itemEntities) {
            if (item.m_213877_()) continue;
            for (IItemHandler holder : this.handlers) {
                item.m_32045_(ItemHandlerHelper.insertItem((IItemHandler)holder, (ItemStack)item.m_32055_(), (boolean)false));
                if (!item.m_32055_().m_41619_()) continue;
                item.m_146870_();
                continue block1;
            }
        }
    }
}

