/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.gcym;

import com.fast.fastcollection.OpenCacheHashSet;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtocore.common.machine.multiblock.electric.gcym.GCYMMultiblockMachine;
import com.gtolib.api.machine.feature.multiblock.IFluidRendererMachine;
import com.gtolib.api.recipe.Recipe;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public final class LargeMixerMachine
extends GCYMMultiblockMachine
implements IFluidRendererMachine {
    @DescSynced
    @RequireRerender
    private final Set<BlockPos> fluidBlockOffsets = new OpenCacheHashSet();
    @DescSynced
    private Fluid cachedFluid;

    public LargeMixerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    protected boolean beforeWorking(@NotNull Recipe recipe) {
        this.cachedFluid = IFluidRendererMachine.getFluid((GTRecipe)recipe);
        return super.beforeWorking(recipe);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.saveOffsets();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.fluidBlockOffsets.clear();
    }

    private void saveOffsets() {
        Direction counterClockWise;
        Direction clockWise;
        Direction up = RelativeDirection.UP.getRelative(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        Direction back = this.getFrontFacing().m_122424_();
        if (up == Direction.UP || up == Direction.DOWN) {
            clockWise = this.getFrontFacing().m_122427_();
            counterClockWise = this.getFrontFacing().m_122428_();
        } else {
            clockWise = Direction.UP;
            counterClockWise = Direction.DOWN;
        }
        BlockPos pos = this.getPos();
        BlockPos center = pos.m_5484_(up, 3);
        for (int i = 0; i < 3; ++i) {
            center = center.m_121945_(back);
            if (i % 2 == 0) {
                this.fluidBlockOffsets.add(center.m_121996_((Vec3i)pos));
            }
            this.fluidBlockOffsets.add(center.m_121945_(clockWise).m_121996_((Vec3i)pos));
            this.fluidBlockOffsets.add(center.m_121945_(counterClockWise).m_121996_((Vec3i)pos));
        }
    }

    public Set<BlockPos> getFluidBlockOffsets() {
        return this.fluidBlockOffsets;
    }

    public Fluid getCachedFluid() {
        return this.cachedFluid;
    }
}

