/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.processing;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CleanroomMachine;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.AbstractSpaceStation;
import com.gtocore.common.machine.multiblock.part.ae.MEWildcardPatternBufferPartMachine;
import com.gtolib.api.gui.ParallelConfigurator;
import com.gtolib.api.machine.feature.multiblock.IParallelMachine;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.machine.trait.CustomParallelTrait;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeType;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ProcessingPlantMachine
extends StorageMultiblockMachine
implements IParallelMachine,
ITierCasingMachine {
    private static final Set<GTRecipeType> RECIPE_TYPES = Set.of(GTRecipeTypes.BENDER_RECIPES, GTRecipeTypes.COMPRESSOR_RECIPES, GTRecipeTypes.FORGE_HAMMER_RECIPES, GTRecipeTypes.CUTTER_RECIPES, GTRecipeTypes.LASER_ENGRAVER_RECIPES, GTRecipeTypes.EXTRUDER_RECIPES, GTRecipeTypes.LATHE_RECIPES, GTRecipeTypes.WIREMILL_RECIPES, GTRecipeTypes.FORMING_PRESS_RECIPES, GTRecipeTypes.DISTILLERY_RECIPES, GTRecipeTypes.POLARIZER_RECIPES, GTORecipeTypes.CLUSTER_RECIPES, GTORecipeTypes.ROLLING_RECIPES, GTRecipeTypes.PACKER_RECIPES, GTORecipeTypes.UNPACKER_RECIPES, GTRecipeTypes.ASSEMBLER_RECIPES, GTRecipeTypes.CIRCUIT_ASSEMBLER_RECIPES, GTRecipeTypes.CENTRIFUGE_RECIPES, GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES, GTRecipeTypes.ELECTROLYZER_RECIPES, GTRecipeTypes.SIFTER_RECIPES, GTRecipeTypes.MACERATOR_RECIPES, GTRecipeTypes.EXTRACTOR_RECIPES, GTORecipeTypes.DEHYDRATOR_RECIPES, GTRecipeTypes.MIXER_RECIPES, GTRecipeTypes.CHEMICAL_BATH_RECIPES, GTRecipeTypes.ORE_WASHER_RECIPES, GTRecipeTypes.CHEMICAL_RECIPES, GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES, GTRecipeTypes.AUTOCLAVE_RECIPES, GTRecipeTypes.ALLOY_SMELTER_RECIPES, GTRecipeTypes.ARC_FURNACE_RECIPES, GTRecipeTypes.CANNER_RECIPES, GTRecipeTypes.BREWING_RECIPES, GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES, GTORecipeTypes.ARC_GENERATOR_RECIPES, GTORecipeTypes.LOOM_RECIPES, GTORecipeTypes.LAMINATOR_RECIPES, GTORecipeTypes.LASER_WELDER_RECIPES);
    @Nullable
    private GTRecipeType[] recipeTypeCache = new GTRecipeType[]{GTRecipeTypes.DUMMY_RECIPES};
    private boolean mismatched;
    @Persisted
    private final CustomParallelTrait customParallelTrait = new CustomParallelTrait((IParallelMachine)this, true, machine -> ((ProcessingPlantMachine)((Object)machine)).getTier() > 0 ? (long)((ProcessingPlantMachine)((Object)machine)).getTier() * (long)(((ProcessingPlantMachine)((Object)machine)).getSubFormedAmount() > 0 ? 4 : 2) : 0L);
    private final TierCasingTrait tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"i_f"});

    public static Component getComponent() {
        MutableComponent c = Component.m_237119_();
        boolean first = true;
        for (GTRecipeType r : RECIPE_TYPES) {
            if (!first) {
                c.m_130946_(", ");
            }
            first = false;
            c.m_7220_((Component)Component.m_237115_((String)("gtceu." + r.registryName.m_135815_())));
        }
        return c;
    }

    public ProcessingPlantMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, ProcessingPlantMachine::filter);
    }

    private static boolean filter(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof MetaMachineItem) {
            MetaMachineItem metaMachineItem = (MetaMachineItem)item;
            MachineDefinition definition = metaMachineItem.getDefinition();
            if (definition instanceof MultiblockMachineDefinition) {
                return false;
            }
            GTRecipeType[] types = definition.getRecipeTypes();
            if (types == null || types.length == 0) {
                return false;
            }
            GTRecipeType recipeType = types[0];
            return RECIPE_TYPES.contains(recipeType);
        }
        return false;
    }

    protected boolean beforeWorking(Recipe recipe) {
        if (this.mismatched || this.isEmpty()) {
            return false;
        }
        return super.beforeWorking(recipe);
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (!this.mismatched && !this.isEmpty()) {
            return RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)recipe, (boolean)false, (double)0.9, (double)0.8, (double)0.5);
        }
        return null;
    }

    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypeCache;
    }

    public RecipeType getRecipeType() {
        return (RecipeType)this.getRecipeTypes()[this.getActiveRecipeType()];
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.update();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.customParallelTrait.onStructureInvalid();
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new ParallelConfigurator((IParallelMachine)this)});
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        MachineUtils.addRecipeTypeText(textList, (IRecipeLogicMachine)this);
        if (this.mismatched) {
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.processing_plant.mismatched").m_130940_(ChatFormatting.RED));
        }
    }

    private void update() {
        this.recipeTypeCache = new GTRecipeType[]{GTRecipeTypes.DUMMY_RECIPES};
        this.mismatched = false;
        Item item = this.machineStorage.storage.getStackInSlot(0).m_41720_();
        if (item instanceof MetaMachineItem) {
            MetaMachineItem metaMachineItem = (MetaMachineItem)item;
            MachineDefinition definition = metaMachineItem.getDefinition();
            if (this.tier != definition.getTier()) {
                this.mismatched = true;
            }
            this.recipeTypeCache = definition.getRecipeTypes();
            MEWildcardPatternBufferPartMachine.onMultiblockRecipeTypeChange((MultiblockControllerMachine)this);
        }
    }

    public void onMachineChanged() {
        this.customParallelTrait.onStructureInvalid();
        if (this.isFormed) {
            if (this.getRecipeLogic().getLastRecipe() != null) {
                this.getRecipeLogic().markLastRecipeDirty();
            }
            this.getRecipeLogic().updateTickSubscription();
            this.update();
        }
    }

    public long getMaxParallel() {
        return this.customParallelTrait.getMaxParallel();
    }

    public long getParallel() {
        return this.customParallelTrait.getParallel();
    }

    public void setParallel(long number) {
        this.customParallelTrait.setParallel(number);
    }

    public void setCleanroom(@Nullable ICleanroomProvider provider) {
        if (provider instanceof CleanroomMachine || provider instanceof AbstractSpaceStation) {
            super.setCleanroom(provider);
        }
    }

    public int getTier() {
        if (!this.isFormed) {
            return 0;
        }
        return Math.min(this.getCasingTier("i_f"), this.tier);
    }

    public Object2IntMap<String> getCasingTiers() {
        return this.tierCasingTrait.getCasingTiers();
    }
}

