/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.client.hud.Configurator;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.item.PlanetDataChipItem;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.data.Dimension;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.RegistriesUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public final class SatelliteControlCenterMachine
extends ElectricMultiblockMachine {
    @RegisterLanguage(en="Selected planet: ", cn="\u5df2\u9009\u62e9\u7684\u661f\u7403\uff1a")
    private static final String PLANET = "gtocore.satellite_control_center.planet";
    @RegisterLanguage(en="The required rocket: ", cn="\u9700\u8981\u7684\u706b\u7bad\uff1a")
    private static final String ROCKET = "gtocore.satellite_control_center.rocket";
    @RegisterLanguage(en="The required fuel: ", cn="\u9700\u8981\u7684\u71c3\u6599\uff1a")
    private static final String FUEL = "gtocore.satellite_control_center.fuel";
    @RegisterLanguage(cn="\u5efa\u9020\u7a7a\u95f4\u7ad9", en="Build Space Station")
    private static final String BUILD_SPACE_STATION = "gtocore.satellite_control_center.emi.space_station";
    @RegisterLanguage(cn="\u5728\u8be5\u661f\u7403\u5efa\u9020\u7a7a\u95f4\u7ad9\u65f6\uff0c", en="When building a space station on this planet,")
    public static final String BUILD_SPACE_STATION_DESC_1 = "gtocore.satellite_control_center.emi.space_station.desc.1";
    @RegisterLanguage(cn="\u9700\u8981\u5c06\u8fd9\u4e9b\u6750\u6599\u5e26\u5165\u592a\u7a7a\u4e2d\u3002", en="you need to bring these materials into space.")
    public static final String BUILD_SPACE_STATION_DESC_2 = "gtocore.satellite_control_center.emi.space_station.desc.2";
    private boolean launch;
    @Persisted
    private int index;

    public SatelliteControlCenterMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void attachConfigurators(@NotNull ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        IFancyConfigurator[] iFancyConfiguratorArray = new IFancyConfigurator[1];
        Configurator c = new Configurator((IGuiTexture)GuiTextures.LIGHT_ON, (IGuiTexture)GuiTextures.LIGHT_OFF);
        iFancyConfiguratorArray[0] = c;
        configuratorPanel.attachConfigurators(iFancyConfiguratorArray);
        if (this.isRemote()) {
            c.setHudInstance("adastra_hud");
        }
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        MutableComponent buttonText = Component.m_237115_((String)PLANET).m_7220_((Component)Component.m_237115_((String)Wrapper.LIST[this.index].getKey()));
        buttonText.m_130946_(" ");
        buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-]"), (String)"sub"));
        buttonText.m_130946_(" ");
        buttonText.m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"add"));
        textList.add((Component)buttonText);
        textList.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{Wrapper.LIST[this.index].getTier()}));
        Item item = SatelliteControlCenterMachine.getRocket(Wrapper.LIST[this.index].getTier());
        if (item != null) {
            textList.add((Component)Component.m_237115_((String)ROCKET).m_7220_(item.m_41466_()));
            textList.add((Component)Component.m_237115_((String)FUEL).m_7220_(SatelliteControlCenterMachine.getFuel(Wrapper.LIST[this.index].getTier()).getDisplayName()));
            textList.add(ComponentPanelWidget.withButton((Component)Component.m_237115_((String)"gtocore.machine.space_elevator.set_out"), (String)"set_out"));
        }
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (clickData.isRemote) {
            return;
        }
        if ("set_out".equals(componentData)) {
            this.launch = true;
            this.getRecipeLogic().updateTickSubscription();
        } else if (!this.isActive()) {
            this.index = Mth.m_14045_((int)(this.index + (componentData.equals("add") ? 1 : -1)), (int)0, (int)(Wrapper.LIST.length - 1));
        }
    }

    @Nullable
    private Recipe getRecipe() {
        if (this.launch && this.getTier() > 2 && this.getOwnerUUID() != null) {
            this.launch = false;
            Item item = SatelliteControlCenterMachine.getRocket(Wrapper.LIST[this.index].getTier());
            if (item == null) {
                return null;
            }
            Recipe recipe = this.getRecipeBuilder().inputItems(GTOItems.PLANET_SCAN_SATELLITE.asStack()).inputFluids(SatelliteControlCenterMachine.getFuel(Wrapper.LIST[this.index].getTier())).inputItems(item).inputItems(GTOItems.PLANET_DATA_CHIP.asStack()).outputItems(item).outputItems(((PlanetDataChipItem)((Object)GTOItems.PLANET_DATA_CHIP.get())).getPlanetDataChip(this.getOwnerUUID(), Wrapper.LIST[this.index].getLocation())).EUt(this.getOverclockVoltage()).duration(6000).buildRawRecipe();
            if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
                return recipe;
            }
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }

    public static Dimension[] getPlanets() {
        return Wrapper.LIST;
    }

    public static Item getRocket(int tier) {
        return Wrapper.ROCKET.get(tier);
    }

    public static FluidStack getFuel(int tier) {
        return Wrapper.FUEL.get(tier);
    }

    private static class Wrapper {
        private static final Map<Integer, Item> ROCKET = GTCEu.isProd() ? Map.of(1, (Item)ModItems.TIER_1_ROCKET.get(), 2, (Item)ModItems.TIER_2_ROCKET.get(), 3, (Item)ModItems.TIER_3_ROCKET.get(), 4, (Item)ModItems.TIER_4_ROCKET.get(), 5, RegistriesUtils.getItem((String)"ad_astra_rocketed:tier_5_rocket"), 6, RegistriesUtils.getItem((String)"ad_astra_rocketed:tier_6_rocket"), 7, RegistriesUtils.getItem((String)"ad_astra_rocketed:tier_7_rocket")) : Map.of(1, (Item)ModItems.TIER_1_ROCKET.get(), 2, (Item)ModItems.TIER_2_ROCKET.get(), 3, (Item)ModItems.TIER_3_ROCKET.get(), 4, (Item)ModItems.TIER_4_ROCKET.get());
        private static final Map<Integer, FluidStack> FUEL = Map.of(1, GTMaterials.RocketFuel.getFluid(16000), 2, GTOMaterials.RocketFuelRp1.getFluid(16000), 3, GTOMaterials.DenseHydrazineFuelMixture.getFluid(16000), 4, GTOMaterials.RocketFuelCn3h7o3.getFluid(16000), 5, GTOMaterials.RocketFuelH8n4c2o4.getFluid(16000), 6, new FluidStack((Fluid)ModFluids.CRYO_FUEL.get(), 16000), 7, GTOMaterials.StellarEnergyRocketFuel.getFluid(16000));
        private static final Dimension[] LIST;

        private Wrapper() {
        }

        static {
            ArrayList list = new ArrayList();
            GTODimensions.forEachPlanet(list::add);
            LIST = list.toArray(new Dimension[0]);
        }
    }
}

