/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gtocore.common.saved.DysonSphereSavaedData;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.api.planets.PlanetApi;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class SpaceProbeSurfaceReceptionMachine
extends ElectricMultiblockMachine {
    private ResourceKey<Level> dimension;
    @Persisted
    private boolean use;

    public SpaceProbeSurfaceReceptionMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private ResourceKey<Level> getDimension() {
        if (this.dimension == null) {
            this.dimension = Objects.requireNonNull(this.getLevel()).m_46472_();
        }
        return this.dimension;
    }

    protected boolean beforeWorking(@NotNull Recipe recipe) {
        if (this.use) {
            DysonSphereSavaedData.setDysonUse(this.getDimension(), true);
        }
        return super.beforeWorking(recipe);
    }

    public void afterWorking() {
        super.afterWorking();
        if (this.use) {
            DysonSphereSavaedData.setDysonUse(this.getDimension(), false);
            this.use = false;
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        if (this.use) {
            DysonSphereSavaedData.setDysonUse(this.getDimension(), false);
            this.use = false;
        }
    }

    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        double number;
        if (!PlanetApi.API.isSpace(this.getLevel())) {
            return null;
        }
        if ((recipe = RecipeModifierFunction.perfectOverclocking((MetaMachine)this, (Recipe)recipe)) == null) {
            return null;
        }
        if (!DysonSphereSavaedData.getDimensionUse(this.getDimension()) && (number = (double)DysonSphereSavaedData.getDimensionData(this.getDimension()).leftInt() / 100.0) > 1.0) {
            this.use = true;
            Content content = (Content)((List)recipe.outputs.get(FluidRecipeCapability.CAP)).get(0);
            recipe.outputs.put(FluidRecipeCapability.CAP, List.of(content.copy((RecipeCapability)FluidRecipeCapability.CAP, ContentModifier.multiplier((double)number))));
            return recipe;
        }
        return recipe;
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            Level level = this.getLevel();
            if (level == null) {
                return false;
            }
            if (this.getOffsetTimer() % 20 == 0) {
                BlockPos pos = MachineUtils.getOffsetPos((int)8, (int)28, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
                for (int i = -4; i < 5; ++i) {
                    for (int j = -4; j < 5; ++j) {
                        if (level.m_45527_(pos.m_7918_(i, 0, j))) continue;
                        return false;
                    }
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.dyson_sphere.number", (Object[])new Object[]{DysonSphereSavaedData.getDimensionData(this.getDimension()).leftInt()}));
    }
}

