/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtocore.common.machine.multiblock.electric.space.MegaSpaceElevatorModuleMachine;
import com.gtocore.common.machine.multiblock.electric.space.SpaceElevatorMachine;
import com.gtolib.utils.MathUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class SuperSpaceElevatorMachine
extends SpaceElevatorMachine {
    @DescSynced
    final List<BlockPos> megaPoss = new ArrayList<BlockPos>();
    @DescSynced
    BlockPos center;
    private int megaModuleCount;

    public SuperSpaceElevatorMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    void initialize() {
        BlockPos center;
        this.poss.clear();
        this.megaPoss.clear();
        BlockPos blockPos = this.getPos();
        this.center = center = blockPos.m_6630_(2).m_5484_(this.getFrontFacing(), -120);
        List<BlockPos> posA = this.getPossCornerA(blockPos);
        ArrayList<BlockPos> posB = new ArrayList<BlockPos>(16);
        ArrayList<BlockPos> posC = new ArrayList<BlockPos>(16);
        ArrayList<BlockPos> posD = new ArrayList<BlockPos>(16);
        for (BlockPos p : posA) {
            posB.add(this.mirrorX(p, center));
            posC.add(this.mirrorZ(p, center));
            posD.add(this.centerSymmetry(p, center));
        }
        this.poss.addAll(posA);
        this.poss.addAll(posB);
        this.poss.addAll(posC);
        this.poss.addAll(posD);
        List<BlockPos> megaPosA = this.getMegaPossCornerA(blockPos);
        ArrayList<BlockPos> megaPosB = new ArrayList<BlockPos>(16);
        ArrayList<BlockPos> megaPosC = new ArrayList<BlockPos>(16);
        ArrayList<BlockPos> megaPosD = new ArrayList<BlockPos>(16);
        BlockPos centerBelow = center.m_6625_(2);
        for (BlockPos p : megaPosA) {
            megaPosB.add(this.mirrorX(p, centerBelow));
            megaPosC.add(this.mirrorZ(p, centerBelow));
            megaPosD.add(this.centerSymmetry(p, centerBelow));
        }
        this.megaPoss.addAll(megaPosA);
        this.megaPoss.addAll(megaPosB);
        this.megaPoss.addAll(megaPosC);
        this.megaPoss.addAll(megaPosD);
        this.requestSync();
    }

    @Override
    protected void update(boolean promptly) {
        super.update(promptly);
        if (promptly || this.getOffsetTimer() % 80 == 0) {
            this.megaModuleCount = 0;
            Level level = this.getLevel();
            if (level == null) {
                return;
            }
            for (BlockPos blockPoss : this.megaPoss) {
                MegaSpaceElevatorModuleMachine moduleMachine;
                MetaMachine metaMachine = SuperSpaceElevatorMachine.getMachine((BlockGetter)level, (BlockPos)blockPoss);
                if (!(metaMachine instanceof MegaSpaceElevatorModuleMachine) || !(moduleMachine = (MegaSpaceElevatorModuleMachine)metaMachine).isFormed()) continue;
                if (moduleMachine.spaceElevatorMachine != this) {
                    moduleMachine.getRecipeLogic().updateTickSubscription();
                }
                moduleMachine.spaceElevatorMachine = this;
                ++this.moduleCount;
                ++this.megaModuleCount;
            }
        }
    }

    @Override
    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.module.base", (Object[])new Object[]{this.moduleCount - this.megaModuleCount}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.module.mega", (Object[])new Object[]{this.megaModuleCount}));
    }

    @NotNull
    private List<BlockPos> getMegaPossCornerA(BlockPos blockPos) {
        ArrayList<BlockPos> posA = new ArrayList<BlockPos>(16);
        Direction back = this.getFrontFacing().m_122424_();
        Direction right = this.getFrontFacing().m_122427_();
        posA.add(blockPos.m_5484_(back, 28).m_5484_(right, 17));
        posA.add(blockPos.m_5484_(back, 28).m_5484_(right, 25));
        posA.add(blockPos.m_5484_(back, 28).m_5484_(right, 33));
        posA.add(blockPos.m_5484_(back, 28).m_5484_(right, 41));
        posA.add(blockPos.m_5484_(back, 45).m_5484_(right, 49));
        posA.add(blockPos.m_5484_(back, 45).m_5484_(right, 57));
        posA.add(blockPos.m_5484_(back, 63).m_5484_(right, 75));
        posA.add(blockPos.m_5484_(back, 71).m_5484_(right, 75));
        posA.add(blockPos.m_5484_(back, 79).m_5484_(right, 92));
        posA.add(blockPos.m_5484_(back, 87).m_5484_(right, 92));
        posA.add(blockPos.m_5484_(back, 95).m_5484_(right, 92));
        posA.add(blockPos.m_5484_(back, 103).m_5484_(right, 92));
        posA.add(blockPos.m_5484_(back, 54).m_5484_(right, 19));
        posA.add(blockPos.m_5484_(back, 58).m_5484_(right, 29));
        posA.add(blockPos.m_5484_(back, 91).m_5484_(right, 62));
        posA.add(blockPos.m_5484_(back, 101).m_5484_(right, 66));
        return posA;
    }

    @NotNull
    private List<BlockPos> getPossCornerA(BlockPos blockPos0) {
        ArrayList<BlockPos> posA = new ArrayList<BlockPos>(16);
        Direction back = this.getFrontFacing().m_122424_();
        Direction right = this.getFrontFacing().m_122427_();
        BlockPos blockPos = blockPos0.m_6630_(2);
        posA.add(blockPos.m_5484_(back, 72).m_5484_(right, 42));
        posA.add(blockPos.m_5484_(back, 65).m_5484_(right, 42));
        posA.add(blockPos.m_5484_(back, 72).m_5484_(right, 40));
        posA.add(blockPos.m_5484_(back, 65).m_5484_(right, 40));
        posA.add(blockPos.m_5484_(back, 72).m_5484_(right, 38));
        posA.add(blockPos.m_5484_(back, 65).m_5484_(right, 38));
        posA.add(blockPos.m_5484_(back, 72).m_5484_(right, 36));
        posA.add(blockPos.m_5484_(back, 65).m_5484_(right, 36));
        posA.add(blockPos.m_5484_(back, 78).m_5484_(right, 48));
        posA.add(blockPos.m_5484_(back, 78).m_5484_(right, 55));
        posA.add(blockPos.m_5484_(back, 80).m_5484_(right, 55));
        posA.add(blockPos.m_5484_(back, 84).m_5484_(right, 55));
        posA.add(blockPos.m_5484_(back, 80).m_5484_(right, 48));
        posA.add(blockPos.m_5484_(back, 82).m_5484_(right, 48));
        posA.add(blockPos.m_5484_(back, 82).m_5484_(right, 55));
        posA.add(blockPos.m_5484_(back, 84).m_5484_(right, 48));
        return posA;
    }

    @Override
    public List<BlockPos> getHighlightPos() {
        List<BlockPos> l = super.getHighlightPos();
        l.addAll(this.megaPoss);
        return l;
    }

    private BlockPos mirrorX(BlockPos pos, BlockPos center) {
        int dx = center.m_123341_() - (pos.m_123341_() - center.m_123341_());
        return new BlockPos(dx, pos.m_123342_(), pos.m_123343_());
    }

    private BlockPos mirrorZ(BlockPos pos, BlockPos center) {
        int dz = center.m_123343_() - (pos.m_123343_() - center.m_123343_());
        return new BlockPos(pos.m_123341_(), pos.m_123342_(), dz);
    }

    private BlockPos centerSymmetry(BlockPos pos, BlockPos center) {
        int sx = 2 * center.m_123341_() - pos.m_123341_();
        int sy = 2 * center.m_123342_() - pos.m_123342_();
        int sz = 2 * center.m_123343_() - pos.m_123343_();
        return new BlockPos(sx, sy, sz);
    }

    private BlockPos rotate90(BlockPos pos, BlockPos center) {
        int dx = pos.m_123341_() - center.m_123341_();
        int dz = pos.m_123343_() - center.m_123343_();
        return new BlockPos(center.m_123341_() - dz, pos.m_123342_(), center.m_123343_() + dx);
    }

    private BlockPos rotate270(BlockPos pos, BlockPos center) {
        int dx = pos.m_123341_() - center.m_123341_();
        int dz = pos.m_123343_() - center.m_123343_();
        return new BlockPos(center.m_123341_() + dz, pos.m_123342_(), center.m_123343_() - dx);
    }

    public int getHighlightMilliseconds() {
        return 45000;
    }

    @Override
    public int getMaxSpoolCount() {
        return 1024;
    }

    @Override
    int getBaseHigh() {
        return this.getLevel() instanceof DummyWorld ? 300 : 80;
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.getRecipeLogic().isWorking()) {
            this.high = (float)(8 * this.getBaseHigh() + 400) + (float)(400 + this.getBaseHigh()) * MathUtil.sin((float)((float)this.getOffsetTimer() / 160.0f));
        }
    }
}

