/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.gregtechceu.gtceu.utils.memoization.MemoizedSupplier;
import com.gtocore.common.data.GTOBlocks;
import com.gtolib.api.machine.feature.IEnhancedRecipeLogicMachine;
import com.gtolib.api.machine.feature.ISpaceWorkspaceMachine;
import com.gtolib.api.machine.feature.IWorkInSpaceMachine;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISpacePredicateMachine
extends ISpaceWorkspaceMachine,
ICleanroomProvider {
    public static final MemoizedSupplier<TraceabilityPredicate> innerBlockPredicate = GTMemoizer.memoize(() -> new BlockPredicate(blockWorldState -> {
        BlockEntity patt0$temp = blockWorldState.getTileEntity();
        if (patt0$temp instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity machineBlockEntity = (MetaMachineBlockEntity)patt0$temp;
            MetaMachine machine = machineBlockEntity.getMetaMachine();
            if (ISpacePredicateMachine.isMachineBanned(machine)) {
                blockWorldState.setError((PatternError)MultiblockState.BANNED_ERROR);
                return false;
            }
            if (machine instanceof IWorkInSpaceMachine) {
                IWorkInSpaceMachine spaceMachine = (IWorkInSpaceMachine)machine;
                ((ObjectOpenHashSet)blockWorldState.getMatchContext().getOrCreate((Object)"spaceMachine", ObjectOpenHashSet::new)).add((Object)spaceMachine);
            }
        }
        ((ObjectOpenHashSet)blockWorldState.getMatchContext().getOrCreate((Object)"space", ObjectOpenHashSet::new)).add((Object)blockWorldState.getPos());
        return true;
    }, null, null));
    public static final MemoizedSupplier<TraceabilityPredicate> photovoltaicPlantSupplyingPredicate = GTMemoizer.memoize(() -> {
        TraceabilityPredicate abilities = Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.EXPORT_FLUIDS}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY})).or(Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SPACECRAFT_SEALING_MECHANICAL_BLOCK.get()}));
        return new BlockPredicate(blockWorldState -> {
            if (abilities.test(blockWorldState)) {
                MetaMachineBlockEntity mbe;
                MetaMachine patt1$temp;
                BlockEntity patt0$temp = blockWorldState.getTileEntity();
                if (patt0$temp instanceof MetaMachineBlockEntity && (patt1$temp = (mbe = (MetaMachineBlockEntity)patt0$temp).getMetaMachine()) instanceof MultiblockPartMachine) {
                    MultiblockPartMachine spaceMachine = (MultiblockPartMachine)patt1$temp;
                    ((ObjectOpenHashSet)blockWorldState.getMatchContext().getOrCreate((Object)"spaceMachinePhotovoltaicSupp", ObjectOpenHashSet::new)).add((Object)spaceMachine.getPos());
                }
                return true;
            }
            return false;
        }, () -> BlockInfo.fromBlock((Block)((Block)GTOBlocks.SPACECRAFT_SEALING_MECHANICAL_BLOCK.get())), ((SimplePredicate)Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.EXPORT_FLUIDS}).common.getFirst()).candidates).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.INPUT_ENERGY})).or(Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SPACECRAFT_SEALING_MECHANICAL_BLOCK.get()}));
    });

    public boolean firstLoad();

    @NotNull
    public MultiblockState getMultiblockState();

    @Nullable
    public Collection<IWorkInSpaceMachine> getSpaceMachines();

    public void setSpaceMachines(@Nullable Collection<IWorkInSpaceMachine> var1);

    default public void onFormed() {
        if (this.getSpaceMachines() != null) {
            this.getSpaceMachines().forEach(receiver -> {
                receiver.setCleanroom(null);
                receiver.setWorkspaceProvider(null);
            });
            this.setSpaceMachines(null);
        }
        this.setSpaceMachines((Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"spaceMachine", Collections.emptyList()));
        this.getSpaceMachines().forEach(receiver -> {
            receiver.setCleanroom((ICleanroomProvider)this);
            receiver.setWorkspaceProvider((ISpaceWorkspaceMachine)this);
            if (receiver instanceof IEnhancedRecipeLogicMachine) {
                IEnhancedRecipeLogicMachine enhanced = (IEnhancedRecipeLogicMachine)receiver;
                enhanced.getRecipeLogic().updateTickSubscription();
            }
        });
    }

    default public void onInvalid() {
        if (this.getSpaceMachines() != null) {
            this.getSpaceMachines().forEach(receiver -> {
                receiver.setCleanroom(null);
                receiver.setWorkspaceProvider(null);
            });
            this.setSpaceMachines(null);
        }
    }

    default public void provideOxygen() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ObjectOpenHashSet positions = new ObjectOpenHashSet((Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"space", Collections.emptyList()));
            this.resetLastDistributedBlocks((Set<BlockPos>)positions);
            OxygenApi.API.setOxygen((Level)level2, (Collection)positions, true);
            TemperatureApi.API.setTemperature((Level)level2, (Collection)positions, (short)22);
            level2.m_5594_(null, this.getPos().m_6630_(3).m_5484_(this.getFrontFacing(), 15), (SoundEvent)ModSoundEvents.OXYGEN_INTAKE.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
        }
    }

    public Direction getFrontFacing();

    public BlockPos getPos();

    public Level getLevel();

    public int getOffsetTimer();

    public void resetLastDistributedBlocks(Set<BlockPos> var1);

    public static boolean isMachineBanned(MetaMachine machine) {
        return machine instanceof ISpaceWorkspaceMachine || machine instanceof ICleanroomProvider;
    }

    public static class BlockPredicate
    extends TraceabilityPredicate {
        BlockPredicate(Predicate<MultiblockState> predicate, Supplier<BlockInfo> blockInfo, @Nullable Supplier<Block[]> candidates) {
            super(predicate, blockInfo, candidates);
        }

        public boolean testOnly() {
            return true;
        }

        public boolean isAny() {
            return false;
        }

        public boolean isAir() {
            return false;
        }
    }
}

