/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IFilterType;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.client.forge.ForgeClientEvent;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.AbstractSpaceStation;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.api.planets.PlanetApi;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSpaceStationMachine
extends AbstractSpaceStation {
    @Nullable
    private Collection<BlockPos> outputDistilledWaterHatches;
    @Nullable
    private List<RecipeHandlerList> outputDistilledWaterHatchesList;
    @Nullable
    private CleanroomType cleanroomType = null;
    @Persisted
    private int waterAmountPerHatch = 8;

    public SimpleSpaceStationMachine(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity);
    }

    public void addHandlerList(RecipeHandlerList handler) {
        if (this.outputDistilledWaterHatches != null && this.outputDistilledWaterHatches.stream().anyMatch(p -> handler.part.self().getPos() == p)) {
            if (this.outputDistilledWaterHatchesList == null) {
                this.outputDistilledWaterHatchesList = new ArrayList<RecipeHandlerList>();
            }
            this.outputDistilledWaterHatchesList.add(handler);
            if (handler.getHandlerIO() == IO.OUT) {
                return;
            }
        }
        super.addHandlerList(handler);
    }

    public void onStructureFormed() {
        this.outputDistilledWaterHatches = (Collection)this.getMultiblockState().getMatchContext().getOrDefault((Object)"spaceMachinePhotovoltaicSupp", Collections.emptyList());
        super.onStructureFormed();
        IFilterType filterType = (IFilterType)this.getMultiblockState().getMatchContext().get((Object)"FilterType");
        this.cleanroomType = filterType != null ? filterType.getCleanroomType() : CleanroomType.CLEANROOM;
        this.onFormed();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.outputDistilledWaterHatches = null;
        this.outputDistilledWaterHatchesList = null;
        this.onInvalid();
    }

    public List<ForgeClientEvent.HighlightNeed> getCustomHighlights() {
        BlockPos corner0 = this.getPos().m_5484_(this.getFrontFacing(), 0).m_6630_(3).m_5484_(this.getFrontFacing().m_122427_(), 3);
        BlockPos corner1 = this.getPos().m_5484_(this.getFrontFacing(), 29).m_6625_(3).m_5484_(this.getFrontFacing().m_122428_(), 3);
        return List.of(new ForgeClientEvent.HighlightNeed(corner0, corner1, ChatFormatting.GRAY.m_126665_()));
    }

    public List<Component> getHighlightText() {
        return List.of(Component.m_237115_((String)"tooltip.ad_astra.oxygen_distribution_area"));
    }

    private Recipe getRecipe() {
        if (!PlanetApi.API.isSpace(this.getLevel())) {
            return null;
        }
        return SimpleSpaceStationMachine.inputFluids(this.getRecipeBuilder().duration(200).EUt((long)GTValues.VA[4])).outputFluids(GTOMaterials.FlocculationWasteSolution.getFluid(30)).buildRawRecipe();
    }

    private static RecipeBuilder inputFluids(RecipeBuilder builder) {
        builder.inputFluids(GTMaterials.DistilledWater, 15);
        builder.inputFluids(GTMaterials.RocketFuel, 10);
        builder.inputFluids(GTMaterials.Air, 100);
        return builder;
    }

    @Override
    public void customText(@NotNull List<Component> list) {
        super.customText(list);
        list.add((Component)Component.m_237110_((String)"gtocore.machine.simple_spacestation.distilled_water", (Object[])new Object[]{this.waterAmountPerHatch}).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [-]"), (String)"Sub")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)" [+]"), (String)"Add")));
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            int delta = (clickData.isCtrlClick ? 64 : 1) * (clickData.isShiftClick ? 8 : 1);
            switch (componentData) {
                case "Add": {
                    this.waterAmountPerHatch += delta;
                    this.waterAmountPerHatch = Math.min(this.waterAmountPerHatch, 1000);
                    break;
                }
                case "Sub": {
                    this.waterAmountPerHatch -= delta;
                    this.waterAmountPerHatch = Math.max(this.waterAmountPerHatch, 0);
                    break;
                }
                default: {
                    super.handleDisplayClick(componentData, clickData);
                }
            }
        }
    }

    public boolean onWorking() {
        int time = this.getOffsetTimer();
        if (time % 20 == 0) {
            if (this.firstLoad() || time % 400 == 0) {
                this.provideOxygen();
            }
            if (this.waterAmountPerHatch > 0 && this.outputDistilledWaterHatchesList != null && !this.outputDistilledWaterHatchesList.isEmpty()) {
                for (final RecipeHandlerList handler : this.outputDistilledWaterHatchesList) {
                    IRecipeCapabilityHolder waterHolder = new IRecipeCapabilityHolder(){

                        @NotNull
                        public Map<IO, List<RecipeHandlerList>> getCapabilitiesProxy() {
                            return Map.of(IO.OUT, Collections.singletonList(handler));
                        }

                        @NotNull
                        public Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> getCapabilitiesFlat() {
                            return Map.of(IO.OUT, handler.handlerMap);
                        }
                    };
                    if (!RecipeRunner.handleContent((IRecipeCapabilityHolder)waterHolder, (IO)IO.OUT, (List)ObjectArrayList.of((Object[])new FastFluidIngredient[]{FastFluidIngredient.of((FluidStack[])new FluidStack[]{GTMaterials.DistilledWater.getFluid(this.waterAmountPerHatch)})}), (RecipeCapability)FluidRecipeCapability.CAP, (boolean)true, (boolean)false) || !this.inputFluid(new FluidStack[]{GTMaterials.DistilledWater.getFluid(this.waterAmountPerHatch)})) continue;
                    MachineUtils.outputFluid((IRecipeCapabilityHolder)waterHolder, (FluidStack[])new FluidStack[]{GTMaterials.DistilledWater.getFluid(this.waterAmountPerHatch)});
                }
            }
        }
        return super.onWorking();
    }

    @NotNull
    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }

    public Set<CleanroomType> getTypes() {
        return this.cleanroomType == null ? Set.of() : Set.of(this.cleanroomType);
    }
}

