/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion.recipe;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gtocore.api.machine.part.ILargeSpaceStationMachine;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.RecipeExtension;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.data.Galaxy;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.holder.ObjectHolder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public class SpaceDroneDock
extends RecipeExtension {
    @RegisterLanguage(cn="\u5f53\u524d\u7a7a\u95f4\u7ad9\u6240\u5728\u661f\u7cfb\uff1a%s", en="Current Space Station Galaxy: %s")
    public static final String CURRENT_GALAXY = "gtocore.machine.space_drone_dock.current_galaxy";
    @RegisterLanguage(cn="\u5f53\u524d\u7a7a\u95f4\u7ad9\u4e0d\u5728\u65f6\u7a7a\u57df\u4e2d\uff01", en="The current space station is not in the spacetime domain!")
    public static final String NOT_IN_SPACETIME_DOMAIN = "gtocore.machine.space_drone_dock.not_in_spacetime_domain";
    @RegisterLanguage(cn="\u65e0\u4eba\u673a\u5185\u6ca1\u6709\u7535\uff0c\u65e0\u6cd5\u51fa\u53d1\uff01", en="The drone has no power and cannot set off!")
    public static final String DRONE_NO_ENERGY = "gtocore.machine.space_drone_dock.drone_no_energy";

    public SpaceDroneDock(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity, ILargeSpaceStationMachine.twoWayPositionFunction(41));
    }

    @Nullable
    public Recipe fullModifyRecipe(@NotNull Recipe recipe) {
        AtomicBoolean hasInput = new AtomicBoolean(false);
        for (RecipeCondition c : recipe.conditions) {
            if (c.check((GTRecipe)recipe, this.getRecipeLogic())) continue;
            RecipeLogic recipeLogic = this.getRecipeLogic();
            if (recipeLogic instanceof IEnhancedRecipeLogic) {
                IEnhancedRecipeLogic enhancedRecipeLogic = (IEnhancedRecipeLogic)recipeLogic;
                enhancedRecipeLogic.gtolib$setIdleReason(c.getTooltips());
            }
            return null;
        }
        ObjectHolder costEU = new ObjectHolder(null);
        ObjectHolder outputHolder = new ObjectHolder(null);
        ObjectHolder inputHolder = new ObjectHolder(null);
        Ingredient chargeable = (Ingredient)((Content)((List)recipe.inputs.get((Object)ItemRecipeCapability.CAP)).getFirst()).content;
        this.fastForEachInputItems((stack, amount) -> {
            if (hasInput.get()) {
                return;
            }
            ItemStack output = stack.m_255036_(1);
            ItemStack input = stack.m_255036_(1);
            IElectricItem patt0$temp = GTCapabilityHelper.getElectricItem((ItemStack)output);
            if (patt0$temp instanceof ElectricItem) {
                BigInteger change;
                ElectricItem electricItem = (ElectricItem)patt0$temp;
                if (chargeable.test(output) && (change = BigInteger.valueOf(electricItem.getCharge())).compareTo(BigInteger.ZERO) > 0) {
                    costEU.value = change;
                    electricItem.setCharge(0L);
                    inputHolder.value = input;
                    outputHolder.value = output;
                    hasInput.set(true);
                }
            }
        });
        if (!hasInput.get() || costEU.value == null || ((BigInteger)costEU.value).compareTo(BigInteger.ZERO) <= 0) {
            ((IEnhancedRecipeLogic)this.getRecipeLogic()).gtolib$setIdleReason((Component)Component.m_237115_((String)DRONE_NO_ENERGY));
            return null;
        }
        ArrayList newInput = new ArrayList((Collection)recipe.inputs.get(ItemRecipeCapability.CAP));
        newInput.removeFirst();
        recipe.inputs.put(ItemRecipeCapability.CAP, newInput);
        long maxParallel = Math.max(1L, ((BigInteger)costEU.value).divide(BigInteger.valueOf(600000L)).longValue());
        double base = 1.632 + ((BigInteger)costEU.value).doubleValue() / 1.0E9;
        base *= base;
        recipe.duration = (int)((double)recipe.duration * (0.1 + 6.384 / base / base));
        recipe = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)maxParallel);
        this.inputItem(new ItemStack[]{(ItemStack)inputHolder.value});
        this.outputItem(new ItemStack[]{(ItemStack)outputHolder.value});
        return recipe;
    }

    @Override
    public void customText(@NotNull List<Component> list) {
        super.customText(list);
        if (this.getLevel() == null) {
            return;
        }
        Galaxy galaxy = GTODimensions.getGalaxy((ResourceLocation)this.getLevel().m_46472_().m_135782_());
        if (galaxy == null) {
            list.add((Component)Component.m_237115_((String)NOT_IN_SPACETIME_DOMAIN));
            return;
        }
        list.add((Component)Component.m_237110_((String)CURRENT_GALAXY, (Object[])new Object[]{Component.m_237115_((String)("gtolib.galaxy.name." + galaxy.name()))}));
    }
}

