/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.voidseries;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.common.data.GTOOres;
import com.gtocore.data.IdleReason;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class StarcoreMinerMachine
extends ElectricMultiblockMachine {
    private Set<Material> materials;

    public StarcoreMinerMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Nullable
    private Recipe getRecipe() {
        RecipeBuilder builder = this.getRecipeBuilder().duration(20).EUt((long)GTValues.VA[14]);
        for (Material material : this.getMaterials()) {
            builder.outputItems(TagPrefix.ore, material, 65536);
        }
        if (builder.output.isEmpty()) {
            this.setIdleReason(IdleReason.NO_ORES);
            return null;
        }
        Recipe recipe = builder.buildRawRecipe();
        if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe) && RecipeRunner.matchRecipeOutput((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    private Set<Material> getMaterials() {
        if (this.materials == null) {
            Reference2IntOpenHashMap<Material> ores = GTOOres.ALL_ORES.get(Objects.requireNonNull(this.getLevel()).m_46472_().m_135782_());
            if (ores == null || ores.isEmpty()) {
                return Set.of();
            }
            this.materials = ores.keySet();
        }
        return this.materials;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }
}

