/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.voidseries;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTOOres;
import com.gtocore.common.item.DimensionDataItem;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.ContentBuilder;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public final class VoidMinerMachine
extends StorageMultiblockMachine {
    private static final Recipe RECIPE = RecipeBuilder.ofRaw().inputFluids(GTMaterials.DrillingFluid, 1000).EUt((long)GTValues.VA[4]).duration(20).buildRawRecipe();
    private ResourceLocation dim;

    public VoidMinerMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, i -> i.m_150930_((Item)GTOItems.DIMENSION_DATA.get()) && i.m_41782_());
    }

    public void onMachineChanged() {
        this.dim = null;
        if (this.isEmpty()) {
            return;
        }
        this.dim = DimensionDataItem.getDimension(this.getStorageStack());
        if (GTOOres.ALL_ORES.containsKey(this.dim)) {
            this.getRecipeLogic().updateTickSubscription();
            return;
        }
        this.dim = null;
    }

    private Recipe getRecipe() {
        if (this.dim == null) {
            return null;
        }
        if (!this.isEmpty() && RecipeRunner.matchRecipeInput((IRecipeCapabilityHolder)this, (Recipe)RECIPE)) {
            Recipe recipe = RECIPE.copy();
            recipe.eut = GTValues.VA[this.getTier()];
            recipe.outputs.put(ItemRecipeCapability.CAP, ContentBuilder.createList().items(this.getItems()).buildList());
            return ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)64L);
        }
        return null;
    }

    private ItemStack[] getItems() {
        ItemStack[] stacks = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            stacks[i] = new ItemStack((ItemLike)ChemicalHelper.getItem((TagPrefix)TagPrefix.rawOre, (Material)GTOOres.selectMaterial(this.dim)), (int)Math.pow(this.getTier() - 3, GTValues.RNG.m_188500_() + 1.0));
        }
        return stacks;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.onMachineChanged();
    }

    public void addDisplayText(@NotNull List<Component> textList) {
        super.addDisplayText(textList);
        if (this.dim != null && this.isFormed() && !this.getStorageStack().m_41619_()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.ore_rig.drilled_ores_list"));
            GTOOres.ALL_ORES.get(this.dim).forEach((mat, i) -> textList.add((Component)mat.getLocalizedName().m_130946_("x" + i)));
        }
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }
}

