/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.voidseries;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.EnergyContainerTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.ServerUtils;
import com.gtolib.utils.register.BlockRegisterUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class VoidTransporterMachine
extends ElectricMultiblockMachine {
    private final int id;
    private final int eu;
    @Persisted
    private final EnergyContainerTrait energyContainer;
    @Persisted
    private boolean setup = false;
    private final BiConsumer<VoidTransporterMachine, Player> consumer;

    public static boolean checkTransporter(BlockPos pos, Level level, int id) {
        VoidTransporterMachine machine;
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, (BlockPos)pos.m_7918_(0, -1, 0));
        return !(metaMachine instanceof VoidTransporterMachine) || !(machine = (VoidTransporterMachine)metaMachine).isFormed() || machine.id != id || !machine.check();
    }

    public static Function<MetaMachineBlockEntity, VoidTransporterMachine> create(int id, int eu, @Nullable BiConsumer<VoidTransporterMachine, Player> consumer) {
        return holder -> new VoidTransporterMachine((MetaMachineBlockEntity)holder, id, eu, consumer);
    }

    public static Function<MetaMachineBlockEntity, VoidTransporterMachine> create(int id, int eu) {
        return VoidTransporterMachine.create(id, eu, null);
    }

    public static BiConsumer<VoidTransporterMachine, Player> teleportToDimension(ResourceLocation dim, BlockPos pos) {
        return (m, player) -> {
            Level level = m.getLevel();
            if (level == null) {
                return;
            }
            MinecraftServer server = level.m_7654_();
            if (server == null) {
                return;
            }
            ServerLevel serverLevel = server.m_129880_(GTODimensions.getDimensionKey((ResourceLocation)dim));
            if (serverLevel == null) {
                return;
            }
            CompoundTag data = player.getPersistentData();
            data.m_128347_("pos_x_" + m.id, player.m_20185_());
            data.m_128347_("pos_y_" + m.id, player.m_20186_());
            data.m_128347_("pos_z_" + m.id, player.m_20189_());
            data.m_128359_("dim_" + m.id, level.m_46472_().m_135782_().toString());
            serverLevel.m_46597_(pos.m_7918_(0, -1, 0), ((Block)BlockRegisterUtils.REACTOR_CORE.get()).m_49966_());
            if (!m.setup) {
                m.setup = true;
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 0; y <= 2; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            GTOUtils.fastRemoveBlock((Level)serverLevel, (BlockPos)pos.m_7918_(x, y, z), (boolean)true, (boolean)false);
                        }
                    }
                }
                for (int x : new int[]{-1, 0, 1}) {
                    for (int z : new int[]{-1, 0, 1}) {
                        serverLevel.m_46597_(pos.m_7918_(x, 3, z), Blocks.f_50058_.m_49966_());
                        if (x != 0 || z != 0) {
                            serverLevel.m_46597_(pos.m_7918_(x, -1, z), Blocks.f_50058_.m_49966_());
                        }
                        for (int y = 0; y <= 2; ++y) {
                            if (x == 0 && z == 0) continue;
                            serverLevel.m_46597_(pos.m_7918_(x, y, z), Blocks.f_50185_.m_49966_());
                        }
                    }
                }
            }
            ServerUtils.teleportToDimension((ServerLevel)serverLevel, (Entity)player, (Vec3)pos.m_252807_());
        };
    }

    private VoidTransporterMachine(MetaMachineBlockEntity holder, int id, int eu, @Nullable BiConsumer<VoidTransporterMachine, Player> consumer) {
        super(holder);
        this.id = id;
        this.eu = eu;
        this.consumer = consumer;
        this.energyContainer = this.createEnergyContainer();
        this.toldNotFormed = true;
    }

    private EnergyContainerTrait createEnergyContainer() {
        EnergyContainerTrait container = this.eu == 0 ? new EnergyContainerTrait((MetaMachine)this, 0L) : new EnergyContainerTrait((MetaMachine)this, 409600L);
        container.setCapabilityValidator(Objects::isNull);
        return container;
    }

    private boolean check() {
        this.getRecipeLogic().updateTickSubscription();
        return this.energyContainer.getEnergyStored() >= 409600L && this.energyContainer.removeEnergy(409600L) == 409600L;
    }

    public boolean onWorking() {
        if (super.onWorking()) {
            if (this.energyContainer.getEnergyStored() >= 409600L) {
                return false;
            }
            this.energyContainer.addEnergy(this.getOverclockVoltage());
            return true;
        }
        return false;
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.energyContainer.setEnergyStored(0L);
    }

    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isFormed()) {
            this.setWaitingTime(0);
        }
        if (this.consumer != null && this.isFormed() && (this.eu == 0 || this.check())) {
            this.consumer.accept(this, player);
        }
        return false;
    }

    @Nullable
    private Recipe getRecipe() {
        Recipe recipe;
        if ((long)this.eu < this.getOverclockVoltage() && this.energyContainer.getEnergyStored() < 409600L && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)(recipe = this.getRecipeBuilder().EUt(this.getOverclockVoltage()).duration(200).buildRawRecipe()))) {
            return recipe;
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }
}

