/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.client.forge.ForgeClientEvent;
import com.gtocore.common.machine.multiblock.part.InfiniteIntakeHatchPartMachine;
import com.gtolib.api.machine.feature.multiblock.ICustomHighlightMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ChemicalEnergyDevourerMachine
extends ElectricMultiblockMachine
implements ICustomHighlightMachine {
    private static final FluidStack DINITROGEN_TETROXIDE_STACK = GTMaterials.DinitrogenTetroxide.getFluid(480);
    private static final FluidStack LIQUID_OXYGEN_STACK = GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 320);
    private static final FluidStack LUBRICANT_STACK = GTMaterials.Lubricant.getFluid(10);
    private static final int tier = 5;
    private boolean isOxygenBoosted;
    private boolean isDinitrogenTetroxideBoosted;
    @Persisted
    private final NotifiableFluidTank tank;
    private final ConditionalSubscriptionHandler tankSubs;
    @DescSynced
    private BlockPos highlightStartPos = BlockPos.f_121853_;
    @DescSynced
    private BlockPos highlightEndPos = BlockPos.f_121853_;

    public ChemicalEnergyDevourerMachine(MetaMachineBlockEntity holder) {
        super(holder);
        this.tank = new NotifiableFluidTank((MetaMachine)this, 1, 512000, IO.IN, IO.NONE);
        this.tankSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::intake, 20, () -> this.isFormed && !this.isIntakesObstructed());
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    private void intake() {
        Fluid fluid = InfiniteIntakeHatchPartMachine.AIR_MAP.get(this.getLevel().m_46472_().m_135782_());
        if (fluid == null) {
            this.tankSubs.unsubscribe();
            return;
        }
        this.tank.fillInternal(new FluidStack(fluid, 64000), IFluidHandler.FluidAction.EXECUTE);
        this.tankSubs.updateSubscription();
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.tankSubs.updateSubscription();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tankSubs.initialize(this.getLevel());
    }

    private boolean isIntakesObstructed() {
        if (this.getLevel() == null) {
            return false;
        }
        Direction facing = this.getFrontFacing();
        boolean permuteXZ = facing.m_122434_() == Direction.Axis.Z;
        int directionStep = facing.m_122421_().m_122540_();
        int x = this.isFlipped() ? 22 : -22;
        x *= directionStep;
        for (int z = -11; z < 0; ++z) {
            for (int y = 0; y < 9; ++y) {
                if (this.getLevel().m_8055_(this.getPos().m_121945_(facing).m_7918_(permuteXZ ? x : z * directionStep, y, permuteXZ ? z * directionStep : x)).m_60795_()) continue;
                return true;
            }
        }
        this.highlightStartPos = this.getPos().m_121945_(facing).m_7918_(permuteXZ ? x : -11 * directionStep, 0, permuteXZ ? -11 * directionStep : x);
        this.highlightEndPos = this.getPos().m_121945_(facing).m_7918_(permuteXZ ? x : -directionStep, 8, permuteXZ ? -directionStep : x);
        return false;
    }

    private boolean isBoostAllowed() {
        return this.getMaxVoltage() >= GTValues.V[8];
    }

    public long getOverclockVoltage() {
        if (this.isOxygenBoosted && this.isDinitrogenTetroxideBoosted) {
            return GTValues.V[5] << 6;
        }
        if (this.isOxygenBoosted) {
            return GTValues.V[5] << 5;
        }
        return GTValues.V[5] << 4;
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        long EUt = recipe.getOutputEUt();
        if (EUt > 0L && this.notConsumableFluid(new FluidStack[]{LUBRICANT_STACK}) && !this.isIntakesObstructed()) {
            if ((recipe = ParallelLogic.accurateContentParallel((MetaMachine)this, (Recipe)recipe, (long)(this.getOverclockVoltage() / EUt))) == null) {
                return null;
            }
            if (this.isOxygenBoosted && this.isDinitrogenTetroxideBoosted) {
                recipe.setOutputEUt(EUt * recipe.parallels * 4L);
            } else if (this.isOxygenBoosted) {
                recipe.setOutputEUt(EUt * recipe.parallels * 2L);
            }
            return recipe;
        }
        this.requestSync();
        return null;
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        long totalContinuousRunningTime = this.recipeLogic.getTotalContinuousRunningTime();
        if (!(totalContinuousRunningTime != 1L && totalContinuousRunningTime % 72L != 0L || this.inputFluid(new FluidStack[]{LUBRICANT_STACK}))) {
            return false;
        }
        if ((totalContinuousRunningTime == 1L || totalContinuousRunningTime % 20L == 0L) && this.isBoostAllowed()) {
            this.isOxygenBoosted = this.inputFluid(new FluidStack[]{LIQUID_OXYGEN_STACK});
            this.isDinitrogenTetroxideBoosted = this.inputFluid(new FluidStack[]{DINITROGEN_TETROXIDE_STACK});
        }
        return true;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.isBoostAllowed()) {
            if (this.isOxygenBoosted && this.isDinitrogenTetroxideBoosted) {
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.large_combustion_engine.Joint_boosted"));
            } else if (this.isOxygenBoosted) {
                textList.add((Component)Component.m_237115_((String)"gtocore.machine.large_combustion_engine.supply_dinitrogen_tetroxide_to_boost"));
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.liquid_oxygen_boosted"));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.supply_liquid_oxygen_to_boost"));
            }
        } else {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.boost_disallowed"));
        }
    }

    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        super.attachTooltips(tooltipsPanel);
        tooltipsPanel.attachTooltips(new IFancyTooltip[]{new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.obstructed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))), this::isIntakesObstructed, () -> null)});
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        this.attachHighlightConfigurators(configuratorPanel);
    }

    public int getTier() {
        return 5;
    }

    public List<Component> getHighlightText() {
        return List.of(Component.m_237115_((String)"gtocore.machine.highlight_obstruction"));
    }

    public List<ForgeClientEvent.HighlightNeed> getCustomHighlights() {
        return List.of(new ForgeClientEvent.HighlightNeed(this.highlightStartPos, this.highlightEndPos, ChatFormatting.GOLD.m_126665_()));
    }

    public int getHighlightMilliseconds() {
        return 20000;
    }
}

