/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.machine.multiblock.part.InfiniteIntakeHatchPartMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class CombustionEngineMachine
extends ElectricMultiblockMachine {
    private static final FluidStack OXYGEN_STACK = GTMaterials.Oxygen.getFluid(20);
    private static final FluidStack LIQUID_OXYGEN_STACK = GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 80);
    private static final FluidStack LUBRICANT_STACK = GTMaterials.Lubricant.getFluid(1);
    private final int tier;
    private boolean isOxygenBoosted;
    @Persisted
    private final NotifiableFluidTank tank;
    private final ConditionalSubscriptionHandler tankSubs;

    public CombustionEngineMachine(MetaMachineBlockEntity holder, int tier) {
        super(holder);
        this.tier = tier;
        this.tank = new NotifiableFluidTank((MetaMachine)this, 1, 128000, IO.IN, IO.NONE);
        this.tankSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::intake, 20, () -> this.isFormed && !this.isIntakesObstructed());
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return null;
    }

    private void intake() {
        Fluid fluid = InfiniteIntakeHatchPartMachine.AIR_MAP.get(this.getLevel().m_46472_().m_135782_());
        if (fluid == null) {
            this.tankSubs.unsubscribe();
            return;
        }
        this.tank.fillInternal(new FluidStack(fluid, this.formedAmount * 8000 + 8000), IFluidHandler.FluidAction.EXECUTE);
        this.tankSubs.updateSubscription();
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.tankSubs.updateSubscription();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tankSubs.initialize(this.getLevel());
    }

    private boolean isIntakesObstructed() {
        if (this.getLevel() == null) {
            return false;
        }
        Direction facing = this.getFrontFacing();
        boolean permuteXZ = facing.m_122434_() == Direction.Axis.Z;
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                if (x == 0 && y == 0 || this.getLevel().m_8055_(this.getPos().m_121945_(facing).m_7918_(permuteXZ ? x : 0, y, permuteXZ ? 0 : x)).m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExtreme() {
        return this.tier > 4;
    }

    private boolean isBoostAllowed() {
        return this.getMaxVoltage() >= GTValues.V[this.tier + 1];
    }

    public long getOverclockVoltage() {
        if (this.isOxygenBoosted) {
            return GTValues.V[this.tier] << 2 + this.formedAmount;
        }
        return GTValues.V[this.tier] << 1 + this.formedAmount;
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        long EUt = recipe.getOutputEUt();
        if (EUt > 0L && this.notConsumableFluid(new FluidStack[]{LUBRICANT_STACK}) && !this.isIntakesObstructed()) {
            if ((recipe = ParallelLogic.accurateContentParallel((MetaMachine)this, (Recipe)recipe, (long)(this.getOverclockVoltage() / EUt))) == null) {
                return null;
            }
            if (this.isOxygenBoosted) {
                recipe.setOutputEUt((long)((double)recipe.getOutputEUt() * (this.isExtreme() ? 2.0 : 1.5)));
            }
            return recipe;
        }
        return null;
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        long totalContinuousRunningTime = this.recipeLogic.getTotalContinuousRunningTime();
        if (!(totalContinuousRunningTime != 1L && totalContinuousRunningTime % 72L != 0L || this.inputFluid(new FluidStack[]{LUBRICANT_STACK}))) {
            return false;
        }
        if ((totalContinuousRunningTime == 1L || totalContinuousRunningTime % 20L == 0L) && this.isBoostAllowed()) {
            this.isOxygenBoosted = this.inputFluid(new FluidStack[]{this.isExtreme() ? LIQUID_OXYGEN_STACK : OXYGEN_STACK});
        }
        return true;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        if (this.isBoostAllowed()) {
            if (!this.isExtreme()) {
                if (this.isOxygenBoosted) {
                    textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.oxygen_boosted"));
                } else {
                    textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.supply_oxygen_to_boost"));
                }
            } else if (this.isOxygenBoosted) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.liquid_oxygen_boosted"));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.supply_liquid_oxygen_to_boost"));
            }
        } else {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.boost_disallowed"));
        }
    }

    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        super.attachTooltips(tooltipsPanel);
        tooltipsPanel.attachTooltips(new IFancyTooltip[]{new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.obstructed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))), this::isIntakesObstructed, () -> null)});
    }

    public int getTier() {
        return this.tier;
    }
}

