/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.generator;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOFluidStorageKey;
import com.gtocore.common.data.GTOMaterials;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Scanned
public class FullCellGenerator
extends ElectricMultiblockMachine {
    @RegisterLanguage(cn="\u71c3\u6599\u6548\u7387\u4e58\u6570\uff1a%s", en="Fuel Efficiency Multiplier: %s")
    private static final String FUEL_EFFICIENCY = "gtocore.machine.fuelcell_efficiency";
    @DescSynced
    private boolean isGenerator = false;
    @Persisted
    private double bonusEfficiency = 1.0;
    private static final int MaxCanReleaseParallel = 50;
    @DynamicInitialValue(key="fuelcell.chance_consume", easyValue="0.0d", normalValue="0.017d", expertValue="0.027d", typeKey="probability", cn="\u653e\u7535\u65f6\u819c\u635f\u574f\u6982\u7387", cnComment="\u653e\u7535\u65f6\u4f7f\u7528\u7684\u819c\u6750\u6599\u7684\u635f\u574f\u6982\u7387\u3002\n", en="Fuel Cell Membrane Damage Chance on Discharge", enComment="The chance of the membrane material used being damaged upon discharging.\n")
    public static double chanceConsumeMembraneOnDischarge = 0.017;

    public FullCellGenerator(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onLoad() {
        super.onLoad();
        this.updateGeneratorState();
    }

    private void updateGeneratorState() {
        this.isGenerator = this.getRecipeTypes()[this.getActiveRecipeType()] == GTORecipeTypes.FUEL_CELL_ENERGY_RELEASE_RECIPES;
        this.requestSync();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.bonusEfficiency = 1.0;
    }

    public boolean isGenerator() {
        return this.isGenerator;
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        GTRecipeType activeType = this.getRecipeTypes()[this.getActiveRecipeType()];
        if (activeType == GTORecipeTypes.FUEL_CELL_ENERGY_RELEASE_RECIPES) {
            return this.getReleaseRecipe(recipe);
        }
        if (activeType == GTORecipeTypes.FUEL_CELL_ENERGY_ABSORPTION_RECIPES) {
            return this.getAbsorptionRecipe(recipe);
        }
        if (activeType == GTORecipeTypes.FUEL_CELL_ENERGY_TRANSFER_RECIPES) {
            return this.getElectrolyteTransferRecipe(recipe);
        }
        return null;
    }

    public long getOverclockVoltage() {
        return super.getOverclockVoltage();
    }

    private Recipe getAbsorptionRecipe(Recipe recipe) {
        int membraneTier;
        long fuelEnergyPerUnit = recipe.data.m_128454_("convertedEnergy");
        for (membraneTier = Wrapper.MEMBRANE_MATS.size() - 1; membraneTier >= 0 && !MachineUtils.notConsumableItem((IRecipeCapabilityHolder)this, (ItemStack[])new ItemStack[]{ChemicalHelper.get((TagPrefix)GTOTagPrefix.MEMBRANE_ELECTRODE, (Material)((Material)Wrapper.MEMBRANE_MATS.get(membraneTier)))}); --membraneTier) {
        }
        if (membraneTier < 0) {
            IdleReason.setIdleReason((IRecipeLogicMachine)this, (IdleReason)IdleReason.INVALID_INPUT);
            return null;
        }
        this.bonusEfficiency = Math.pow(1.25, membraneTier);
        fuelEnergyPerUnit = (long)((double)fuelEnergyPerUnit * this.bonusEfficiency);
        Material electrolytesExisting = null;
        long amountExisting = 0L;
        Material[] electrolyteMaterials = (Material[])Wrapper.ELECTROLYTES_PER_MATERIAL_PER_MILLIBUCKET.keySet().toArray((Object[])new Material[0]);
        long[] cElectrolytesAmounts = this.getFluidAmount((Fluid[])Stream.of(electrolyteMaterials).map(m -> m.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_CATHODE)).toArray(Fluid[]::new));
        long[] aElectrolytesAmounts = this.getFluidAmount((Fluid[])Stream.of(electrolyteMaterials).map(m -> m.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_ANODE)).toArray(Fluid[]::new));
        for (int i = 0; i < cElectrolytesAmounts.length; ++i) {
            if (cElectrolytesAmounts[i] <= 0L || aElectrolytesAmounts[i] <= 0L) continue;
            electrolytesExisting = electrolyteMaterials[i];
            amountExisting = Math.min(cElectrolytesAmounts[i], aElectrolytesAmounts[i]);
            break;
        }
        if (electrolytesExisting == null) {
            return null;
        }
        long euPermB = (Long)Wrapper.ELECTROLYTES_PER_MATERIAL_PER_MILLIBUCKET.get(electrolytesExisting);
        long maxCanAbsorbParallel = amountExisting * euPermB / fuelEnergyPerUnit;
        Recipe result = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)maxCanAbsorbParallel);
        if (result == null) {
            return null;
        }
        long actuallyConsumedmB = result.parallels * fuelEnergyPerUnit / euPermB;
        ArrayList<Content> input = new ArrayList<Content>((Collection)result.inputs.get(FluidRecipeCapability.CAP));
        input.add(new Content((Object)FastFluidIngredient.of((long)actuallyConsumedmB, (Fluid[])new Fluid[]{electrolytesExisting.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_ANODE)}), 10000, 0));
        input.add(new Content((Object)FastFluidIngredient.of((long)actuallyConsumedmB, (Fluid[])new Fluid[]{electrolytesExisting.getFluid(GTOFluidStorageKey.ENERGY_RELEASE_CATHODE)}), 10000, 0));
        ArrayList<Content> output = new ArrayList<Content>();
        output.add(new Content((Object)FastFluidIngredient.of((long)actuallyConsumedmB, (Fluid[])new Fluid[]{electrolytesExisting.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_CATHODE)}), 10000, 0));
        output.add(new Content((Object)FastFluidIngredient.of((long)actuallyConsumedmB, (Fluid[])new Fluid[]{electrolytesExisting.getFluid(GTOFluidStorageKey.ENERGY_STORAGE_ANODE)}), 10000, 0));
        result.inputs.put(FluidRecipeCapability.CAP, input);
        result.outputs.put(FluidRecipeCapability.CAP, output);
        if (!this.canVoidRecipeOutputs((RecipeCapability)FluidRecipeCapability.CAP)) {
            List contents = result.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP);
            List copied = new ArrayList<FluidIngredient>(contents.size());
            for (Content ing : contents) {
                copied.add(((FluidIngredient)ing.content).copy());
            }
            boolean success = false;
            for (IRecipeHandler handler : this.getCapabilitiesFlat(IO.OUT, (RecipeCapability)FluidRecipeCapability.CAP)) {
                copied = handler.handleRecipe(IO.OUT, (GTRecipe)recipe, copied, true);
                if (copied != null && !copied.isEmpty()) continue;
                success = true;
                break;
            }
            if (!success) {
                IdleReason.setIdleReason((IRecipeLogicMachine)this, (IdleReason)IdleReason.OUTPUT_FULL);
                return null;
            }
        }
        return result;
    }

    private Recipe getElectrolyteTransferRecipe(Recipe recipe) {
        if (recipe.data.m_128457_("efficiency") <= 0.0f) {
            return null;
        }
        this.bonusEfficiency = (double)recipe.data.m_128457_("efficiency") * 0.25;
        return ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)Long.MAX_VALUE);
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        if (!this.isGenerator) {
            textList.add((Component)Component.m_237110_((String)FUEL_EFFICIENCY, (Object[])new Object[]{FormattingUtil.formatNumber2Places((double)(this.bonusEfficiency * 400.0)) + "%"}));
        }
    }

    public void afterWorking() {
        super.afterWorking();
        this.bonusEfficiency = 1.0;
    }

    private Recipe getReleaseRecipe(Recipe recipe) {
        ArrayList input = new ArrayList((Collection)recipe.inputs.get(ItemRecipeCapability.CAP));
        if ((double)GTValues.RNG.m_188501_() < chanceConsumeMembraneOnDischarge) {
            Ingredient ingredient = (Ingredient)((Content)input.getFirst()).content;
            this.inputItem((ItemLike)ItemUtils.getFirstSized((Ingredient)ingredient).m_41720_(), ItemUtils.getSizedAmount((Ingredient)ingredient));
        }
        return ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)50L);
    }

    public void setActiveRecipeType(int activeRecipeType) {
        super.setActiveRecipeType(activeRecipeType);
        this.updateGeneratorState();
    }

    public static class Wrapper {
        public static final ImmutableMap<Material, Long> ELECTROLYTES_PER_MATERIAL_PER_MILLIBUCKET = ImmutableMap.builder().put((Object)GTOMaterials.IronChromiumRedoxFlowBatteryElectrolyte, (Object)(GTValues.V[10] * 2L / 1000L)).put((Object)GTOMaterials.VanadiumRedoxFlowBatteryElectrolyte, (Object)(GTValues.V[12] / 1000L)).put((Object)GTOMaterials.ZincIodideFlowBatteryElectrolyte, (Object)(GTValues.V[13] * 2L / 1000L)).put((Object)GTOMaterials.OrganicMoleculeRedoxFlowBatteryElectrolyte, (Object)(GTValues.V[14] * 4L / 1000L)).put((Object)GTOMaterials.SuperconductingIonRedoxFlowBatteryElectrolyte, (Object)(GTValues.V[14] * 32L / 1000L)).put((Object)GTOMaterials.AntimatterRedoxFlowBatteryElectrolyte, (Object)(GTValues.V[14] * 256L / 1000L)).build();
        public static final ObjectList<Material> MEMBRANE_MATS = new ObjectImmutableList((Object[])new Material[]{GTMaterials.Polytetrafluoroethylene, GTMaterials.Graphene, GTOMaterials.PolousPolyolefinSulfonate, GTOMaterials.PerfluorosulfonicAcidPolytetrafluoroethyleneCopolymer, GTOMaterials.CeOxPolyDopamineReinforcedPolytetrafluoroethylene, GTOMaterials.NanocrackRegulatedSelfHumidifyingCompositeMaterial});
    }
}

