/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOItems;
import com.gtolib.api.machine.multiblock.NoEnergyMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class AlgaeFarmMachine
extends NoEnergyMultiblockMachine {
    private static final Fluid FERMENTEDBIOMASS = GTMaterials.FermentedBiomass.getFluid();
    private static final List<Item> ALGAES = List.of((Item)GTOItems.BLUE_ALGAE.get(), (Item)GTOItems.BROWN_ALGAE.get(), (Item)GTOItems.GOLD_ALGAE.get(), (Item)GTOItems.GREEN_ALGAE.get(), (Item)GTOItems.RED_ALGAE.get());

    public AlgaeFarmMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private Recipe getRecipe(ItemStack stack) {
        RecipeBuilder builder = this.getRecipeBuilder().inputFluids(new FluidStack((Fluid)Fluids.f_76193_, 100 * GTValues.RNG.m_188503_(50) + 5000)).duration(200);
        builder.outputItems(stack);
        Recipe recipe = builder.buildRawRecipe();
        if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    @Nullable
    private Recipe getRecipe() {
        boolean raise = this.inputFluid(FERMENTEDBIOMASS, 10000L);
        int amount = raise ? 10 : 1;
        amount += GTValues.RNG.m_188503_(9 * amount);
        AtomicReference<Recipe> recipe = new AtomicReference<Recipe>();
        int finalAmount = amount;
        this.forEachInputItems((stack, a2) -> {
            if (ALGAES.contains(stack.m_41720_())) {
                recipe.set(this.getRecipe(stack.m_255036_((int)((long)finalAmount * Math.max(1L, a2 / 4L)))));
                return true;
            }
            return false;
        });
        if (recipe.get() == null) {
            recipe.set(this.getRecipe(new ItemStack((ItemLike)ALGAES.get(GTValues.RNG.m_188503_(5)), amount)));
        }
        return (Recipe)recipe.get();
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }
}

