/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.noenergy;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gtocore.api.pattern.GTOPredicates;
import com.gtocore.client.renderer.StructurePattern;
import com.gtocore.client.renderer.StructureVBO;
import com.gtocore.common.block.BlockMap;
import com.gtocore.common.data.GTOBlocks;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.multiblock.NoEnergyMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.ClientUtil;
import com.gtolib.utils.MultiBlockFileReader;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class GodForgeMachine
extends NoEnergyMultiblockMachine
implements ITierCasingMachine {
    @DescSynced
    @Persisted
    public float color;
    private boolean isRemoved = false;
    public long rotation;
    public int timer;
    @DescSynced
    @Persisted
    public int tier;
    private final TierCasingTrait tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"g_f"});

    public GodForgeMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public Object2IntMap<String> getCasingTiers() {
        return this.tierCasingTrait.getCasingTiers();
    }

    public void clientTick() {
        super.clientTick();
        if (this.isActive() || (long)this.timer > this.rotation) {
            ++this.rotation;
            this.timer = 20;
            if (!this.isRemoved && this.removeBlockFromWorld()) {
                this.isRemoved = true;
            }
        } else {
            this.timer = 0;
            if (this.rotation > 0L) {
                this.rotation = (this.rotation - 1L) % 180L;
            } else if (this.isRemoved && this.addBlockToWorld()) {
                this.isRemoved = false;
            }
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.color = 1.0f - 0.1f * (float)this.getCasingTier("g_f");
        this.tier = this.getCasingTier("g_f");
    }

    private BlockPos getRealPos(int x, int y, int z) {
        String[][] structure = StructurePattern.ringOne;
        BlockPos.MutableBlockPos pos = BlockPos.f_121853_.m_7918_(122 + structure.length / 2 - x, -structure[0].length / 2 + y, -structure[0][0].length() / 2 + z).m_122032_();
        switch (this.getFrontFacing()) {
            case EAST: {
                pos.m_122178_(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
                break;
            }
            case NORTH: {
                pos.m_122178_(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
                break;
            }
            case SOUTH: {
                pos.m_122178_(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
            }
        }
        return pos.m_121955_((Vec3i)this.getPos());
    }

    private boolean removeBlockFromWorld() {
        String[][] structure = StructurePattern.ringOne;
        for (int x = 0; x < structure.length; ++x) {
            String[] plane = structure[x];
            for (int y = 0; y < plane.length; ++y) {
                String row = plane[y];
                for (int z = 0; z < row.length(); ++z) {
                    char letter = row.charAt(z);
                    if (letter == ' ') continue;
                    BlockPos realPos = this.getRealPos(x, y, z);
                    if (!this.getLevel().m_46749_(realPos)) {
                        return false;
                    }
                    this.getLevel().m_7731_(realPos, Blocks.f_50016_.m_49966_(), 48);
                    ClientUtil.getPreventUpdate((Level)this.getLevel()).add(realPos.m_121878_());
                }
            }
        }
        return true;
    }

    private boolean addBlockToWorld() {
        StructureVBO ringStructure = new StructureVBO().addMapping('B', (Block)GTOBlocks.SINGULARITY_REINFORCED_STELLAR_SHIELDING_CASING.get()).addMapping('C', (Block)GTOBlocks.CELESTIAL_MATTER_GUIDANCE_CASING.get()).addMapping('D', (Block)GTOBlocks.BOUNDLESS_GRAVITATIONALLY_SEVERED_STRUCTURE_CASING.get()).addMapping('E', (Block)GTOBlocks.TRANSCENDENTALLY_AMPLIFIED_MAGNETIC_CONFINEMENT_CASING.get()).addMapping('F', (Block)GTOBlocks.STELLAR_ENERGY_SIPHON_CASING.get()).addMapping('1', (Block)GTOBlocks.REMOTE_GRAVITON_FLOW_MODULATOR.get()).addMapping('2', (Block)GTOBlocks.MEDIAL_GRAVITON_FLOW_MODULATOR.get()).addMapping('3', (Block)GTOBlocks.CENTRAL_GRAVITON_FLOW_MODULATOR.get()).addMapping('H', (Block)GTOBlocks.SPATIALLY_TRANSCENDENT_GRAVITATIONAL_LENS_BLOCK.get());
        String[][] structure = StructurePattern.ringOne;
        if (this.tier == 2) {
            structure = StructurePattern.ringTwo;
        } else if (this.tier == 3) {
            structure = StructurePattern.ringThree;
        }
        ringStructure.assignStructure(structure);
        for (int x = 0; x < structure.length; ++x) {
            String[] plane = structure[x];
            for (int y = 0; y < plane.length; ++y) {
                String row = plane[y];
                for (int z = 0; z < row.length(); ++z) {
                    char letter = row.charAt(z);
                    if (letter == ' ') continue;
                    BlockPos realPos = this.getRealPos(x, y, z);
                    if (!this.getLevel().m_46749_(realPos)) {
                        return false;
                    }
                    BlockState blockState = ((Block)ringStructure.mapper.get(letter)).m_49966_();
                    ClientUtil.getPreventUpdate((Level)this.getLevel()).remove(realPos.m_121878_());
                    this.getLevel().m_7731_(realPos, blockState, 48);
                }
            }
        }
        return true;
    }

    public BlockPattern getPattern() {
        return GodForgeMachine.getBlockPattern(this.getDefinition());
    }

    public static BlockPattern getBlockPattern(MultiblockMachineDefinition definition) {
        return MultiBlockFileReader.start((MultiblockMachineDefinition)definition).where('~', Predicates.controller((MachineDefinition)definition)).where(' ', Predicates.any()).where('A', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.TRANSCENDENTALLY_AMPLIFIED_MAGNETIC_CONFINEMENT_CASING.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(1))).where('B', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SINGULARITY_REINFORCED_STELLAR_SHIELDING_CASING.get()})).where('C', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.CELESTIAL_MATTER_GUIDANCE_CASING.get()})).where('D', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.BOUNDLESS_GRAVITATIONALLY_SEVERED_STRUCTURE_CASING.get()})).where('E', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.TRANSCENDENTALLY_AMPLIFIED_MAGNETIC_CONFINEMENT_CASING.get()})).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.STELLAR_ENERGY_SIPHON_CASING.get()})).where('G', GTOPredicates.tierBlock(BlockMap.GRAVITONFLOWMAP, "g_f")).where('H', Predicates.blocks((Block[])new Block[]{(Block)GTOBlocks.SPATIALLY_TRANSCENDENT_GRAVITATIONAL_LENS_BLOCK.get()})).build();
    }

    private Recipe getRecipe() {
        return this.getRecipeBuilder().inputFluids((Fluid)Fluids.f_76193_, 100L).duration(20).buildRawRecipe();
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }
}

