/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.part;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gtocore.common.data.GTOItems;
import com.gtolib.api.machine.part.WorkableItemPartMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class BallHatchPartMachine
extends WorkableItemPartMachine
implements IInteractedMachine {
    public static final Map<Item, Integer> GRINDBALL;
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean isWorking;

    public BallHatchPartMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, i -> GRINDBALL.containsKey(i.m_41720_()));
    }

    protected void onMachineChanged() {
        for (IMultiController controller : this.getControllers()) {
            if (!(controller instanceof IRecipeLogicMachine)) continue;
            IRecipeLogicMachine recipeLogicMachine = (IRecipeLogicMachine)controller;
            recipeLogicMachine.getRecipeLogic().updateTickSubscription();
        }
    }

    public boolean beforeWorking(IWorkableMultiController controller, GTRecipe recipe) {
        this.isWorking = true;
        return true;
    }

    public void afterWorking(IWorkableMultiController controller) {
        this.isWorking = false;
    }

    public InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isRemote() && this.isWorking && !player.m_7500_()) {
            player.m_6469_(GTDamageTypes.TURBINE.source((LevelAccessor)level), 40.0f);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void onMachineRemoved() {
        if (!this.isWorking) {
            super.onMachineRemoved();
        }
    }

    @Generated
    public boolean isWorking() {
        return this.isWorking;
    }

    static {
        ImmutableMap.Builder grindball = ImmutableMap.builder();
        grindball.put((Object)((Item)GTOItems.GRINDBALL_SOAPSTONE.get()), (Object)1);
        grindball.put((Object)((Item)GTOItems.GRINDBALL_ALUMINIUM.get()), (Object)2);
        GRINDBALL = grindball.build();
    }
}

